/*
 * Decompiled with CFR 0.152.
 */
package com.ed.ecomm.eprocurement.util.migration;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class ModifyXML {
    protected static final Logger log = Logger.getLogger(ModifyXML.class);

    public static Document modifyTS(Document doc, boolean ignoreCheck) throws Exception {
        log.info((Object)"Started Modifying TS");
        if (ignoreCheck || ModifyXML.precheck(doc)) {
            Integer numOfEnvs = 1;
            XPath x = XPath.newInstance((String)"/c4t/@pack-in");
            Attribute numOfEnvsAttr = (Attribute)x.selectSingleNode((Object)doc);
            numOfEnvs = numOfEnvsAttr.getIntValue();
            x = XPath.newInstance((String)"/c4t/@procedure");
            Attribute procedureAttr = (Attribute)x.selectSingleNode((Object)doc);
            String procedure = procedureAttr.getValue().trim();
            Integer round = 1;
            x = XPath.newInstance((String)"/c4t/@round");
            Attribute roundAttr = (Attribute)x.selectSingleNode((Object)doc);
            round = roundAttr.getIntValue();
            x = XPath.newInstance((String)"//envelope");
            List envelopeElems = x.selectNodes((Object)doc);
            long counter = 0L;
            for (Element envelopeElem : envelopeElems) {
                ModifyXML.modifyEnvelope(envelopeElem, numOfEnvs, -1L, counter++, round, procedure);
            }
            ModifyXML.modifyLots(doc);
            log.info((Object)"Ended Modifying TS");
        }
        return doc;
    }

    public static boolean precheck(Document doc) throws Exception {
        boolean shouldProceed = false;
        XPath x = XPath.newInstance((String)"//envelope");
        Element envelopeElem = (Element)x.selectSingleNode((Object)doc);
        if (envelopeElem != null && envelopeElem.getAttributeValue("id") == null) {
            shouldProceed = true;
        }
        log.info((Object)("ignoreChecking if old style TS: " + shouldProceed));
        return shouldProceed;
    }

    public static Document modifyTender(Document tsNewDoc, Document tenderOldDoc, boolean ignoreCheck) throws Exception {
        log.info((Object)"Started Modifying Tender");
        if (ignoreCheck || ModifyXML.precheck(tenderOldDoc)) {
            Integer numOfEnvs = 1;
            XPath x = XPath.newInstance((String)"/c4t/@pack-in");
            Attribute numOfEnvsAttr = (Attribute)x.selectSingleNode((Object)tsNewDoc);
            numOfEnvs = numOfEnvsAttr.getIntValue();
            x = XPath.newInstance((String)"//envelope");
            List envelopeElems = x.selectNodes((Object)tenderOldDoc);
            for (Element envelopeElem : envelopeElems) {
                String envelopePath = ModifyXML.getEnvelopePath("", envelopeElem);
                log.info((Object)("searching in TS for Tender envelope: " + envelopePath));
                x = XPath.newInstance((String)envelopePath);
                Element envelopeTSElem = (Element)x.selectSingleNode((Object)tsNewDoc);
                if (envelopeTSElem == null || !"envelope".equalsIgnoreCase(envelopeTSElem.getName())) continue;
                log.info((Object)("Tender envelope found: " + envelopePath));
                for (Attribute attr : envelopeTSElem.getAttributes()) {
                    log.info((Object)("Attribute: " + attr.getName() + " value: " + attr.getValue()));
                }
                Long tsEnvId = Long.valueOf(envelopeTSElem.getAttributeValue("id"));
                ModifyXML.modifyEnvelope(envelopeElem, numOfEnvs, tsEnvId, -1L, null, null);
            }
            ModifyXML.modifyLots(tenderOldDoc);
            log.info((Object)"Ended Modifying Tender");
        }
        return tenderOldDoc;
    }

    private static String getEnvelopePath(String path, Element envelopeElem) {
        if (envelopeElem != null) {
            String prefix = envelopeElem.getName();
            if (prefix.equalsIgnoreCase("envelope")) {
                prefix = prefix + "[@type='" + envelopeElem.getAttributeValue("type") + "']";
            } else if (prefix.equalsIgnoreCase("lot")) {
                prefix = prefix + "[@id='" + envelopeElem.getAttributeValue("id") + "']";
            }
            path = "/" + prefix + path;
            return ModifyXML.getEnvelopePath(path, envelopeElem.getParentElement());
        }
        return path;
    }

    private static void modifyEnvelope(Element envelopeElem, int numOfEnvs, long id, long counter, Integer cycle, String procedure) {
        String weight;
        String type = envelopeElem.getAttributeValue("type");
        log.info((Object)("modifying envelope: " + type));
        if ("proofDocs".equalsIgnoreCase(type)) {
            envelopeElem.setAttribute("name", "envelope.type.proofDocs");
            envelopeElem.setAttribute("sequence", String.valueOf(1));
            envelopeElem.setAttribute("pos", String.valueOf(1));
            if (Integer.valueOf(1).equals(cycle) && (procedure.equals("restricted") || procedure.equals("accelerated.restricted") || procedure.equals("negotiated") || procedure.equals("negotiated.without.adv") || procedure.equals("accelerated.negotiated") || procedure.equals("competitive.dialogue"))) {
                envelopeElem.setAttribute("weight", "100");
                log.info((Object)"Special proof documents weighted 100% scenario");
            }
        } else if ("technical".equalsIgnoreCase(type)) {
            envelopeElem.setAttribute("name", "envelope.type.technical");
            envelopeElem.setAttribute("sequence", String.valueOf(1));
            envelopeElem.setAttribute("pos", String.valueOf(2));
        } else if ("financial".equalsIgnoreCase(type)) {
            envelopeElem.setAttribute("name", "envelope.type.financial");
            envelopeElem.setAttribute("sequence", String.valueOf(2));
            envelopeElem.setAttribute("pos", String.valueOf(3));
        } else if ("offline".equalsIgnoreCase(type)) {
            envelopeElem.setAttribute("name", "envelope.type.offline");
            envelopeElem.setAttribute("sequence", String.valueOf(1));
            envelopeElem.setAttribute("pos", String.valueOf(1));
        }
        if (id == -1L) {
            id = System.currentTimeMillis() + counter;
        }
        if ((weight = envelopeElem.getAttributeValue("weight")) != null && !"".equals(weight)) {
            envelopeElem.setAttribute("isWeighted", "true");
        } else {
            envelopeElem.setAttribute("isWeighted", "false");
        }
        envelopeElem.setAttribute("id", String.valueOf(id));
        log.info((Object)("envelope moodified: " + type));
    }

    private static void modifyLots(Document doc) throws Exception {
        log.info((Object)"modifying envelope lots ( if any )");
        XPath x = XPath.newInstance((String)"//lot");
        List lotElems = x.selectNodes((Object)doc);
        for (Element lotElem : lotElems) {
            String id = lotElem.getAttributeValue("id");
            if (id == null || id.trim().equals("")) continue;
            int newPos = Integer.valueOf(id) + 1;
            lotElem.setAttribute("pos", String.valueOf(newPos));
            log.info((Object)("lot: " + id + " pos: " + newPos));
        }
        log.info((Object)"modified envelope lots ( if any )");
    }

    public static void main(String[] args) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((InputStream)new FileInputStream("c4t_18903_1.xml"));
        doc = ModifyXML.modifyTS(doc, true);
        XMLOutputter outputter = new XMLOutputter();
        outputter.output(doc, (OutputStream)new FileOutputStream("new-c4t_18903_1.xml"));
    }
}

