/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t;

import com.eurodyn.eprocurement.tools.c4t.AppletSingleton;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.FileUtils;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;

public class C4TAppletUtil {
    private URLConnection connection;
    private boolean status;
    private static final String defaultContextPath = "ldaepps";
    private String servletName = "tenderServlet";

    public C4TAppletUtil(String hostName, String hostPort, String protocol) {
        this(hostName, hostPort, protocol, defaultContextPath);
    }

    public C4TAppletUtil(String hostName, String hostPort, String protocol, String contextPath) {
        try {
            this.setConnection(this.getServletConnection(hostName, hostPort, protocol, contextPath));
            this.status = true;
        }
        catch (Exception e) {
            this.status = false;
        }
    }

    public void sendDataToServlet(Object[] data) throws IOException {
        this.sendDataToServlet(this.getConnection(), data);
    }

    public void sendDataToServlet(Object dtr) throws IOException {
        Object[] parcel = new Object[]{dtr};
        this.sendDataToServlet(this.getConnection(), parcel);
    }

    public File getResponseFromServletFile() throws IOException, ClassNotFoundException {
        int len;
        URLConnection con = this.getConnection();
        InputStream instr = con.getInputStream();
        String userHome = System.getProperty("user.home");
        String separator = System.getProperty("file.separator");
        System.out.println("default tender file = " + userHome + separator + "tenderTemplateFile" + System.currentTimeMillis() + ".xml");
        String fileName = userHome + separator + "tenderTemplateFile" + System.currentTimeMillis() + ".xml";
        File tenderTemplateFile = new File(fileName);
        FileOutputStream tenderTemplateFileOS = new FileOutputStream(tenderTemplateFile);
        byte[] buf = new byte[1024];
        while ((len = instr.read(buf)) > 0) {
            tenderTemplateFileOS.write(buf, 0, len);
        }
        tenderTemplateFileOS.close();
        instr.close();
        return tenderTemplateFile;
    }

    public File getResponseFromServletZip() throws IOException {
        int len;
        URLConnection con = this.getConnection();
        InputStream instr = con.getInputStream();
        String userHome = System.getProperty("user.home");
        String fileName = "";
        fileName = AppletSingleton.getInstance().getIsSpecificContract() != false ? userHome + File.separator + "tender_" + System.currentTimeMillis() : userHome + File.separator + "copy_of_DPS_indicative_tender_" + System.currentTimeMillis();
        System.out.println("storing tender zip to user home as " + fileName);
        FileOutputStream fos = new FileOutputStream(new File(fileName + ".zip"));
        byte[] buf = new byte[1024];
        while ((len = instr.read(buf)) > 0) {
            fos.write(buf, 0, len);
        }
        fos.close();
        instr.close();
        FileUtils.unzip(fileName + ".zip");
        File tenderFolder = new File(fileName);
        File tenderXmlFile = null;
        String[] children = tenderFolder.list();
        System.out.println("children: " + children);
        for (String child : children) {
            System.out.println("child: " + child);
            if (!child.endsWith(".xml")) continue;
            System.out.println("fileName + separator + child: " + fileName + File.separator + child);
            tenderXmlFile = new File(fileName + File.separator + child);
            break;
        }
        return tenderXmlFile;
    }

    public String getResponseFromServletPath() throws IOException, ClassNotFoundException {
        URLConnection con = this.getConnection();
        InputStream instr = con.getInputStream();
        ObjectInputStream inputFromServlet = new ObjectInputStream(instr);
        Object obj = inputFromServlet.readObject();
        String filePath = (String)obj;
        instr.close();
        return filePath;
    }

    public Long getResponseFromServletTenderId() throws IOException, ClassNotFoundException {
        URLConnection con = this.getConnection();
        InputStream instr = con.getInputStream();
        ObjectInputStream inputFromServlet = new ObjectInputStream(instr);
        Object obj = inputFromServlet.readObject();
        Long TenderId = (Long)obj;
        instr.close();
        return TenderId;
    }

    private void sendDataToServlet(URLConnection con, Object[] data) throws IOException {
        OutputStream os = con.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        for (int i = 0; i < data.length; ++i) {
            oos.writeObject(data[i]);
        }
        oos.flush();
        oos.close();
    }

    private URLConnection getServletConnection(String hostName, String hostPort, String protocol, String contextPath) throws IOException {
        String url = protocol + "://" + hostName + hostPort + "/" + contextPath + "/" + this.servletName;
        System.out.println("url = " + url);
        URL secureServlet = new URL(url);
        System.out.println("conection protoocol = " + secureServlet.getProtocol());
        System.out.println("conection port = " + secureServlet.getPort());
        System.out.println("conection host = " + secureServlet.getHost());
        System.out.println("conection path = " + secureServlet.getPath());
        System.out.println("conection auth = " + secureServlet.getAuthority());
        URLConnection con = secureServlet.openConnection();
        System.out.println("secureServlet" + secureServlet.getHost());
        if (secureServlet.getProtocol().equalsIgnoreCase("https")) {
            Security.addProvider((java.security.Provider)new Provider());
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            System.out.println("conection auth 2 = " + secureServlet.getAuthority());
        }
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        return con;
    }

    public void setConnection(URLConnection connection) {
        this.connection = connection;
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    public boolean isStatus() {
        return this.status;
    }
}

