/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t;

import com.eurodyn.eprocurement.tools.c4t.ActionListenerCreator;
import com.eurodyn.eprocurement.tools.c4t.C4TFrameForm;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.JTreeC4TCompopnentType;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.JTreeC4TCompopnentFactory;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.CustomTreeCellRenderer;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNodeState;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.tree.VetoableTreeSelectionModel;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.ImageC4TUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TBody;
import java.awt.Container;
import java.awt.Insets;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;

public class CommonFormHelper {
    public static final Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);
    protected JButton openItemButton;
    protected JButton saveItemButton;
    protected JButton saveAsItemButton;
    protected JButton packItemButton;
    protected JButton informationItemButton;
    protected JButton helpItemButton;
    protected JButton confItemButton;
    protected JButton pdfCreateItemButton;
    protected JButton validationItemButton;

    public JToolBar createToolBar(ActionListenerCreator creator, boolean enableAfterOpenButtons) {
        JToolBar jToolBar = new JToolBar();
        this.initializeButtons(creator, enableAfterOpenButtons);
        jToolBar.add(this.openItemButton);
        jToolBar.add(this.saveItemButton);
        jToolBar.add(this.saveAsItemButton);
        jToolBar.add(this.validationItemButton);
        jToolBar.add(this.packItemButton);
        jToolBar.add(this.pdfCreateItemButton);
        jToolBar.addSeparator();
        if (C4TApplicationResources.getBooleanProperty("version.control.enabled", false) && creator instanceof C4TFrameForm) {
            jToolBar.add(this.confItemButton);
        }
        jToolBar.add(this.helpItemButton);
        jToolBar.add(this.informationItemButton);
        jToolBar.setMargin(DEFAULT_INSETS);
        jToolBar.setFloatable(false);
        jToolBar.setAlignmentX(0.0f);
        return jToolBar;
    }

    protected void initializeButtons(ActionListenerCreator creator, boolean enableAfterOpenButtons) {
        this.openItemButton = this.createDefaultButton();
        this.openItemButton.setIcon(ImageC4TUtils.getImageIconToolbar(8));
        this.openItemButton.setToolTipText(C4TApplicationResources.getLabel("label.open.new"));
        this.saveItemButton = this.createDefaultButton();
        this.saveItemButton.setIcon(ImageC4TUtils.getImageIconToolbar(10));
        this.saveItemButton.setToolTipText(C4TApplicationResources.getLabel("menu.file.save"));
        this.saveItemButton.setEnabled(enableAfterOpenButtons);
        this.validationItemButton = this.createDefaultButton();
        this.validationItemButton.setIcon(ImageC4TUtils.getImageIconToolbar(11));
        this.validationItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.validation"));
        this.validationItemButton.setEnabled(enableAfterOpenButtons);
        this.packItemButton = this.createDefaultButton();
        this.packItemButton.setIcon(ImageC4TUtils.getImageIconToolbar(2));
        this.packItemButton.setToolTipText(C4TApplicationResources.getLabel("menu.file.pack"));
        this.packItemButton.setEnabled(enableAfterOpenButtons);
        this.saveAsItemButton = this.createDefaultButton();
        this.saveAsItemButton.setIcon(ImageC4TUtils.getImageIconToolbar(9));
        this.saveAsItemButton.setToolTipText(C4TApplicationResources.getLabel("menu.file.saveAs"));
        this.saveAsItemButton.setEnabled(enableAfterOpenButtons);
        this.pdfCreateItemButton = this.createDefaultButton();
        this.pdfCreateItemButton.setIcon(ImageC4TUtils.getImageIconToolbar(1));
        this.pdfCreateItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.pdfCreate"));
        this.confItemButton = this.createDefaultButton();
        this.confItemButton.setIcon(ImageC4TUtils.getImageIconToolbar(13));
        this.confItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.configuration"));
        this.helpItemButton = this.createDefaultButton();
        this.helpItemButton.setIcon(ImageC4TUtils.getImageIconToolbar(5));
        this.helpItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.help"));
        this.informationItemButton = this.createDefaultButton();
        this.informationItemButton.setIcon(ImageC4TUtils.getImageIconToolbar(6));
        this.informationItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.information"));
        this.initButtonsActionListeners(creator);
    }

    protected void initButtonsActionListeners(ActionListenerCreator creator) {
        this.openItemButton.addActionListener(creator.createOpenFileActionListener());
        this.saveItemButton.addActionListener(creator.createSaveFileActionListener());
        this.validationItemButton.addActionListener(creator.createValidateActionListener());
        this.packItemButton.addActionListener(creator.createPackActionListener());
        this.saveAsItemButton.addActionListener(creator.createSaveAsActionListener());
        this.pdfCreateItemButton.addActionListener(creator.createPDFGenerationActionListener());
        this.confItemButton.addActionListener(creator.createConfigurationActionListener());
        this.helpItemButton.addActionListener(creator.createHelpActionListener());
        this.informationItemButton.addActionListener(creator.createInformationActionListener());
    }

    public void updateJFileChoserLookAndFeel(JFileChooser fileChooser) {
        try {
            if (!(UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel") || UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") || UIManager.getSystemLookAndFeelClassName().equals(UIManager.getLookAndFeel().getClass().getName()))) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.updateComponentTreeUI(fileChooser);
        UIManager.put("FileChooser.acceptAllFileFilterText", C4TApplicationResources.getLabel("label.all.files"));
        UIManager.put("FileChooser.cancelButtonText", C4TApplicationResources.getLabel("label.cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", C4TApplicationResources.getLabel("label.cancel"));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", C4TApplicationResources.getLabel("label.details"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", C4TApplicationResources.getLabel("label.details"));
        UIManager.put("FileChooser.directoryOpenButtonText", C4TApplicationResources.getLabel("menu.file.open"));
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", C4TApplicationResources.getLabel("menu.file.open"));
        UIManager.put("FileChooser.enterFilenameLabelText", C4TApplicationResources.getLabel("label.file.name"));
        UIManager.put("FileChooser.fileNameLabelText", C4TApplicationResources.getLabel("label.file.name"));
        UIManager.put("FileChooser.fileNameLabelText", C4TApplicationResources.getLabel("label.file.name"));
        UIManager.put("FileChooser.homeFolderAccessibleName", C4TApplicationResources.getLabel("label.desktop"));
        UIManager.put("FileChooser.homeFolderToolTipText", C4TApplicationResources.getLabel("label.desktop"));
        UIManager.put("FileChooser.listViewButtonAccessibleName", C4TApplicationResources.getLabel("label.list"));
        UIManager.put("FileChooser.listViewButtonToolTipText", C4TApplicationResources.getLabel("label.list"));
        UIManager.put("FileChooser.lookInLabelText", C4TApplicationResources.getLabel("label.look.in"));
        UIManager.put("FileChooser.newFolderToolTipText", C4TApplicationResources.getLabel("label.create.new.folder"));
        UIManager.put("FileChooser.openButtonText", C4TApplicationResources.getLabel("menu.file.open"));
        UIManager.put("FileChooser.openButtonToolTipText", C4TApplicationResources.getLabel("menu.file.open"));
        UIManager.put("FileChooser.saveButtonText", C4TApplicationResources.getLabel("menu.file.save"));
        UIManager.put("FileChooser.saveButtonToolTipText", C4TApplicationResources.getLabel("menu.file.save"));
        UIManager.put("FileChooser.upFolderAccessibleName", C4TApplicationResources.getLabel("label.up.one.level"));
        UIManager.put("FileChooser.upFolderToolTipText", C4TApplicationResources.getLabel("label.up.one.level"));
        UIManager.put("FileChooser.filesOfTypeLabelText", C4TApplicationResources.getLabel("label.files.of.type"));
        UIManager.put("FileChooser.saveInLabelText", C4TApplicationResources.getLabel("label.save.in"));
        UIManager.put("FileChooser.saveDialogTitleText", C4TApplicationResources.getLabel("label.button.save"));
        UIManager.put("FileChooser.openDialogTitleText", C4TApplicationResources.getLabel("menu.file.open"));
        if (fileChooser != null) {
            fileChooser.updateUI();
            JPanel jp1 = (JPanel)fileChooser.getComponents()[0];
            JPanel jp11 = (JPanel)jp1.getComponents()[0];
            JButton jb = (JButton)jp11.getComponents()[2];
            jb.setToolTipText(C4TApplicationResources.getLabel("label.desktop"));
        }
    }

    public void enableButtonsAfterOpen() {
        this.saveItemButton.setEnabled(true);
        this.saveAsItemButton.setEnabled(true);
        this.packItemButton.setEnabled(true);
        this.validationItemButton.setEnabled(true);
    }

    public void updateMaxTenderPackageSizeWarnning(JToolBar toolBar, C4TBody body) {
    }

    public C4TTreeNode createDefaultRoot() {
        C4TBody start = new C4TBody("Start");
        C4TTreeNode defaultRoot = new C4TTreeNode(start);
        C4TTreeNodeState state = new C4TTreeNodeState(JTreeC4TCompopnentType.C4TBody, C4TTreeNodeState.C4TTreeNodeHasCriterions.NotSupported, C4TTreeNodeState.C4TTreeNodeIsCompleted.NotSupported);
        defaultRoot.setState(state);
        return defaultRoot;
    }

    protected JButton createDefaultButton() {
        JButton result = new JButton();
        result.setMargin(DEFAULT_INSETS);
        result.setBorderPainted(false);
        return result;
    }

    public JTree createXmlTree(C4TTreeNode defaultRoot, ActionListenerCreator creator) {
        JTree resultTree = new JTree(defaultRoot);
        resultTree.setSelectionModel(new VetoableTreeSelectionModel());
        resultTree.setCellRenderer(new CustomTreeCellRenderer(resultTree));
        resultTree.addTreeExpansionListener(creator.createTreeExpansionListener());
        resultTree.addTreeSelectionListener(creator.createTreeSelectionListener());
        resultTree.addTreeWillExpandListener(creator.createTreeWillExpandListener());
        return resultTree;
    }

    public void xmlTreeValueChanged(TreeSelectionEvent evt, JTree xmlTree, JTextArea textArea, JPanel dataPane, Container container) {
        C4TTreeNode node = (C4TTreeNode)xmlTree.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() != null) {
            textArea.setText(node.toString());
            node.setVisited();
            dataPane = JTreeC4TCompopnentFactory.getC4TSectionComponent(node, xmlTree);
            dataPane.setVisible(true);
            JSplitPane splitPane = (JSplitPane)container.getComponent(1);
            int tmpDiv = splitPane.getDividerLocation();
            splitPane.setRightComponent(dataPane);
            splitPane.setDividerLocation(tmpDiv);
            container.validate();
        }
    }

    public void helpAction() {
        HelpSet helpSet;
        String pathToHS = C4TApplicationResources.getHelpPath();
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL helpSetURL = classLoader.getResource(pathToHS);
        try {
            helpSet = new HelpSet(classLoader, helpSetURL);
        }
        catch (Exception ee) {
            System.out.println("HelpSet " + ee.getMessage());
            ee.printStackTrace();
            System.out.println("Help Set not found");
            return;
        }
        HelpBroker helpBroker = helpSet.createHelpBroker();
        helpBroker.setDisplayed(true);
    }

    protected void intializeToolbarToolTips() {
        this.openItemButton.setToolTipText(C4TApplicationResources.getLabel("label.open.new"));
        this.saveItemButton.setToolTipText(C4TApplicationResources.getLabel("menu.file.save"));
        this.saveAsItemButton.setToolTipText(C4TApplicationResources.getLabel("menu.file.saveAs"));
        this.validationItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.validation"));
        this.packItemButton.setToolTipText(C4TApplicationResources.getLabel("menu.file.pack"));
        this.pdfCreateItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.pdfCreate"));
        this.confItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.configuration"));
        this.helpItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.help"));
        this.informationItemButton.setToolTipText(C4TApplicationResources.getLabel("toolbar.information"));
    }
}

