/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.factory;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.C4TCriterionType;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.C4TCriterionListFactory;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.CriterionRelevantDocPanel;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PanelUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.AttachmentFileView;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEventsProducer;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SimpleFilter;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.TreeNodesUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.text.NumericCriterionFiledVerifier;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.text.TextAreaCriterionFiledVerifier;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.tree.VetoableTreeSelectionModel;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.FileUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.JFileChooserUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.JTreeC4TComponentUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.TextWrapLabelUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TSection;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.JTreeC4TCompopnent;
import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JCalendar;
import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JSpinnerDateEditor;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class C4TCriterionFactory {
    public static final String PROVIDED_BY_EVALUATOR = "label.criterion.filled.by.evaluator";
    private static Dimension longField = new Dimension(200, 20);

    public static JPanel getC4TSectionComponent(C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        C4TCriterionType criterionType = C4TCriterionFactory.figureOutCriterionType(criterion);
        switch (criterionType) {
            case Text: {
                return C4TCriterionFactory.getPanelForText(criterion, node, xmlTree);
            }
            case Area: {
                return C4TCriterionFactory.getPanelForArea(criterion, node, xmlTree);
            }
            case Numeric: {
                return C4TCriterionFactory.getPanelForNumeric(criterion, node, xmlTree);
            }
            case Date: {
                return C4TCriterionFactory.getPanelForDate(criterion, node, xmlTree);
            }
            case Daterange: {
                return C4TCriterionFactory.getPanelForDaterange(criterion, node, xmlTree);
            }
            case File: {
                return C4TCriterionFactory.getPanelForFile(criterion, node, xmlTree);
            }
            case List: {
                return C4TCriterionFactory.getPanelForList(criterion, node, xmlTree);
            }
        }
        return new JPanel();
    }

    public static C4TCriterionType figureOutCriterionType(C4TCriterion criterion) {
        if (criterion.getType().equalsIgnoreCase("TEXT")) {
            return C4TCriterionType.Text;
        }
        if (criterion.getType().equalsIgnoreCase("AREA")) {
            return C4TCriterionType.Area;
        }
        if (criterion.getType().equalsIgnoreCase("NUMERIC")) {
            return C4TCriterionType.Numeric;
        }
        if (criterion.getType().equalsIgnoreCase("DATE")) {
            return C4TCriterionType.Date;
        }
        if (criterion.getType().equalsIgnoreCase("DATE_RANGE")) {
            return C4TCriterionType.Daterange;
        }
        if (criterion.getType().equalsIgnoreCase("FILE")) {
            return C4TCriterionType.File;
        }
        if (criterion.getType().equalsIgnoreCase("LIST")) {
            return C4TCriterionType.List;
        }
        return C4TCriterionType.Error;
    }

    public static boolean isMandatoryAndNotReadOnly(C4TCriterion criterion) {
        return criterion.getMandatory() != 0 && criterion.getSupplierReadOnly() == false;
    }

    private static JPanel getPanelForText(C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BoxLayout(currentPanel, 1));
        currentPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 5, 15));
        JLabel header = new JLabel();
        header.setFont(PanelUtils.fontSansSerif);
        JPanel subPanelH = new JPanel();
        subPanelH.setLayout(new BoxLayout(subPanelH, 0));
        subPanelH.add(header);
        subPanelH.add(Box.createHorizontalGlue());
        currentPanel.add(subPanelH);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JTextField txt1 = new JTextField();
        txt1.setPreferredSize(longField);
        txt1.setMaximumSize(longField);
        txt1.setText(C4TXStreamUtil.convertStringToUTF(criterion.getValue()));
        if (criterion.getSupplierReadOnly().booleanValue()) {
            txt1.setText(C4TApplicationResources.getLabel(PROVIDED_BY_EVALUATOR));
            txt1.setEditable(false);
        } else {
            VetoableChangeListener vcl = C4TCriterionFactory.getTextVetoableChangeListener(criterion, txt1, xmlTree);
            VetoableTreeSelectionModel model = (VetoableTreeSelectionModel)xmlTree.getSelectionModel();
            model.addSeletionChangedVetoListener(vcl);
            txt1.setInputVerifier(new TextAreaCriterionFiledVerifier(criterion));
            FocusListener fListener = C4TCriterionFactory.getFocusListener(criterion, node, xmlTree, subPanel, txt1);
            txt1.addFocusListener(fListener);
        }
        subPanel.add(txt1);
        JLabel labelMaxCharacters = new JLabel();
        labelMaxCharacters.setText(" " + C4TApplicationResources.getLabel("label.criterion.number.max.characters") + ": " + (criterion.getSize() == null ? "" : criterion.getSize()));
        labelMaxCharacters.setFont(PanelUtils.fontSansSerif);
        boolean mandatory = C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion);
        TextWrapLabelUtil.wrapLabelText(header, (mandatory ? "* " : "") + C4TXStreamUtil.convertStringToUTF(criterion.getLabel()), TextWrapLabelUtil.headerWidth);
        if (mandatory) {
            subPanelH.setBackground(PanelUtils.mandatoryPanelColorBackground);
            header.setForeground(PanelUtils.mandatoryPanelColorForeground);
            currentPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
            subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
            labelMaxCharacters.setForeground(PanelUtils.panelColorForeground);
        } else {
            subPanelH.setBackground(PanelUtils.panelColorBackground);
            currentPanel.setBackground(PanelUtils.panelColorBackground);
            subPanel.setBackground(PanelUtils.panelColorBackground);
        }
        subPanel.add(labelMaxCharacters);
        subPanel.add(Box.createHorizontalGlue());
        PanelUtils.isPassed(criterion, subPanel, 3, false);
        currentPanel.add(subPanel);
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            currentPanel.add(new CriterionRelevantDocPanel(criterion));
        }
        return currentPanel;
    }

    private static FocusListener getFocusListener(final C4TCriterion criterion, final C4TTreeNode node, final JTree xmlTree, final JPanel subPanel, final JTextComponent txt1) {
        FocusListener fListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                criterion.setValue(C4TXStreamUtil.convertStringToISO_8859_1(txt1.getText()));
                TreeNodesUtil.refreshSelectedPath(node);
                xmlTree.updateUI();
                PanelUtils.isPassed(criterion, subPanel, 3, true);
            }
        };
        return fListener;
    }

    private static VetoableChangeListener getTextVetoableChangeListener(final C4TCriterion criterion, final JTextField txt1, final JTree xmlTree) {
        VetoableChangeListener vcl = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
                String text = txt1.getText();
                if (text != null && text.length() != 0) {
                    boolean isValid = true;
                    if (criterion.getSize() != null && criterion.getSize().getValue() > 0 && text.length() > criterion.getSize().getValue()) {
                        isValid = false;
                    }
                    if (!isValid) {
                        throw new PropertyVetoException("Range out", arg0);
                    }
                }
                String isoText = C4TXStreamUtil.convertStringToISO_8859_1(txt1.getText());
                criterion.setValue(isoText);
                JTreeC4TComponentUtils.propagateTextValueToCriteria((C4TTreeNode)xmlTree.getModel().getRoot(), criterion.getMasterId(), isoText);
            }
        };
        return vcl;
    }

    private static JPanel getPanelForArea(final C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        int defaultCols = 20;
        int defaultRows = 20;
        if (criterion.getCols() != null && criterion.getCols().getValue() > 0) {
            defaultCols = criterion.getCols().getValue();
        }
        if (criterion.getRows() != null && criterion.getRows().getValue() > 0) {
            defaultRows = criterion.getRows().getValue();
        }
        Dimension localLongField = new Dimension(15 * defaultCols, 20 * (defaultRows - 1));
        Dimension longFieldPlus = new Dimension(15 * (defaultCols + 1), 20 * defaultRows);
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BoxLayout(currentPanel, 1));
        currentPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 5, 15));
        JLabel header = new JLabel();
        header.setFont(PanelUtils.fontSansSerif);
        JPanel subPanelH = new JPanel();
        subPanelH.setLayout(new BoxLayout(subPanelH, 0));
        subPanelH.add(header);
        subPanelH.add(Box.createHorizontalGlue());
        currentPanel.add(subPanelH);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JTextArea txt1 = new JTextArea(defaultRows, defaultCols);
        txt1.setText(C4TXStreamUtil.convertStringToUTF(criterion.getValue()));
        if (criterion.getSupplierReadOnly().booleanValue()) {
            txt1.setEditable(false);
            txt1.setText(C4TApplicationResources.getLabel(PROVIDED_BY_EVALUATOR));
        } else {
            VetoableChangeListener vcl = C4TCriterionFactory.getTextAreaVetoableChangeListener(criterion, txt1, xmlTree);
            VetoableTreeSelectionModel model = (VetoableTreeSelectionModel)xmlTree.getSelectionModel();
            model.addSeletionChangedVetoListener(vcl);
            txt1.setInputVerifier(new TextAreaCriterionFiledVerifier(criterion));
            FocusListener fListener = C4TCriterionFactory.getFocusListener(criterion, node, xmlTree, subPanel, txt1);
            txt1.addFocusListener(fListener);
        }
        txt1.setWrapStyleWord(Boolean.TRUE);
        txt1.setLineWrap(Boolean.TRUE);
        txt1.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                Document doc = e.getDocument();
                if (doc.getLength() > criterion.getSize().getValue()) {
                    FocusManager.getCurrentManager().focusNextComponent();
                }
            }

            public void removeUpdate(DocumentEvent e) {
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        JScrollPane jScrollPane1 = new JScrollPane(txt1);
        jScrollPane1.setMinimumSize(localLongField);
        jScrollPane1.setMaximumSize(longFieldPlus);
        subPanel.add(jScrollPane1);
        JLabel labelMaxCharacters = new JLabel();
        labelMaxCharacters.setText(" " + C4TApplicationResources.getLabel("label.criterion.number.max.characters") + ": " + (criterion.getSize() == null ? "" : criterion.getSize()));
        labelMaxCharacters.setFont(PanelUtils.fontSansSerif);
        boolean mandatory = C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion);
        TextWrapLabelUtil.wrapLabelText(header, (mandatory ? "* " : "") + C4TXStreamUtil.convertStringToUTF(criterion.getLabel()), TextWrapLabelUtil.headerWidth);
        if (mandatory) {
            currentPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
            labelMaxCharacters.setForeground(PanelUtils.panelColorForeground);
            subPanelH.setBackground(PanelUtils.mandatoryPanelColorBackground);
            header.setForeground(PanelUtils.mandatoryPanelColorForeground);
            subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
        } else {
            currentPanel.setBackground(PanelUtils.panelColorBackground);
            subPanelH.setBackground(PanelUtils.panelColorBackground);
            subPanel.setBackground(PanelUtils.panelColorBackground);
        }
        subPanel.add(labelMaxCharacters);
        subPanel.add(Box.createHorizontalGlue());
        PanelUtils.isPassed(criterion, subPanel, 3, false);
        currentPanel.add(subPanel);
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            currentPanel.add(new CriterionRelevantDocPanel(criterion));
        }
        return currentPanel;
    }

    private static VetoableChangeListener getTextAreaVetoableChangeListener(final C4TCriterion criterion, final JTextArea txt1, final JTree xmlTree) {
        VetoableChangeListener vcl = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
                String text = txt1.getText();
                if (text != null && text.length() != 0) {
                    boolean isValid = true;
                    if (criterion.getSize() != null && criterion.getSize().getValue() > 0 && text.length() > criterion.getSize().getValue()) {
                        isValid = false;
                    }
                    if (!isValid) {
                        throw new PropertyVetoException("Range out", arg0);
                    }
                }
                String isoText = C4TXStreamUtil.convertStringToISO_8859_1(txt1.getText());
                criterion.setValue(isoText);
                JTreeC4TComponentUtils.propagateTextValueToCriteria((C4TTreeNode)xmlTree.getModel().getRoot(), criterion.getMasterId(), isoText);
            }
        };
        return vcl;
    }

    private static JPanel getPanelForNumeric(C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BoxLayout(currentPanel, 1));
        currentPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 5, 15));
        JLabel header = new JLabel();
        header.setFont(PanelUtils.fontSansSerif);
        JPanel subPanelH = new JPanel();
        subPanelH.setLayout(new BoxLayout(subPanelH, 0));
        subPanelH.add(header);
        subPanelH.add(Box.createHorizontalGlue());
        currentPanel.add(subPanelH);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JTextField txt1 = new JTextField();
        txt1.setPreferredSize(longField);
        txt1.setMaximumSize(longField);
        txt1.setText(C4TXStreamUtil.convertStringToUTF(criterion.getValue()));
        if (criterion.getSupplierReadOnly().booleanValue()) {
            txt1.setEditable(false);
            txt1.setText(C4TApplicationResources.getLabel(PROVIDED_BY_EVALUATOR));
        } else {
            VetoableChangeListener vcl = C4TCriterionFactory.getNumericVetoableChangeListener(criterion, txt1, xmlTree);
            VetoableTreeSelectionModel model = (VetoableTreeSelectionModel)xmlTree.getSelectionModel();
            model.addSeletionChangedVetoListener(vcl);
            FocusListener fListener = C4TCriterionFactory.getFocusListener(criterion, node, xmlTree, subPanel, txt1);
            txt1.addFocusListener(fListener);
            txt1.setInputVerifier(new NumericCriterionFiledVerifier(criterion));
        }
        subPanel.add(txt1);
        JLabel labelNumeric = new JLabel();
        String min = criterion.getMin() == null ? "" : criterion.getMin().toString();
        String max = criterion.getMax() == null ? "" : criterion.getMax().toString();
        String step = criterion.getStep() == null ? "" : criterion.getStep().toString();
        labelNumeric.setFont(PanelUtils.fontSansSerif);
        labelNumeric.setText(" " + (criterion.getUnit() == null ? "" : criterion.getUnit() + " | ") + C4TApplicationResources.getLabel("label.criterion.number.minimum") + ": " + min + " | " + C4TApplicationResources.getLabel("label.criterion.number.maximum") + ": " + max + " | " + C4TApplicationResources.getLabel("label.criterion.number.step") + ": " + step);
        boolean mandatory = C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion);
        TextWrapLabelUtil.wrapLabelText(header, (mandatory ? "* " : "") + C4TXStreamUtil.convertStringToUTF(criterion.getLabel()), TextWrapLabelUtil.headerWidth);
        if (mandatory) {
            currentPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
            labelNumeric.setForeground(PanelUtils.panelColorForeground);
            subPanelH.setBackground(PanelUtils.mandatoryPanelColorBackground);
            header.setForeground(PanelUtils.mandatoryPanelColorForeground);
            subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
        } else {
            currentPanel.setBackground(PanelUtils.panelColorBackground);
            subPanelH.setBackground(PanelUtils.panelColorBackground);
            subPanel.setBackground(PanelUtils.panelColorBackground);
        }
        subPanel.add(labelNumeric);
        subPanel.add(Box.createHorizontalGlue());
        PanelUtils.isPassed(criterion, subPanel, 3, false);
        currentPanel.add(subPanel);
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            currentPanel.add(new CriterionRelevantDocPanel(criterion));
        }
        return currentPanel;
    }

    private static VetoableChangeListener getNumericVetoableChangeListener(final C4TCriterion criterion, final JTextField txt1, final JTree xmlTree) {
        VetoableChangeListener vcl = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
                String text = txt1.getText();
                if (text != null && text.length() != 0) {
                    try {
                        BigDecimal newValue = new BigDecimal(text);
                        boolean inRange = true;
                        if (criterion.getMax() != null && criterion.getMax().getIsPresent().booleanValue() && newValue.compareTo(criterion.getMax().getValue()) == 1) {
                            inRange = false;
                        }
                        if (inRange && criterion.getMin() != null && criterion.getMin().getIsPresent().booleanValue()) {
                            if (inRange && newValue.compareTo(criterion.getMin().getValue()) == -1) {
                                inRange = false;
                            } else if (criterion.getStep() != null && criterion.getStep().getValue().compareTo(new BigDecimal("0")) == 1 && newValue.subtract(criterion.getMin().getValue()).remainder(criterion.getStep().getValue()).compareTo(new BigDecimal("0")) != 0) {
                                throw new PropertyVetoException("Step wrong", arg0);
                            }
                        }
                        if (!inRange) {
                            throw new PropertyVetoException("Range out", arg0);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new PropertyVetoException("Not number", arg0);
                    }
                }
                criterion.setValue(txt1.getText());
                JTreeC4TComponentUtils.propagateTextValueToCriteria((C4TTreeNode)xmlTree.getModel().getRoot(), criterion.getMasterId(), txt1.getText());
            }
        };
        return vcl;
    }

    private static JPanel getPanelForDate(final C4TCriterion criterion, final C4TTreeNode node, final JTree xmlTree) {
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        Dimension dateField = new Dimension(140, 20);
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BoxLayout(currentPanel, 1));
        currentPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 5, 15));
        JLabel header = new JLabel();
        header.setFont(PanelUtils.fontSansSerif);
        JPanel subPanelH = new JPanel();
        subPanelH.setLayout(new BoxLayout(subPanelH, 0));
        subPanelH.add(header);
        subPanelH.add(Box.createHorizontalGlue());
        currentPanel.add(subPanelH);
        Date date = null;
        final SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        if (criterion.getValue() != null) {
            try {
                date = df.parse(criterion.getValue());
            }
            catch (ParseException pex) {
                System.out.println("Expected date error: id = " + criterion.getId());
            }
        }
        boolean isChanged = false;
        Calendar cal = GregorianCalendar.getInstance();
        if (criterion.getFrom() != null) {
            cal.setTime(criterion.getFrom());
            isChanged = true;
        } else if (criterion.getTo() != null) {
            cal.setTime(criterion.getTo());
            isChanged = true;
        }
        System.out.println("Dte from - one day = " + cal.getTime());
        JCalendar jCal = new JCalendar(cal.getTime(), true);
        JSpinnerDateEditor jEditor = new JSpinnerDateEditor();
        if (isChanged) {
            jEditor.setDate(cal.getTime());
        }
        final JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        boolean mandatory = C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion);
        TextWrapLabelUtil.wrapLabelText(header, (mandatory ? "* " : "") + C4TXStreamUtil.convertStringToUTF(criterion.getLabel()), TextWrapLabelUtil.headerWidth);
        if (mandatory) {
            currentPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
            subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
            subPanelH.setBackground(PanelUtils.mandatoryPanelColorBackground);
            header.setForeground(PanelUtils.mandatoryPanelColorForeground);
        } else {
            currentPanel.setBackground(PanelUtils.panelColorBackground);
            subPanel.setBackground(PanelUtils.panelColorBackground);
            subPanelH.setBackground(PanelUtils.panelColorBackground);
        }
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            final JDateChooser dateChooser = new JDateChooser(jCal, null, "dd/MM/yyyy", (IDateEditor)jEditor){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("day")) {
                        if (this.popup.isVisible()) {
                            this.dateSelected = true;
                            this.popup.setVisible(false);
                            this.setDate(GregorianCalendar.getInstance().getTime());
                            this.setDate(this.jcalendar.getCalendar().getTime());
                        }
                    } else if (evt.getPropertyName().equals("date")) {
                        if (evt.getSource() == this.dateEditor) {
                            this.firePropertyChange("date", evt.getOldValue(), evt.getNewValue());
                        } else {
                            this.setDate((Date)evt.getNewValue());
                        }
                    }
                }
            };
            if (date != null) {
                dateChooser.setDate(date);
            }
            dateChooser.setDateFormatString("dd/MM/yyyy");
            dateChooser.setPreferredSize(dateField);
            if (isChanged) {
                dateChooser.setSelectableDateRange(criterion.getFrom(), criterion.getTo());
                if (criterion.getFrom() != null) {
                    cal.setTime(criterion.getFrom());
                    cal.add(5, -1);
                    jEditor.setMinSelectableDate(cal.getTime());
                }
                if (criterion.getTo() != null) {
                    cal.setTime(criterion.getTo());
                    jEditor.setMaxSelectableDate(cal.getTime());
                }
            }
            dateChooser.setIcon(PanelUtils.iconCalendar);
            jEditor.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent arg0) {
                    if (dateChooser.getDate() != null) {
                        try {
                            criterion.setValue(df.format(dateChooser.getDate()));
                            JTreeC4TComponentUtils.propagateTextValueToCriteria((C4TTreeNode)xmlTree.getModel().getRoot(), criterion.getMasterId(), df.format(dateChooser.getDate()));
                        }
                        catch (Exception e) {
                            System.out.println("EXCEPTION" + e.getMessage());
                        }
                        TreeNodesUtil.refreshSelectedPath(node);
                        xmlTree.updateUI();
                        PanelUtils.isPassed(criterion, subPanel, 2, true);
                    }
                }
            });
            dateChooser.setPreferredSize(dateField);
            dateChooser.setMaximumSize(dateField);
            subPanel.add((Component)dateChooser);
        } else {
            subPanel.add(new JLabel(C4TApplicationResources.getLabel(PROVIDED_BY_EVALUATOR)));
        }
        subPanel.add(Box.createHorizontalGlue());
        PanelUtils.isPassed(criterion, subPanel, 2, false);
        currentPanel.add(subPanel);
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            currentPanel.add(new CriterionRelevantDocPanel(criterion));
        }
        return currentPanel;
    }

    private static JPanel getPanelForDaterange(final C4TCriterion criterion, final C4TTreeNode node, final JTree xmlTree) {
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        Dimension dateField = new Dimension(140, 20);
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BoxLayout(currentPanel, 1));
        currentPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 5, 15));
        JPanel subPanelH = new JPanel();
        subPanelH.setLayout(new BoxLayout(subPanelH, 0));
        JLabel header = new JLabel();
        header.setFont(PanelUtils.fontSansSerif);
        subPanelH.add(header);
        subPanelH.add(Box.createHorizontalGlue());
        currentPanel.add(subPanelH);
        final JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        boolean isChanged1 = false;
        Calendar calendar1 = GregorianCalendar.getInstance();
        if (criterion.getDate1().getFrom() != null) {
            calendar1.setTime(criterion.getDate1().getFrom());
            isChanged1 = true;
        } else if (criterion.getDate1().getTo() != null) {
            calendar1.setTime(criterion.getDate1().getTo());
            isChanged1 = true;
        }
        JCalendar jCalendar1 = new JCalendar(calendar1.getTime(), true);
        JSpinnerDateEditor jEditor1 = new JSpinnerDateEditor();
        if (isChanged1) {
            jEditor1.setDate(calendar1.getTime());
        }
        final JDateChooser dateChooser1 = new JDateChooser(jCalendar1, null, "dd/MM/yyyy", (IDateEditor)jEditor1){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("day")) {
                    if (this.popup.isVisible()) {
                        this.dateSelected = true;
                        this.popup.setVisible(false);
                        this.setDate(GregorianCalendar.getInstance().getTime());
                        this.setDate(this.jcalendar.getCalendar().getTime());
                    }
                } else if (evt.getPropertyName().equals("date")) {
                    System.out.println("date");
                    if (evt.getSource() == this.dateEditor) {
                        this.firePropertyChange("date", evt.getOldValue(), evt.getNewValue());
                    } else {
                        this.setDate((Date)evt.getNewValue());
                    }
                }
            }
        };
        if (criterion.getDate1().getValue() != null) {
            dateChooser1.setDate(criterion.getDate1().getValue());
        }
        dateChooser1.setDateFormatString("dd/MM/yyyy");
        dateChooser1.setPreferredSize(dateField);
        if (isChanged1) {
            dateChooser1.setSelectableDateRange(criterion.getDate1().getFrom(), criterion.getDate1().getTo());
            if (criterion.getFrom() != null) {
                calendar1.setTime(criterion.getDate1().getFrom());
                calendar1.add(5, -1);
                jEditor1.setMinSelectableDate(calendar1.getTime());
            }
            if (criterion.getTo() != null) {
                calendar1.setTime(criterion.getDate1().getTo());
                jEditor1.setMaxSelectableDate(calendar1.getTime());
            }
        }
        dateChooser1.setIcon(PanelUtils.iconCalendar);
        dateChooser1.setMaximumSize(dateField);
        jEditor1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                if (dateChooser1.getDate() != null) {
                    criterion.getDate1().setValue(dateChooser1.getDate());
                    JTreeC4TComponentUtils.propagateDateRangeFromValueToCriteria((C4TTreeNode)xmlTree.getModel().getRoot(), criterion.getMasterId(), dateChooser1.getDate());
                    TreeNodesUtil.refreshSelectedPath(node);
                    xmlTree.updateUI();
                    PanelUtils.isPassed(criterion, subPanel, 6, true);
                }
            }
        });
        boolean isChanged2 = false;
        Calendar calendar2 = GregorianCalendar.getInstance();
        if (criterion.getDate2().getFrom() != null) {
            calendar2.setTime(criterion.getDate2().getFrom());
            calendar2.add(5, -1);
            isChanged2 = true;
        } else if (criterion.getDate2().getTo() != null) {
            calendar2.setTime(criterion.getDate2().getTo());
            calendar2.add(5, 1);
            isChanged2 = true;
        }
        JCalendar jCalendar2 = new JCalendar(calendar2.getTime(), true);
        JSpinnerDateEditor jEditor2 = new JSpinnerDateEditor();
        if (isChanged2) {
            jEditor2.setDate(calendar2.getTime());
        }
        final JDateChooser dateChooser2 = new JDateChooser(jCalendar2, null, "dd/MM/yyyy", (IDateEditor)jEditor2){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("day")) {
                    if (this.popup.isVisible()) {
                        this.dateSelected = true;
                        this.popup.setVisible(false);
                        this.setDate(GregorianCalendar.getInstance().getTime());
                        this.setDate(this.jcalendar.getCalendar().getTime());
                    }
                } else if (evt.getPropertyName().equals("date")) {
                    if (evt.getSource() == this.dateEditor) {
                        this.firePropertyChange("date", evt.getOldValue(), evt.getNewValue());
                    } else {
                        this.setDate((Date)evt.getNewValue());
                    }
                }
            }
        };
        if (criterion.getDate2().getValue() != null) {
            dateChooser2.setDate(criterion.getDate2().getValue());
        }
        dateChooser2.setDateFormatString("dd/MM/yyyy");
        dateChooser2.setPreferredSize(dateField);
        if (isChanged2) {
            dateChooser2.setSelectableDateRange(criterion.getDate2().getFrom(), criterion.getDate2().getTo());
            if (criterion.getFrom() != null) {
                calendar2.setTime(criterion.getDate2().getFrom());
                calendar2.add(5, -1);
                jEditor2.setMinSelectableDate(calendar2.getTime());
            }
            if (criterion.getTo() != null) {
                calendar2.setTime(criterion.getDate2().getTo());
                jEditor2.setMaxSelectableDate(calendar2.getTime());
            }
        }
        dateChooser2.setIcon(PanelUtils.iconCalendar);
        dateChooser2.setMaximumSize(dateField);
        jEditor2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                if (dateChooser2.getDate() != null) {
                    criterion.getDate2().setValue(dateChooser2.getDate());
                    JTreeC4TComponentUtils.propagateDateRangeToValueToCriteria((C4TTreeNode)xmlTree.getModel().getRoot(), criterion.getMasterId(), dateChooser2.getDate());
                    TreeNodesUtil.refreshSelectedPath(node);
                    xmlTree.updateUI();
                    PanelUtils.isPassed(criterion, subPanel, 6, true);
                }
            }
        });
        JLabel dateFrom = new JLabel(C4TApplicationResources.getLabel("label.criterion.date.from") + ":");
        dateFrom.setFont(PanelUtils.fontSansSerif);
        JLabel dateTo = new JLabel(C4TApplicationResources.getLabel("label.criterion.date.to") + ":");
        dateTo.setFont(PanelUtils.fontSansSerif);
        boolean mandatory = C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion);
        TextWrapLabelUtil.wrapLabelText(header, (mandatory ? "* " : "") + C4TXStreamUtil.convertStringToUTF(criterion.getLabel()), TextWrapLabelUtil.headerWidth);
        if (mandatory) {
            currentPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
            dateFrom.setForeground(PanelUtils.panelColorForeground);
            dateTo.setForeground(PanelUtils.panelColorForeground);
            subPanelH.setBackground(PanelUtils.mandatoryPanelColorBackground);
            header.setForeground(PanelUtils.mandatoryPanelColorForeground);
            subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
        } else {
            currentPanel.setBackground(PanelUtils.panelColorBackground);
            subPanelH.setBackground(PanelUtils.panelColorBackground);
            subPanel.setBackground(PanelUtils.panelColorBackground);
        }
        subPanel.add(dateFrom);
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            subPanel.add((Component)dateChooser1);
        } else {
            subPanel.add(new JLabel(C4TApplicationResources.getLabel(PROVIDED_BY_EVALUATOR)));
        }
        subPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        subPanel.add(dateTo);
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            subPanel.add((Component)dateChooser2);
        } else {
            subPanel.add(new JLabel(C4TApplicationResources.getLabel(PROVIDED_BY_EVALUATOR)));
        }
        subPanel.add(Box.createHorizontalGlue());
        PanelUtils.isPassed(criterion, subPanel, 6, false);
        currentPanel.add(subPanel);
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            currentPanel.add(new CriterionRelevantDocPanel(criterion));
        }
        return currentPanel;
    }

    private static JPanel getPanelForFile(final C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BoxLayout(currentPanel, 1));
        currentPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 5, 15));
        JLabel header = new JLabel();
        header.setFont(PanelUtils.fontSansSerif);
        JPanel subPanelH = new JPanel();
        subPanelH.setLayout(new BoxLayout(subPanelH, 0));
        subPanelH.add(header);
        subPanelH.add(Box.createHorizontalGlue());
        currentPanel.add(subPanelH);
        final JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        JTextField txt1 = new JTextField();
        txt1.setPreferredSize(longField);
        txt1.setMaximumSize(longField);
        if (criterion.getSupplierReadOnly().booleanValue()) {
            txt1.setText(C4TApplicationResources.getLabel(PROVIDED_BY_EVALUATOR));
        } else {
            txt1.setText(C4TXStreamUtil.convertStringToUTF(criterion.getValue()));
        }
        txt1.setEditable(false);
        final JButton m_btCreate = new JButton();
        JButton s_btCreate = new JButton();
        s_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.see"));
        ActionListener s_lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser attachmentChooser = JFileChooserUtils.createJFileChooser();
                String absoluteAttachmentPath = FileUtils.makeAbsoluteAttachmentPath(criterion);
                attachmentChooser.setSelectedFile(new File(absoluteAttachmentPath));
                attachmentChooser.setDialogType(0);
                if (attachmentChooser.showDialog(m_btCreate.getParent(), null) != 0) {
                    return;
                }
                try {
                    Desktop.getDesktop().open(attachmentChooser.getSelectedFile());
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(subPanel, C4TApplicationResources.getLabel("label.file.opening.failed.message"), C4TApplicationResources.getLabel("label.file.opening.failed.title"), 0);
                }
            }
        };
        s_btCreate.addActionListener(s_lst);
        String oldFile = criterion.getValue();
        if (oldFile != null && oldFile.length() > 0) {
            m_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.remove"));
        } else {
            m_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.attach"));
        }
        ActionListener lst = C4TCriterionFactory.getFileActionListener(criterion, node, xmlTree, subPanel, txt1, m_btCreate, s_btCreate);
        m_btCreate.addActionListener(lst);
        subPanel.add(txt1);
        subPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            subPanel.add(m_btCreate);
            if (oldFile != null && oldFile.length() > 0) {
                subPanel.add(Box.createRigidArea(new Dimension(5, 0)));
                subPanel.add(s_btCreate);
            }
        }
        JLabel labelMaxSize = new JLabel();
        labelMaxSize.setText(" " + C4TApplicationResources.getLabel("label.criterion.file.max.size") + ": " + (criterion.getSize() == null ? "" : criterion.getSize()) + " MB");
        labelMaxSize.setFont(PanelUtils.fontSansSerif);
        boolean mandatory = C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion);
        TextWrapLabelUtil.wrapLabelText(header, (mandatory ? "* " : "") + C4TXStreamUtil.convertStringToUTF(criterion.getLabel()), TextWrapLabelUtil.headerWidth);
        if (mandatory) {
            currentPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
            labelMaxSize.setForeground(PanelUtils.panelColorForeground);
            subPanelH.setBackground(PanelUtils.mandatoryPanelColorBackground);
            header.setForeground(PanelUtils.mandatoryPanelColorForeground);
            subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
        } else {
            currentPanel.setBackground(PanelUtils.panelColorBackground);
            subPanelH.setBackground(PanelUtils.panelColorBackground);
            subPanel.setBackground(PanelUtils.panelColorBackground);
        }
        subPanel.add(labelMaxSize);
        subPanel.add(Box.createHorizontalGlue());
        PanelUtils.isPassed(criterion, subPanel, subPanel.getComponentCount() - 1, false);
        currentPanel.add(subPanel);
        return currentPanel;
    }

    private static ActionListener getFileActionListener(final C4TCriterion criterion, final C4TTreeNode node, final JTree xmlTree, final JPanel subPanel, final JTextField txt1, final JButton m_btCreate, final JButton s_btCreate) {
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                m_btCreate.setEnabled(false);
                String oldFile = criterion.getValue();
                String relativeFilePath = "";
                if (oldFile != null && oldFile.length() > 0) {
                    try {
                        relativeFilePath = FileUtils.makeRelativePath(criterion);
                        FileUtils.copyAttachedFile(relativeFilePath, oldFile);
                        FileUtils.deleteAttachedFile(relativeFilePath, oldFile);
                        m_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.attach"));
                        m_btCreate.setEnabled(true);
                        txt1.setText("");
                        criterion.setValue("");
                        JTreeC4TComponentUtils.propagateTextValueToCriteria((C4TTreeNode)xmlTree.getModel().getRoot(), criterion.getMasterId(), "");
                        subPanel.remove(PanelUtils.getComponentIndex(m_btCreate) + 1);
                        subPanel.remove(s_btCreate);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(subPanel, C4TApplicationResources.getLabel("label.file.copying.failed.message"), C4TApplicationResources.getLabel("label.file.copying.failed.title"), 0);
                    }
                } else {
                    File archiveFile = C4TCriterionFactory.createArchive(subPanel);
                    try {
                        if (archiveFile != null) {
                            relativeFilePath = FileUtils.makeRelativePath(criterion);
                            String newFName = FileUtils.copyAttachedFile(relativeFilePath, archiveFile, oldFile, criterion);
                            criterion.setFileSize(archiveFile.length());
                            m_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.remove"));
                            SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
                            txt1.setText(newFName);
                            txt1.setText(relativeFilePath + txt1.getText());
                            criterion.setValue(txt1.getText());
                            JTreeC4TComponentUtils.propagateTextValueToCriteria((C4TTreeNode)xmlTree.getModel().getRoot(), criterion.getMasterId(), txt1.getText());
                            subPanel.add(Box.createRigidArea(new Dimension(5, 0)), PanelUtils.getComponentIndex(m_btCreate) + 1);
                            subPanel.add((Component)s_btCreate, PanelUtils.getComponentIndex(m_btCreate) + 2);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(subPanel, C4TApplicationResources.getLabel("label.file.copying.failed.message"), C4TApplicationResources.getLabel("label.file.copying.failed.title"), 0);
                    }
                    m_btCreate.setEnabled(true);
                }
                TreeNodesUtil.refreshSelectedPath(node);
                xmlTree.updateUI();
                PanelUtils.isPassed(criterion, subPanel, subPanel.getComponentCount() - 1, true);
            }
        };
        return lst;
    }

    protected static File createArchive(JPanel panel) {
        JFileChooser attachmentChooser = JFileChooserUtils.createJFileChooser();
        SimpleFilter m_txtFilter = new SimpleFilter("txt", "TXT Files");
        SimpleFilter m_pdfFilter = new SimpleFilter("pdf", "PDF Files");
        SimpleFilter m_xlsFilter = new SimpleFilter("xls", "XLS Files");
        SimpleFilter m_docFilter = new SimpleFilter("doc", "DOC Files");
        SimpleFilter m_allFilter = new SimpleFilter("", "All (*.*)");
        attachmentChooser.addChoosableFileFilter(m_txtFilter);
        attachmentChooser.addChoosableFileFilter(m_pdfFilter);
        attachmentChooser.addChoosableFileFilter(m_xlsFilter);
        attachmentChooser.addChoosableFileFilter(m_docFilter);
        attachmentChooser.addChoosableFileFilter(m_allFilter);
        AttachmentFileView m_view = new AttachmentFileView();
        attachmentChooser.setFileView(m_view);
        attachmentChooser.setMultiSelectionEnabled(false);
        attachmentChooser.setFileFilter(m_allFilter);
        FileFilter ft = attachmentChooser.getAcceptAllFileFilter();
        attachmentChooser.removeChoosableFileFilter(ft);
        File m_currentDir = null;
        try {
            m_currentDir = new File(".").getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        attachmentChooser.setCurrentDirectory(m_currentDir);
        attachmentChooser.setDialogType(0);
        attachmentChooser.setDialogTitle(C4TApplicationResources.getLabel("label.criterion.button.file.attach"));
        if (attachmentChooser.showDialog(panel, C4TApplicationResources.getLabel("label.criterion.button.file.attach")) != 0) {
            return null;
        }
        m_currentDir = attachmentChooser.getCurrentDirectory();
        File archiveFile = attachmentChooser.getSelectedFile();
        return archiveFile;
    }

    private static JPanel getPanelForList(C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        return C4TCriterionListFactory.getC4TCriterionList(criterion, node, xmlTree);
    }

    public static boolean isCertificateSectionEnabled(C4TTreeNode node) {
        JTreeC4TCompopnent sectionComponent = (JTreeC4TCompopnent)node.getUserObject();
        C4TSection section = (C4TSection)sectionComponent;
        return !section.isUseCertificate();
    }
}

