/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.factory;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.C4TCriterionFactory;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.CriterionRelevantDocPanel;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PairOptionPanel;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PanelUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.TreeNodesUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.TextWrapLabelUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterionOption;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class C4TCriterionListFactory {
    public static JPanel getC4TCriterionList(C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        if (criterion.getAppearance().equalsIgnoreCase("radio")) {
            return C4TCriterionListFactory.getPanelRadio(criterion, node, xmlTree);
        }
        if (criterion.getAppearance().equalsIgnoreCase("check")) {
            return C4TCriterionListFactory.getPanelCheckBox(criterion, node, xmlTree);
        }
        if (criterion.getAppearance().equalsIgnoreCase("combo")) {
            if (criterion.getMultiple() != 1) {
                return C4TCriterionListFactory.getPanelComboBox(criterion, node, xmlTree);
            }
            return C4TCriterionListFactory.getPanelMultipleList(criterion, node, xmlTree);
        }
        return new JPanel();
    }

    private static JPanel getBaseCurrentPanel(C4TCriterion criterion) {
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BoxLayout(currentPanel, 1));
        currentPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 5, 15));
        JLabel header = new JLabel();
        header.setFont(PanelUtils.fontSansSerif);
        JPanel subPanelH = new JPanel();
        subPanelH.setLayout(new BoxLayout(subPanelH, 0));
        subPanelH.add(header);
        subPanelH.add(Box.createHorizontalGlue());
        currentPanel.add(subPanelH);
        boolean mandatory = C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion);
        if (mandatory) {
            currentPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
            subPanelH.setBackground(PanelUtils.mandatoryPanelColorBackground);
            header.setForeground(PanelUtils.mandatoryPanelColorForeground);
        } else {
            currentPanel.setBackground(PanelUtils.panelColorBackground);
            subPanelH.setBackground(PanelUtils.panelColorBackground);
        }
        TextWrapLabelUtil.wrapLabelText(header, (C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion) ? "* " : "") + C4TXStreamUtil.convertStringToUTF(criterion.getLabel()), TextWrapLabelUtil.headerWidth);
        return currentPanel;
    }

    private static JPanel getPanelRadio(C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        JPanel currentPanel = C4TCriterionListFactory.getBaseCurrentPanel(criterion);
        ButtonGroup buttonGroup = new ButtonGroup();
        int index = 0;
        int numberOfOptions = criterion.getOptions().size();
        ArrayList<PairOptionPanel> panelList = new ArrayList<PairOptionPanel>();
        JPanel lastPanel = null;
        for (C4TCriterionOption cOpts : criterion.getOptions()) {
            boolean isPassed;
            JRadioButton jBut = new JRadioButton();
            JPanel subPanel = new JPanel();
            JLabel label = new JLabel();
            label.setFont(PanelUtils.fontSansSerif);
            subPanel.setLayout(new BoxLayout(subPanel, 0));
            if (C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion)) {
                subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
                label.setBackground(PanelUtils.mandatoryPanelColorBackground);
                label.setForeground(PanelUtils.panelColorForeground);
                jBut.setBackground(PanelUtils.mandatoryPanelColorBackground);
            } else {
                subPanel.setBackground(PanelUtils.panelColorBackground);
                jBut.setBackground(PanelUtils.panelColorBackground);
            }
            jBut.setEnabled(criterion.getSupplierReadOnly() == false);
            if (criterion.getValue().equalsIgnoreCase(cOpts.getValueAttribute().toString())) {
                jBut.setSelected(true);
            }
            subPanel.add(jBut);
            TextWrapLabelUtil.wrapLabelText(label, C4TXStreamUtil.convertStringToUTF(cOpts.getValue()), TextWrapLabelUtil.listWidth);
            subPanel.add(label);
            subPanel.add(Box.createHorizontalGlue());
            boolean bl = isPassed = index == numberOfOptions - 1;
            if (isPassed) {
                PanelUtils.isPassed(criterion, subPanel, 3, false);
                lastPanel = subPanel;
            }
            buttonGroup.add(jBut);
            currentPanel.add(subPanel);
            panelList.add(new PairOptionPanel(subPanel, cOpts));
            ++index;
        }
        JPanel focusPanel = lastPanel;
        for (PairOptionPanel pairOptionPanel : panelList) {
            JRadioButton buton = (JRadioButton)pairOptionPanel.getPanel().getComponent(0);
            C4TCriterionOption option = pairOptionPanel.getOption();
            ActionListener lst = C4TCriterionListFactory.getRadioButtonActionListener(criterion, node, xmlTree, focusPanel, buton, option);
            buton.addActionListener(lst);
        }
        C4TCriterionListFactory.addFileUploadOrEvaluatorProvided(criterion, currentPanel);
        return currentPanel;
    }

    private static void addFileUploadOrEvaluatorProvided(C4TCriterion criterion, JPanel currentPanel) {
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            currentPanel.add(new CriterionRelevantDocPanel(criterion));
        } else {
            currentPanel.add(new JLabel(C4TApplicationResources.getLabel("label.criterion.filled.by.evaluator")));
        }
    }

    private static ActionListener getRadioButtonActionListener(final C4TCriterion criterion, final C4TTreeNode node, final JTree xmlTree, final JPanel focusPanel, final JRadioButton buton, final C4TCriterionOption option) {
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (buton.isSelected()) {
                    criterion.setValue(option.getValueAttribute().toString());
                }
                TreeNodesUtil.refreshSelectedPath(node);
                xmlTree.updateUI();
                PanelUtils.isPassed(criterion, focusPanel, 3, true);
            }
        };
        return lst;
    }

    private static JPanel getPanelCheckBox(C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        JPanel currentPanel = C4TCriterionListFactory.getBaseCurrentPanel(criterion);
        int index = 0;
        int numberOfOptions = criterion.getOptions().size();
        ArrayList<PairOptionPanel> panelList = new ArrayList<PairOptionPanel>();
        JPanel lastPanel = null;
        for (C4TCriterionOption cOpts : criterion.getOptions()) {
            boolean isPassed;
            JPanel subPanel = new JPanel();
            JLabel value = new JLabel();
            TextWrapLabelUtil.wrapLabelText(value, C4TXStreamUtil.convertStringToUTF(cOpts.getValue()), TextWrapLabelUtil.listWidth);
            JCheckBox jBut = new JCheckBox(value.getText());
            subPanel.setLayout(new BoxLayout(subPanel, 0));
            if (C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion)) {
                subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
                jBut.setBackground(PanelUtils.mandatoryPanelColorBackground);
                jBut.setForeground(PanelUtils.panelColorForeground);
            } else {
                subPanel.setBackground(PanelUtils.panelColorBackground);
                jBut.setBackground(PanelUtils.panelColorBackground);
            }
            String[] values = criterion.getValue().split(",");
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equalsIgnoreCase(cOpts.getValueAttribute().toString())) continue;
                jBut.setSelected(true);
            }
            jBut.setEnabled(criterion.getSupplierReadOnly() == false);
            subPanel.add(jBut);
            subPanel.add(Box.createHorizontalGlue());
            currentPanel.add(subPanel);
            boolean bl = isPassed = index == numberOfOptions - 1;
            if (isPassed) {
                PanelUtils.isPassed(criterion, subPanel, 2, false);
                lastPanel = subPanel;
            }
            panelList.add(new PairOptionPanel(subPanel, cOpts));
            ++index;
        }
        JPanel focusPanel = lastPanel;
        for (PairOptionPanel pairOptionPanel : panelList) {
            JCheckBox buton = (JCheckBox)pairOptionPanel.getPanel().getComponent(0);
            C4TCriterionOption option = pairOptionPanel.getOption();
            ActionListener lst = C4TCriterionListFactory.getCheckBoxActionListener(criterion, node, xmlTree, focusPanel, buton, option);
            buton.addActionListener(lst);
        }
        C4TCriterionListFactory.addFileUploadOrEvaluatorProvided(criterion, currentPanel);
        return currentPanel;
    }

    private static ActionListener getCheckBoxActionListener(final C4TCriterion criterion, final C4TTreeNode node, final JTree xmlTree, final JPanel focusPanel, final JCheckBox buton, final C4TCriterionOption option) {
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (buton.isSelected()) {
                    String[] values = criterion.getValue().split(",");
                    boolean found = false;
                    for (int i = 0; i < values.length; ++i) {
                        if (!values[i].equalsIgnoreCase(option.getValueAttribute().toString())) continue;
                        found = true;
                    }
                    if (!found) {
                        if (criterion.getValue() != null && criterion.getValue().length() > 0) {
                            criterion.setValue(criterion.getValue() + "," + option.getValueAttribute().toString());
                        } else {
                            criterion.setValue(option.getValueAttribute().toString());
                        }
                    }
                } else {
                    String[] values = criterion.getValue().split(",");
                    String newValue = "";
                    boolean first = true;
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i].equalsIgnoreCase(option.getValueAttribute().toString())) continue;
                        newValue = newValue + (first ? values[i] : "," + values[i]);
                        first = false;
                    }
                    criterion.setValue(newValue);
                }
                TreeNodesUtil.refreshSelectedPath(node);
                xmlTree.updateUI();
                PanelUtils.isPassed(criterion, focusPanel, 2, true);
            }
        };
        return lst;
    }

    private static JPanel getPanelComboBox(C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        JPanel currentPanel = C4TCriterionListFactory.getBaseCurrentPanel(criterion);
        Vector<C4TCriterionOption> optionTmp = new Vector<C4TCriterionOption>(criterion.getOptions());
        Vector<C4TCriterionOption> option = new Vector<C4TCriterionOption>();
        C4TCriterionOption emptyItem = new C4TCriterionOption(C4TApplicationResources.getLabel("label.select.a.value"));
        option.add(emptyItem);
        for (C4TCriterionOption opt : optionTmp) {
            C4TCriterionOption tempOpt = new C4TCriterionOption(opt);
            tempOpt.setValue(C4TXStreamUtil.convertStringToUTF(tempOpt.getValue()));
            option.add(tempOpt);
        }
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        if (C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion)) {
            subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
        } else {
            subPanel.setBackground(PanelUtils.panelColorBackground);
        }
        Dimension longField = new Dimension(340, 20);
        JComboBox cmb1 = new JComboBox(option);
        cmb1.setPreferredSize(longField);
        cmb1.setMaximumSize(longField);
        if (criterion.getValue() != null) {
            for (int index = 0; index < cmb1.getItemCount(); ++index) {
                C4TCriterionOption item = (C4TCriterionOption)cmb1.getItemAt(index);
                if (item.getValueAttribute() == null || !criterion.getValue().equalsIgnoreCase(item.getValueAttribute().toString())) continue;
                cmb1.setSelectedItem(item);
            }
        }
        cmb1.setEnabled(criterion.getSupplierReadOnly() == false);
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            ActionListener lst = C4TCriterionListFactory.getComboBoxActionListener(criterion, node, xmlTree, cmb1, subPanel);
            cmb1.addActionListener(lst);
        }
        subPanel.add(cmb1);
        subPanel.add(Box.createHorizontalGlue());
        PanelUtils.isPassed(criterion, subPanel, 2, false);
        currentPanel.add(subPanel);
        C4TCriterionListFactory.addFileUploadOrEvaluatorProvided(criterion, currentPanel);
        return currentPanel;
    }

    private static ActionListener getComboBoxActionListener(final C4TCriterion criterion, final C4TTreeNode node, final JTree xmlTree, final JComboBox cmb1, final JPanel subPanel) {
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                C4TCriterionOption opt = (C4TCriterionOption)cmb1.getSelectedItem();
                if (opt != null) {
                    if (opt.getValueAttribute() != null) {
                        criterion.setValue(opt.getValueAttribute().toString());
                    } else {
                        criterion.setValue("");
                    }
                }
                TreeNodesUtil.refreshSelectedPath(node);
                xmlTree.updateUI();
                PanelUtils.isPassed(criterion, subPanel, 2, true);
            }
        };
        return lst;
    }

    private static JPanel getPanelMultipleList(C4TCriterion criterion, C4TTreeNode node, JTree xmlTree) {
        int numberOfRows;
        boolean enabled = C4TCriterionFactory.isCertificateSectionEnabled(node);
        criterion.setUseCertificate(!enabled);
        JPanel currentPanel = C4TCriterionListFactory.getBaseCurrentPanel(criterion);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        if (C4TCriterionFactory.isMandatoryAndNotReadOnly(criterion)) {
            subPanel.setBackground(PanelUtils.mandatoryPanelColorBackground);
        } else {
            subPanel.setBackground(PanelUtils.panelColorBackground);
        }
        Vector<C4TCriterionOption> optionTmp = new Vector<C4TCriterionOption>(criterion.getOptions());
        Vector<C4TCriterionOption> option = new Vector<C4TCriterionOption>();
        for (C4TCriterionOption opt : optionTmp) {
            C4TCriterionOption tempOpt = new C4TCriterionOption(opt);
            tempOpt.setValue(C4TXStreamUtil.convertStringToUTF(tempOpt.getValue()));
            option.add(tempOpt);
        }
        JList lst1 = new JList(option);
        lst1.setVisibleRowCount(4);
        DefaultListSelectionModel m = new DefaultListSelectionModel();
        m.setSelectionMode(2);
        lst1.setSelectionModel(m);
        int n = numberOfRows = criterion.getOptions().size() > 4 ? 4 : criterion.getOptions().size();
        if (criterion.getValue().length() > 0) {
            String[] values = criterion.getValue().split(",");
            int[] indices = new int[values.length];
            int metaIndex = 0;
            int selectedIndex = 0;
            for (C4TCriterionOption opt : criterion.getOptions()) {
                for (int i = 0; i < values.length; ++i) {
                    if (!opt.getValueAttribute().toString().equalsIgnoreCase(values[i])) continue;
                    indices[metaIndex] = selectedIndex;
                    ++metaIndex;
                }
                ++selectedIndex;
            }
            lst1.setSelectedIndices(indices);
        }
        JScrollPane sp1 = new JScrollPane(lst1);
        lst1.setEnabled(criterion.getSupplierReadOnly() == false);
        if (!criterion.getSupplierReadOnly().booleanValue()) {
            C4TCriterionListFactory.addMultipleSelectionListActionListener(criterion, node, xmlTree, subPanel, lst1);
        }
        Dimension longField = new Dimension(340, 20 * numberOfRows);
        Box box = Box.createHorizontalBox();
        box.setPreferredSize(longField);
        box.setMaximumSize(longField);
        box.add(sp1);
        subPanel.add(box);
        subPanel.add(Box.createHorizontalGlue());
        PanelUtils.isPassed(criterion, subPanel, 2, false);
        currentPanel.add(subPanel);
        C4TCriterionListFactory.addFileUploadOrEvaluatorProvided(criterion, currentPanel);
        return currentPanel;
    }

    private static void addMultipleSelectionListActionListener(final C4TCriterion criterion, final C4TTreeNode node, final JTree xmlTree, final JPanel subPanel, final JList lst1) {
        lst1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                List<Object> list = Arrays.asList(lst1.getSelectedValues());
                C4TCriterionOption[] al = list.toArray(new C4TCriterionOption[list.size()]);
                String value = "";
                boolean first = true;
                for (C4TCriterionOption opt : al) {
                    value = value + (first ? opt.getValueAttribute() : "," + opt.getValueAttribute());
                    first = false;
                }
                criterion.setValue(value);
                TreeNodesUtil.refreshSelectedPath(node);
                xmlTree.updateUI();
                PanelUtils.isPassed(criterion, subPanel, 2, true);
            }
        });
    }
}

