/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.factory;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PanelUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TPrice;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TPositiveDouble;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.C4TSectionComponent;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class C4TTotalFOPanel
extends JPanel {
    static Dimension longFieldLabel = new Dimension(290, 20);
    static Dimension longFieldValue = new Dimension(200, 20);

    public C4TTotalFOPanel(C4TEnvelope envelope) {
        this.setBackground(PanelUtils.panelColorBackground);
        BoxLayout panelLayout = new BoxLayout(this, 1);
        this.setLayout(panelLayout);
        double totalValue = this.getTotalValues(envelope);
        this.add(new ValueLabelPanel("" + String.format("%,.2f", totalValue), C4TApplicationResources.getLabel("label.fo.total.value")));
        double totalPresentValue = this.getTotalPresentValues(envelope);
        this.add(new ValueLabelPanel("" + String.format("%,.2f", totalPresentValue), C4TApplicationResources.getLabel("label.fo.total.present.value")));
        double totalDiscountValue = 0.0;
        double totalDiscountPresentValue = 0.0;
        if (envelope.getFdrAllowed().booleanValue()) {
            if (envelope.getFurtherDiscountValue() == null) {
                envelope.setFurtherDiscountValue(new C4TPositiveDouble());
            }
            totalDiscountValue = totalValue * envelope.getFurtherDiscountValue().getValue() / 100.0;
            totalDiscountPresentValue = totalPresentValue * envelope.getFurtherDiscountValue().getValue() / 100.0;
        }
        this.add(new ValueLabelPanel("" + String.format("%,.2f", totalDiscountValue), C4TApplicationResources.getLabel("label.fo.total.discount.value")));
        this.add(new ValueLabelPanel("" + String.format("%,.2f", totalDiscountPresentValue), C4TApplicationResources.getLabel("label.fo.total.discount.present.value")));
        double finalValue = totalValue - totalDiscountValue;
        this.add(new ValueLabelPanel("" + String.format("%,.2f", finalValue), C4TApplicationResources.getLabel("label.fo.final.value")));
        double presentDayFinalValue = totalPresentValue - totalDiscountPresentValue;
        this.add(new ValueLabelPanel("" + String.format("%,.2f", presentDayFinalValue), C4TApplicationResources.getLabel("label.fo.present.day.final.value")));
    }

    protected double getTotalValues(C4TEnvelope envelope) {
        double summ = 0.0;
        for (C4TSectionComponent sc : envelope.getNodes()) {
            C4TCriterion criterion = (C4TCriterion)sc;
            for (C4TPrice price : criterion.getPrices()) {
                summ += price.getValue().getValue().doubleValue();
            }
        }
        return summ;
    }

    protected double getTotalPresentValues(C4TEnvelope envelope) {
        double summ = 0.0;
        for (C4TSectionComponent sc : envelope.getNodes()) {
            C4TCriterion criterion = (C4TCriterion)sc;
            int yearOffset = 0;
            for (C4TPrice price : criterion.getPrices()) {
                double discountedCpDouble = price.getValue().getValue() / Math.pow(1.0 + envelope.getDiscount().getValue() / 100.0, yearOffset++);
                summ += discountedCpDouble;
            }
        }
        return summ;
    }

    public class ValueLabelPanel
    extends JPanel {
        ValueLabelPanel(String value, String label) {
            this.setBackground(PanelUtils.panelColorBackground);
            BoxLayout totalValueLayout = new BoxLayout(this, 0);
            this.setLayout(totalValueLayout);
            JLabel totalValueLabel = new JLabel(label + ": ");
            totalValueLabel.setMinimumSize(longFieldLabel);
            totalValueLabel.setPreferredSize(longFieldLabel);
            totalValueLabel.setMaximumSize(longFieldLabel);
            totalValueLabel.setFont(PanelUtils.fontSansSerif);
            JTextField txtTotalValue = new JTextField();
            txtTotalValue.setPreferredSize(longFieldValue);
            txtTotalValue.setMaximumSize(longFieldValue);
            txtTotalValue.setText(value);
            txtTotalValue.setEditable(false);
            this.add(Box.createHorizontalGlue());
            this.add(totalValueLabel);
            this.add(txtTotalValue);
            this.add(Box.createHorizontalGlue());
        }
    }
}

