/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.factory;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PanelUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.AttachmentFileView;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEventsProducer;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SimpleFilter;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.FileUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.JFileChooserUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class CriterionRelevantDocPanel
extends JPanel {
    public CriterionRelevantDocPanel(final C4TCriterion criterion) {
        this.setLayout(new BoxLayout(this, 0));
        Dimension longField = new Dimension(200, 20);
        boolean mandatory = criterion.getMandatory() != 0;
        JLabel header = new JLabel(C4TApplicationResources.getLabel("label.relevant.document") + ":");
        header.setFont(PanelUtils.fontSansSerif);
        if (mandatory) {
            this.setBackground(PanelUtils.mandatoryPanelColorBackground);
            header.setForeground(PanelUtils.mandatoryPanelColorForeground);
        } else {
            this.setBackground(PanelUtils.panelColorBackground);
        }
        final JTextField txt1 = new JTextField();
        txt1.setPreferredSize(longField);
        txt1.setMaximumSize(longField);
        if (criterion.getRelevantDoc() != null) {
            txt1.setText(C4TXStreamUtil.convertStringToUTF(criterion.getRelevantDoc()));
        } else {
            txt1.setText("");
        }
        txt1.setEditable(false);
        final JButton m_btCreate = new JButton();
        final JButton s_btCreate = new JButton();
        s_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.see"));
        ActionListener s_lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser attachmentChooser = JFileChooserUtils.createJFileChooser();
                String absoluteAttachmentPath = FileUtils.makeAbsoluteAttachmentPath(criterion);
                attachmentChooser.setSelectedFile(new File(absoluteAttachmentPath));
                attachmentChooser.setDialogType(0);
                if (attachmentChooser.showDialog(m_btCreate.getParent(), null) != 0) {
                    return;
                }
                try {
                    Desktop.getDesktop().open(attachmentChooser.getSelectedFile());
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(CriterionRelevantDocPanel.this, C4TApplicationResources.getLabel("label.file.opening.failed.message"), C4TApplicationResources.getLabel("label.file.opening.failed.title"), 0);
                }
            }
        };
        s_btCreate.addActionListener(s_lst);
        m_btCreate.setEnabled(!criterion.isUseCertificate());
        if (criterion.getRelevantDoc() != null && criterion.getRelevantDoc().length() > 0) {
            m_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.remove"));
        } else {
            m_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.attach"));
        }
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                m_btCreate.setEnabled(false);
                String oldFile = criterion.getRelevantDoc();
                String relativeFilePath = "";
                if (oldFile != null && oldFile.length() > 0) {
                    try {
                        relativeFilePath = FileUtils.makeRelativePath(criterion);
                        FileUtils.copyAttachedFile(relativeFilePath, oldFile);
                        FileUtils.deleteAttachedFile(relativeFilePath, oldFile);
                        m_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.attach"));
                        m_btCreate.setEnabled(true);
                        txt1.setText("");
                        criterion.setRelevantDoc("");
                        m_btCreate.getParent().remove(m_btCreate.getParent().getComponentCount() - 3);
                        m_btCreate.getParent().remove(s_btCreate);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(CriterionRelevantDocPanel.this, C4TApplicationResources.getLabel("label.file.copying.failed.message"), C4TApplicationResources.getLabel("label.file.copying.failed.title"), 0);
                    }
                } else {
                    File archiveFile = CriterionRelevantDocPanel.this.createArchive();
                    try {
                        if (archiveFile != null) {
                            relativeFilePath = FileUtils.makeRelativePath(criterion);
                            String newFName = FileUtils.copyAttachedFile(relativeFilePath, archiveFile, oldFile, criterion);
                            criterion.setFileSize(archiveFile.length());
                            m_btCreate.setText(C4TApplicationResources.getLabel("label.criterion.button.file.remove"));
                            SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
                            txt1.setText(newFName);
                            txt1.setText(relativeFilePath + txt1.getText());
                            criterion.setRelevantDoc(txt1.getText());
                            m_btCreate.getParent().remove(m_btCreate.getParent().getComponentCount() - 1);
                            m_btCreate.getParent().add(Box.createRigidArea(new Dimension(5, 0)));
                            m_btCreate.getParent().add(s_btCreate);
                            m_btCreate.getParent().add(Box.createRigidArea(new Dimension(25, 0)));
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(CriterionRelevantDocPanel.this, C4TApplicationResources.getLabel("label.file.copying.failed.message"), C4TApplicationResources.getLabel("label.file.copying.failed.title"), 0);
                    }
                    m_btCreate.setEnabled(true);
                }
            }
        };
        m_btCreate.addActionListener(lst);
        this.add(Box.createHorizontalGlue());
        this.add(header);
        this.add(txt1);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(m_btCreate);
        if (criterion.getRelevantDoc() != null && criterion.getRelevantDoc().length() > 0) {
            this.add(Box.createRigidArea(new Dimension(5, 0)));
            this.add(s_btCreate);
        }
        this.add(Box.createRigidArea(new Dimension(25, 0)));
    }

    protected File createArchive() {
        JFileChooser attachmentChooser = JFileChooserUtils.createJFileChooser();
        SimpleFilter m_txtFilter = new SimpleFilter("txt", "TXT Files");
        SimpleFilter m_pdfFilter = new SimpleFilter("pdf", "PDF Files");
        SimpleFilter m_xlsFilter = new SimpleFilter("xls", "XLS Files");
        SimpleFilter m_docFilter = new SimpleFilter("doc", "DOC Files");
        SimpleFilter m_allFilter = new SimpleFilter("", "All (*.*)");
        attachmentChooser.addChoosableFileFilter(m_txtFilter);
        attachmentChooser.addChoosableFileFilter(m_pdfFilter);
        attachmentChooser.addChoosableFileFilter(m_xlsFilter);
        attachmentChooser.addChoosableFileFilter(m_docFilter);
        attachmentChooser.addChoosableFileFilter(m_allFilter);
        AttachmentFileView m_view = new AttachmentFileView();
        attachmentChooser.setFileView(m_view);
        attachmentChooser.setMultiSelectionEnabled(false);
        attachmentChooser.setFileFilter(m_allFilter);
        FileFilter ft = attachmentChooser.getAcceptAllFileFilter();
        attachmentChooser.removeChoosableFileFilter(ft);
        File m_currentDir = null;
        try {
            m_currentDir = new File(".").getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        attachmentChooser.setCurrentDirectory(m_currentDir);
        attachmentChooser.setDialogType(0);
        attachmentChooser.setDialogTitle(C4TApplicationResources.getLabel("label.criterion.button.file.attach"));
        if (attachmentChooser.showDialog(this, C4TApplicationResources.getLabel("label.criterion.button.file.attach")) != 0) {
            return null;
        }
        m_currentDir = attachmentChooser.getCurrentDirectory();
        File archiveFile = attachmentChooser.getSelectedFile();
        return archiveFile;
    }
}

