/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.factory;

import com.eurodyn.eprocurement.tools.c4t.ApplicationSingleton;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.JTreeC4TCompopnentType;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.C4TCriterionFactory;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.C4TSectionStatistics;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.C4TTotalFOPanel;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PanelUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.SectionComponentsRightBottomPanel;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEvent;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEventsListener;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEventsProducer;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.TreeNodesUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.MultiItemReport;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.table.FOJTable;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.table.FOTableModel;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.text.DoubleinputVerifier;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.tree.VetoableTreeSelectionModel;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.AppletCommunicationUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.FileUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.ImageC4TUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.TextWrapLabelUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TBody;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TLot;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TPrice;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TSection;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TYear;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TPositiveDouble;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamConstants;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.C4TSectionComponent;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.JTreeC4TCompopnent;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JTreeC4TCompopnentFactory {
    public static JPanel getC4TSectionComponent(C4TTreeNode node, JTree xmlTree) {
        if (node == null) {
            return new JPanel();
        }
        JTreeC4TCompopnent sectionComponent = (JTreeC4TCompopnent)node.getUserObject();
        if (sectionComponent == null) {
            return new JPanel();
        }
        switch (sectionComponent.getJType()) {
            case C4TCriterion: {
                return JTreeC4TCompopnentFactory.getPanelForCriterion(sectionComponent, node, xmlTree);
            }
            case C4TSection: {
                return JTreeC4TCompopnentFactory.getPanelForSection(node, xmlTree);
            }
            case C4TEnvelope: {
                return JTreeC4TCompopnentFactory.getPanelForEnvelope(sectionComponent, node, xmlTree);
            }
            case C4TBody: {
                return JTreeC4TCompopnentFactory.getPanelForBody(sectionComponent, node, xmlTree);
            }
            case C4TYear: {
                return JTreeC4TCompopnentFactory.getPanelForYear(node, xmlTree);
            }
        }
        return new JPanel();
    }

    private static JPanel getPanelForCriterion(JTreeC4TCompopnent sectionComponent, C4TTreeNode node, JTree xmlTree) {
        C4TCriterion criterion = (C4TCriterion)sectionComponent;
        return C4TCriterionFactory.getC4TSectionComponent(criterion, node, xmlTree);
    }

    private static JPanel getPanelForEnvelope(JTreeC4TCompopnent sectionComponent, C4TTreeNode node, JTree xmlTree) {
        C4TEnvelope env = (C4TEnvelope)sectionComponent;
        if (C4TXStreamConstants.C4T_XML_SECTION_TYPE_FINANCIAL.equalsIgnoreCase(env.getType())) {
            if (env.getMulti_item().booleanValue()) {
                JPanel currentPanel = new JPanel();
                currentPanel.setLayout(new BoxLayout(currentPanel, 1));
                MultiItemReport panelInner = new MultiItemReport(xmlTree, node);
                JScrollPane scroll = new JScrollPane(panelInner, 20, 30);
                currentPanel.add(scroll);
                return currentPanel;
            }
            JPanel currentPanel = new JPanel();
            currentPanel.setLayout(new BoxLayout(currentPanel, 1));
            currentPanel.setBackground(PanelUtils.panelColorBackground);
            if (!env.getPresentValueCalc().booleanValue()) {
                if (env.getNodes() != null && !env.getNodes().isEmpty()) {
                    ArrayList<C4TYear> years = new ArrayList<C4TYear>(env.getNumOfYears());
                    int i = 0;
                    int j = 0;
                    C4TCriterion criterion = null;
                    C4TYear year = null;
                    for (C4TSectionComponent comp : env.getNodes()) {
                        criterion = (C4TCriterion)comp;
                        j = 0;
                        for (C4TPrice price : criterion.getPrices()) {
                            price.setCriterionLabel(criterion.getLabel());
                            if (i == 0) {
                                year = new C4TYear();
                                year.setCompleted(true);
                                year.setPosition(j);
                                year.setYear(price.getYear());
                                if (criterion.getMandatory() != null && criterion.getMandatory() > 0 && (price.getValue() == null || price.getValue().equals("") || price.getValue().equals("0") || price.getValue().equals("0.0"))) {
                                    year.setCompleted(false);
                                }
                                ArrayList<C4TPrice> prices = new ArrayList<C4TPrice>();
                                prices.add(price);
                                year.setCriterionPrices(prices);
                                years.add(year);
                            } else {
                                year = (C4TYear)years.get(j);
                                if (criterion.getMandatory() != null && criterion.getMandatory() > 0 && (price.getValue() == null || price.getValue().equals("") || price.getValue().equals("0") || price.getValue().equals("0.0"))) {
                                    year.setCompleted(false);
                                }
                                if (year.getYear().intValue() == price.getYear().intValue()) {
                                    year.getCriterionPrices().add(price);
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                    C4TYear firstYear = (C4TYear)years.get(0);
                    currentPanel = JTreeC4TCompopnentFactory.getPanelForYear(firstYear, node, xmlTree);
                }
            } else {
                C4TTotalFOPanel panelInner = new C4TTotalFOPanel(env);
                panelInner.setBorder(BorderFactory.createEmptyBorder(40, 15, 40, 15));
                panelInner.setBackground(PanelUtils.panelColorBackground);
                JScrollPane scroll = new JScrollPane(panelInner, 20, 30);
                currentPanel.add(scroll);
            }
            return currentPanel;
        }
        Dimension longField = new Dimension(1000, 1);
        JPanel currentPanel = new JPanel();
        JPanel panelInner = new JPanel();
        panelInner.setBackground(PanelUtils.panelColorBackground);
        JScrollPane scroll = new JScrollPane(panelInner, 20, 30);
        BoxLayout boxLayout = new BoxLayout(currentPanel, 1);
        currentPanel.setLayout(boxLayout);
        BoxLayout boxLayout2 = new BoxLayout(panelInner, 1);
        panelInner.setLayout(boxLayout2);
        panelInner.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new BoxLayout(headerPanel, 0));
        headerPanel.setBackground(PanelUtils.panelColorSectionHeaderBackground);
        JLabel label = new JLabel();
        label.setFont(PanelUtils.fontSansSerifBig);
        String headerText = C4TApplicationResources.getLabel("label.envelope") + ": ";
        if (C4TXStreamConstants.C4T_XML_SECTION_TYPE_PROOF.equalsIgnoreCase(env.getType())) {
            headerText = headerText + C4TApplicationResources.getLabel(env.getName());
        }
        if (C4TXStreamConstants.C4T_XML_SECTION_TYPE_TECHNICAL.equalsIgnoreCase(env.getType())) {
            headerText = headerText + C4TApplicationResources.getLabel(env.getName());
        }
        TextWrapLabelUtil.wrapLabelText(label, headerText, TextWrapLabelUtil.headerWidth);
        label.setText(label.getText());
        headerPanel.add(label);
        headerPanel.add(Box.createHorizontalGlue());
        panelInner.add(headerPanel);
        JSeparator separator = new JSeparator();
        Border borderHead = BorderFactory.createLineBorder(Color.BLACK, 10);
        separator.setBorder(borderHead);
        separator.setMaximumSize(longField);
        separator.setMinimumSize(longField);
        panelInner.add((Component)separator, "Center");
        panelInner.add(Box.createVerticalStrut(10));
        int numberOfChildren = node.getChildCount();
        for (int i = 0; i < numberOfChildren; ++i) {
            C4TTreeNode currentTreeNode = (C4TTreeNode)node.getChildAt(i);
            JPanel tempPanel = JTreeC4TCompopnentFactory.getPanelForSubsectionSection(currentTreeNode, xmlTree);
            panelInner.add(tempPanel);
            JSeparator separatorCriterion = new JSeparator();
            Border borderCriterion = BorderFactory.createLineBorder(Color.BLACK, 1);
            separatorCriterion.setBorder(borderCriterion);
            separatorCriterion.setMaximumSize(longField);
            separatorCriterion.setMinimumSize(longField);
            panelInner.add((Component)separatorCriterion, "Center");
            panelInner.add(Box.createVerticalStrut(5));
        }
        panelInner.add(Box.createVerticalGlue());
        currentPanel.add(scroll);
        return currentPanel;
    }

    private static JPanel getPanelForSection(C4TTreeNode treeNode, JTree tree) {
        JTreeC4TCompopnent sectionComponent = (JTreeC4TCompopnent)treeNode.getUserObject();
        C4TSection section = (C4TSection)sectionComponent;
        if (section.getType().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_SECTION_TYPE_FINANCIAL)) {
            return new JPanel();
        }
        boolean isCertificate = false;
        if (section.getSectionType() != null && "sectionCertificate".equals(section.getSectionType())) {
            isCertificate = true;
        }
        Dimension longField = new Dimension(1000, 1);
        JPanel panel = new JPanel();
        JPanel panelInner = new JPanel();
        panelInner.setBackground(PanelUtils.panelColorBackground);
        JScrollPane scroll = new JScrollPane(panelInner, 20, 30);
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        panel.setLayout(boxLayout);
        BoxLayout boxLayout2 = new BoxLayout(panelInner, 1);
        panelInner.setLayout(boxLayout2);
        panelInner.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        JPanel panelHeader = JTreeC4TCompopnentFactory.getPanelForSectionHeader(treeNode, tree);
        panelInner.add(panelHeader);
        JSeparator separator = new JSeparator();
        Border borderHead = BorderFactory.createLineBorder(Color.BLACK, 10);
        separator.setBorder(borderHead);
        separator.setMaximumSize(longField);
        separator.setMinimumSize(longField);
        panelInner.add((Component)separator, "Center");
        panelInner.add(Box.createVerticalStrut(10));
        if (isCertificate) {
            JPanel certificatePanel = JTreeC4TCompopnentFactory.getPanelForCertificate(treeNode, tree, panelInner);
            panelInner.add((Component)certificatePanel, Float.valueOf(0.0f));
            panelInner.add(Box.createVerticalStrut(10));
        }
        int numberOfChildren = treeNode.getChildCount();
        HashMap<BigInteger, Iterator<C4TSectionComponent>> map = new HashMap<BigInteger, Iterator<C4TSectionComponent>>();
        for (int i = 0; i < numberOfChildren; ++i) {
            Iterator<C4TSectionComponent> currentTreeNode = (C4TTreeNode)treeNode.getChildAt(i);
            JTreeC4TCompopnent tempSectionComponent = (JTreeC4TCompopnent)((DefaultMutableTreeNode)((Object)currentTreeNode)).getUserObject();
            C4TSection mapSection = (C4TSection)tempSectionComponent;
            map.put(mapSection.getId(), currentTreeNode);
        }
        ArrayList<C4TCriterion> sectionSortedNodes = new ArrayList<C4TCriterion>();
        for (C4TSectionComponent scSrt : section.getNodes()) {
            if (!scSrt.getJType().equals((Object)JTreeC4TCompopnentType.C4TCriterion)) continue;
            C4TCriterion crit = (C4TCriterion)scSrt;
            sectionSortedNodes.add(crit);
        }
        Collections.sort(section.getNodes());
        for (C4TSectionComponent sc : section.getNodes()) {
            if (sc.getJType().equals((Object)JTreeC4TCompopnentType.C4TCriterion)) {
                C4TCriterion criterion = (C4TCriterion)sc;
                JPanel tempPanel = C4TCriterionFactory.getC4TSectionComponent(criterion, treeNode, tree);
                panelInner.add(tempPanel);
            } else if (sc.getJType().equals((Object)JTreeC4TCompopnentType.C4TSection)) {
                C4TSection tempSec = (C4TSection)sc;
                C4TTreeNode tempTreeNode = (C4TTreeNode)map.get(tempSec.getId());
                JPanel tempPanel = JTreeC4TCompopnentFactory.getPanelForSubsectionSection(tempTreeNode, tree);
                panelInner.add(tempPanel);
            }
            JSeparator separatorCriterion = new JSeparator();
            Border borderCriterion = BorderFactory.createLineBorder(Color.BLACK, 1);
            separatorCriterion.setBorder(borderCriterion);
            separatorCriterion.setMaximumSize(longField);
            separatorCriterion.setMinimumSize(longField);
            panelInner.add((Component)separatorCriterion, "Center");
            panelInner.add(Box.createVerticalStrut(5));
        }
        panelInner.add(Box.createVerticalGlue());
        panel.add(scroll);
        SectionComponentsRightBottomPanel tempPanelBottom = JTreeC4TCompopnentFactory.addPanelBottom(section);
        panel.add(tempPanelBottom);
        return panel;
    }

    private static SectionComponentsRightBottomPanel addPanelBottom(final C4TSection section) {
        final JLabel label = new JLabel();
        SectionStatisticsEventsListener listener = new SectionStatisticsEventsListener(){

            public void sectionStatisticsEventsOccurred(SectionStatisticsEvent evt) {
                C4TSectionStatistics ss = new C4TSectionStatistics(section);
                String text1 = Integer.toString(ss.getCompleteCriterions());
                String text2 = Integer.toString(ss.getCriterions());
                label.setText(C4TApplicationResources.getLabel("label.section.statistic.completed.criterions") + " " + text1 + "/" + text2);
                label.setFont(PanelUtils.fontSansSerif);
            }
        };
        final SectionComponentsRightBottomPanel panel = new SectionComponentsRightBottomPanel(listener);
        panel.setLayout(new BoxLayout(panel, 0));
        JButton saveButton = new JButton("<html><center><font color=#ffffdd>" + C4TApplicationResources.getLabel("label.button.save") + "</font>");
        Font f = saveButton.getFont().deriveFont(0);
        saveButton.setFont(f);
        saveButton.setBackground(PanelUtils.bottomPanelButtonBackground);
        saveButton.setMaximumSize(new Dimension(10, 20));
        saveButton.setOpaque(true);
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean save = FileUtils.saveXML(ApplicationSingleton.getInstance().getBody(), panel, false);
                if (ApplicationSingleton.getInstance().getIsApplet() && save) {
                    AppletCommunicationUtil.saveFromApplet(panel);
                }
            }
        });
        C4TSectionStatistics ss = new C4TSectionStatistics(section);
        String text1 = Integer.toString(ss.getCompleteCriterions());
        String text2 = Integer.toString(ss.getCriterions());
        label.setText(C4TApplicationResources.getLabel("label.section.statistic.completed.criterions") + " " + text1 + "/" + text2);
        panel.add(label);
        panel.add(Box.createHorizontalGlue());
        panel.add(saveButton);
        return panel;
    }

    private static JPanel addPanelBottom() {
        final JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JLabel label = new JLabel();
        JButton saveButton = new JButton("<html><center><font color=#ffffdd>" + C4TApplicationResources.getLabel("label.button.save") + "</font>");
        Font f = saveButton.getFont().deriveFont(0);
        saveButton.setFont(f);
        saveButton.setBackground(PanelUtils.bottomPanelButtonBackground);
        saveButton.setMaximumSize(new Dimension(10, 20));
        saveButton.setOpaque(true);
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean save = FileUtils.saveXML(ApplicationSingleton.getInstance().getBody(), panel, false);
                if (ApplicationSingleton.getInstance().getIsApplet() && save) {
                    AppletCommunicationUtil.saveFromApplet(panel);
                }
            }
        });
        panel.add(label);
        panel.add(Box.createHorizontalGlue());
        panel.add(saveButton);
        return panel;
    }

    private static JPanel getPanelForCertificate(final C4TTreeNode node, final JTree tree, final JPanel parentPanel) {
        JTreeC4TCompopnent sectionComponent = (JTreeC4TCompopnent)node.getUserObject();
        final C4TSection section = (C4TSection)sectionComponent;
        final JPanel certficatePanel = new JPanel();
        certficatePanel.setLayout(new BoxLayout(certficatePanel, 0));
        certficatePanel.setBackground(PanelUtils.panelColorBackground);
        final JCheckBox certCheck = new JCheckBox(C4TApplicationResources.getLabel("prompt.certificate.use"));
        certCheck.setSelected(section.isUseCertificate());
        certCheck.setBackground(PanelUtils.panelColorBackground);
        ActionListener checkListener = new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                section.setUseCertificate(certCheck.isSelected());
                this.toggleAllChildren(parentPanel, !certCheck.isSelected());
                TreeNodesUtil.refreshSelectedPathCert(node);
                tree.updateUI();
            }

            private void toggleAllChildren(Container parentPanel2, boolean enabled) {
                List<Component> children = Arrays.asList(parentPanel2.getComponents());
                for (Component child : children) {
                    if (child.equals(certficatePanel)) continue;
                    child.setEnabled(enabled);
                    if (child instanceof JTextField) {
                        ((JTextField)child).setText("");
                        ((JTextField)child).setEditable(enabled);
                    }
                    if (child instanceof JDateChooser) {
                        // empty if block
                    }
                    if (!(child instanceof Container)) continue;
                    this.toggleAllChildren((Container)child, enabled);
                }
            }
        };
        certCheck.addActionListener(checkListener);
        certficatePanel.add(certCheck);
        certficatePanel.add(Box.createHorizontalGlue());
        return certficatePanel;
    }

    private static JPanel getPanelForSectionHeader(final C4TTreeNode node, final JTree tree) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePath path = new TreePath(((C4TTreeNode)node.getParent()).getPath());
                tree.setSelectionPath(path);
                tree.addSelectionPath(path);
            }
        };
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BoxLayout(currentPanel, 0));
        currentPanel.setBackground(PanelUtils.panelColorSectionHeaderBackground);
        JLabel label = new JLabel();
        label.setFont(PanelUtils.fontSansSerifBig);
        JTreeC4TCompopnent sectionComponent = (JTreeC4TCompopnent)node.getUserObject();
        C4TSection section = (C4TSection)sectionComponent;
        String text = C4TXStreamUtil.convertStringToUTF(section.getLabel());
        TextWrapLabelUtil.wrapLabelText(label, text, TextWrapLabelUtil.headerWidth);
        label.setText(label.getText());
        JButton button = new JButton();
        button.setIcon(ImageC4TUtils.getImageIconPanel(3));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorderPainted(false);
        button.setBackground(PanelUtils.panelColorSectionHeaderBackground);
        button.addActionListener(actionListener);
        currentPanel.add(label);
        currentPanel.add(Box.createHorizontalGlue());
        currentPanel.add(button);
        return currentPanel;
    }

    private static JPanel getPanelForSubsectionSection(final C4TTreeNode node, final JTree tree) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePath path = new TreePath(node.getPath());
                tree.setSelectionPath(path);
                tree.addSelectionPath(path);
                tree.updateUI();
            }
        };
        MouseListener mouseListener = new MouseListener(){

            public void mouseExited(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                TreePath path = new TreePath(node.getPath());
                tree.setSelectionPath(path);
                tree.addSelectionPath(path);
                tree.updateUI();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        };
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BoxLayout(currentPanel, 0));
        currentPanel.setBackground(PanelUtils.panelColorSectionHeaderBackground);
        JLabel label = new JLabel();
        Font f = new Font("SansSerif", 1, 12);
        JTreeC4TCompopnent sectionComponent = (JTreeC4TCompopnent)node.getUserObject();
        C4TSection section = (C4TSection)sectionComponent;
        C4TSectionStatistics ss = new C4TSectionStatistics(section);
        String labelText = C4TApplicationResources.getLabel("label.section") + " " + C4TXStreamUtil.convertStringToUTF(section.getLabel());
        TextWrapLabelUtil.wrapLabelText(label, labelText, TextWrapLabelUtil.headerWidth);
        label.setText(label.getText());
        label.setToolTipText(" " + C4TApplicationResources.getLabel("label.criterions") + " " + ss.getCompleteCriterions() + "/" + ss.getCriterions() + "| " + C4TApplicationResources.getLabel("label.subsections") + " " + ss.getSebsections());
        label.setFont(PanelUtils.fontSansSerif);
        JButton button = new JButton();
        button.setIcon(ImageC4TUtils.getImageIconPanel(4));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorderPainted(false);
        button.setBackground(PanelUtils.panelColorSectionHeaderBackground);
        button.addActionListener(actionListener);
        label.addMouseListener(mouseListener);
        currentPanel.add(label);
        currentPanel.add(Box.createHorizontalGlue());
        currentPanel.add(button);
        return currentPanel;
    }

    private static JPanel getPanelForBody(JTreeC4TCompopnent sectionComponent, C4TTreeNode node, JTree xmlTree) {
        C4TBody body = (C4TBody)sectionComponent;
        JPanel panel = new JPanel();
        JPanel panelInner = new JPanel();
        JScrollPane scroll = new JScrollPane(panelInner, 20, 30);
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        panel.setLayout(boxLayout);
        BoxLayout boxLayout2 = new BoxLayout(panelInner, 1);
        panelInner.setLayout(boxLayout2);
        if (body.getSubmissionfor() != null && body.getLots() != null) {
            List<C4TLot> lots = body.getLots();
            if (body.getNumoflots() > 0) {
                int i;
                boolean messageShow;
                ActionListener lst;
                JToggleButton jBut;
                JLabel messageIncludesInSubbmision;
                JLabel textLots;
                JPanel subPanelText = new JPanel();
                BoxLayout boxLayoutsubPanelText = new BoxLayout(subPanelText, 1);
                subPanelText.setLayout(boxLayoutsubPanelText);
                subPanelText.setBackground(PanelUtils.panelColorBackground);
                ButtonGroup buttonGroup = new ButtonGroup();
                if (body.getSubmissionfor().equalsIgnoreCase("prompt.more.one.lot")) {
                    textLots = new JLabel(C4TApplicationResources.getLabel("label.lots.for.submitting"));
                    textLots.setFont(PanelUtils.fontSansSerif);
                    subPanelText.add(textLots);
                    messageIncludesInSubbmision = new JLabel(C4TApplicationResources.getLabel("label.lots.select.one.at.least"));
                    messageIncludesInSubbmision.setFont(PanelUtils.fontSansSerif);
                    messageIncludesInSubbmision.setForeground(Color.RED);
                    for (C4TLot lotsTmp : lots) {
                        jBut = new JCheckBox(C4TXStreamUtil.convertStringToUTF(lotsTmp.getTitle()));
                        jBut.setBackground(PanelUtils.panelColorBackground);
                        if (lotsTmp.getIncluded_in_submission().equalsIgnoreCase("yes")) {
                            jBut.setSelected(true);
                        } else {
                            jBut.setSelected(false);
                        }
                        lst = new ActionListener((JCheckBox)jBut, lotsTmp, subPanelText, messageIncludesInSubbmision, lots){
                            final /* synthetic */ JCheckBox val$jBut;
                            final /* synthetic */ C4TLot val$lotsTmp;
                            final /* synthetic */ JPanel val$subPanelText;
                            final /* synthetic */ JLabel val$messageIncludesInSubbmision;
                            final /* synthetic */ List val$lots;
                            {
                                this.val$jBut = jCheckBox;
                                this.val$lotsTmp = c4TLot;
                                this.val$subPanelText = jPanel;
                                this.val$messageIncludesInSubbmision = jLabel;
                                this.val$lots = list;
                            }

                            public void actionPerformed(ActionEvent e) {
                                if (this.val$jBut.isSelected()) {
                                    this.val$lotsTmp.setIncluded_in_submission("yes");
                                    this.val$subPanelText.remove(this.val$messageIncludesInSubbmision);
                                    this.val$subPanelText.updateUI();
                                    SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
                                } else {
                                    this.val$lotsTmp.setIncluded_in_submission("no");
                                    boolean messageShow = false;
                                    for (int i = 0; i < this.val$lots.size(); ++i) {
                                        if (!((C4TLot)this.val$lots.get(i)).getIncluded_in_submission().equalsIgnoreCase("yes")) continue;
                                        messageShow = true;
                                    }
                                    if (!messageShow) {
                                        this.val$subPanelText.add((Component)this.val$messageIncludesInSubbmision, 1);
                                        this.val$subPanelText.add(Box.createHorizontalGlue());
                                        this.val$subPanelText.updateUI();
                                    }
                                    SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
                                }
                            }
                        };
                        jBut.addActionListener(lst);
                        subPanelText.add(jBut);
                        subPanelText.add(Box.createHorizontalGlue());
                        messageShow = false;
                        for (i = 0; i < lots.size(); ++i) {
                            if (!lots.get(i).getIncluded_in_submission().equalsIgnoreCase("yes")) continue;
                            messageShow = true;
                        }
                        if (messageShow) continue;
                        subPanelText.add((Component)messageIncludesInSubbmision, 1);
                        subPanelText.add(Box.createHorizontalGlue());
                    }
                }
                if (body.getSubmissionfor().equalsIgnoreCase("prompt.one.lot")) {
                    textLots = new JLabel(C4TApplicationResources.getLabel("label.lots.for.submitting"));
                    textLots.setFont(PanelUtils.fontSansSerif);
                    subPanelText.add(textLots);
                    messageIncludesInSubbmision = new JLabel(C4TApplicationResources.getLabel("label.lots.select.one.only"));
                    for (C4TLot lotsTmp : lots) {
                        jBut = new JRadioButton(C4TXStreamUtil.convertStringToUTF(lotsTmp.getTitle()));
                        jBut.setBackground(PanelUtils.panelColorBackground);
                        if (lotsTmp.getIncluded_in_submission().equalsIgnoreCase("yes")) {
                            jBut.setSelected(true);
                            subPanelText.remove(messageIncludesInSubbmision);
                            subPanelText.updateUI();
                            SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
                        } else {
                            jBut.setSelected(false);
                        }
                        lst = new ActionListener((JRadioButton)jBut, lots, lotsTmp, subPanelText, messageIncludesInSubbmision){
                            final /* synthetic */ JRadioButton val$jBut;
                            final /* synthetic */ List val$lots;
                            final /* synthetic */ C4TLot val$lotsTmp;
                            final /* synthetic */ JPanel val$subPanelText;
                            final /* synthetic */ JLabel val$messageIncludesInSubbmision;
                            {
                                this.val$jBut = jRadioButton;
                                this.val$lots = list;
                                this.val$lotsTmp = c4TLot;
                                this.val$subPanelText = jPanel;
                                this.val$messageIncludesInSubbmision = jLabel;
                            }

                            public void actionPerformed(ActionEvent e) {
                                if (this.val$jBut.isSelected()) {
                                    for (int i = 0; i < this.val$lots.size(); ++i) {
                                        ((C4TLot)this.val$lots.get(i)).setIncluded_in_submission("no");
                                    }
                                    this.val$lotsTmp.setIncluded_in_submission("yes");
                                    this.val$subPanelText.remove(this.val$messageIncludesInSubbmision);
                                    this.val$subPanelText.updateUI();
                                    SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
                                }
                            }
                        };
                        jBut.addActionListener(lst);
                        buttonGroup.add(jBut);
                        subPanelText.add(jBut);
                        subPanelText.add(Box.createHorizontalGlue());
                        messageShow = false;
                        for (i = 0; i < lots.size(); ++i) {
                            if (!lots.get(i).getIncluded_in_submission().equalsIgnoreCase("yes")) continue;
                            messageShow = true;
                        }
                        if (messageShow) continue;
                        subPanelText.add(messageIncludesInSubbmision);
                        subPanelText.add(Box.createHorizontalGlue());
                    }
                }
                panelInner.add(Box.createHorizontalGlue());
                panelInner.add(subPanelText);
            }
        }
        panelInner.add(Box.createVerticalGlue());
        panelInner.setBackground(PanelUtils.panelColorBackground);
        panel.add(scroll);
        return panel;
    }

    private static JPanel getPanelForYear(C4TTreeNode node, JTree tree) {
        String[] labels;
        C4TYear year = (C4TYear)node.getUserObject();
        List<C4TPrice> prices = year.getCriterionPrices();
        final FOTableModel model = new FOTableModel();
        System.out.println("prices.size()" + prices.size());
        if (prices.size() > 1) {
            labels = new String[]{"", C4TApplicationResources.getLabel("label.fo.value"), C4TApplicationResources.getLabel("label.fo.value.present"), C4TApplicationResources.getLabel("label.fo.value.discounted") + System.getProperty("line.separator") + "\n " + C4TApplicationResources.getLabel("label.fo.value.present"), C4TApplicationResources.getLabel("label.relevant.document.all.years"), ""};
            model.setColumnNames(labels);
        } else {
            labels = new String[]{"", C4TApplicationResources.getLabel("label.fo.value"), C4TApplicationResources.getLabel("label.fo.value.present"), C4TApplicationResources.getLabel("label.fo.value.discounted") + System.getProperty("line.separator") + "\n " + C4TApplicationResources.getLabel("label.fo.value.present"), C4TApplicationResources.getLabel("label.relevant.document"), ""};
            model.setColumnNames(labels);
        }
        C4TTreeNode parentNode = (C4TTreeNode)node.getParent();
        final C4TEnvelope financial = (C4TEnvelope)parentNode.getUserObject();
        List<C4TSectionComponent> criteria = financial.getNodes();
        model.setDiscount(financial.getDiscount() != null ? financial.getDiscount().getValue() / 100.0 : 0.0);
        Double fdrValue = 0.0;
        if (financial.getFdrAllowed().booleanValue()) {
            if (financial.getFurtherDiscountValue() == null) {
                financial.setFurtherDiscountValue(new C4TPositiveDouble());
            }
            fdrValue = financial.getFurtherDiscountValue().getValue();
        }
        model.setFdrAllowed(financial.getFdrAllowed());
        model.setFurtherDiscountValue(fdrValue / 100.0);
        model.setYearPosition(year.getPosition());
        int j = 0;
        Object[][] data = new Object[prices.size()][6];
        for (C4TPrice price : prices) {
            C4TCriterion criterion = (C4TCriterion)criteria.get(j);
            boolean mandatory = criterion.getMandatory() != 0;
            data[j][0] = (mandatory ? "* " : "") + C4TXStreamUtil.convertStringToUTF(price.getCriterionLabel());
            data[j][1] = price;
            data[j][2] = "0.00";
            data[j][3] = "0.00";
            if (price.getValue() != null && !price.getValue().equals("")) {
                Double currentValueDouble = price.getValue().getValue();
                Double discountPercentage = financial.getDiscount() != null ? financial.getDiscount().getValue() / 100.0 : 0.0;
                Double presentValueD = currentValueDouble / Math.pow(1.0 + discountPercentage, year.getPosition().doubleValue());
                data[j][2] = String.format("%,.2f", presentValueD);
                Double fdrVal = 0.0;
                if (model.getFdrAllowed().booleanValue()) {
                    fdrVal = model.getFurtherDiscountValue();
                }
                data[j][3] = String.format("%,.2f", presentValueD * (1.0 - fdrVal));
            }
            data[j][4] = criterion.getRelevantDoc();
            data[j][5] = criterion;
            ++j;
        }
        model.setData(data);
        final JTextField txtFurtherDiscount = new JTextField(financial.getFdrAllowed() != false ? fdrValue.toString() : "");
        FOJTable table = new FOJTable(model, tree, node, financial, txtFurtherDiscount);
        JScrollPane scroll = new JScrollPane(table, 20, 30);
        JPanel panel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        JPanel headerPanel = new JPanel();
        BoxLayout boxLayout2 = new BoxLayout(headerPanel, 0);
        headerPanel.setLayout(boxLayout2);
        JLabel lblYear = new JLabel(C4TApplicationResources.getLabel("label.year") + " " + year.getYear().toString());
        lblYear.setFont(PanelUtils.fontSansSerifBig);
        headerPanel.add((Component)lblYear, Float.valueOf(0.0f));
        headerPanel.add(Box.createHorizontalGlue());
        JLabel lblCurrency = new JLabel(C4TApplicationResources.getLabel("label.currency"));
        lblYear.setFont(PanelUtils.fontSansSerifBig);
        headerPanel.add((Component)lblCurrency, Float.valueOf(1.0f));
        Vector<String> option = new Vector<String>();
        option.add(C4TApplicationResources.CURRENCY_PROPS.getProperty("currency.main"));
        String currencyOther = C4TApplicationResources.CURRENCY_PROPS.getProperty("currency.other");
        if (currencyOther != null && currencyOther.length() > 0) {
            String[] currencies = currencyOther.split(",");
            for (int i = 0; i < currencies.length; ++i) {
                option.add(currencies[i]);
            }
        }
        JComboBox cmb1 = new JComboBox(option);
        cmb1.setMaximumSize(new Dimension(60, 20));
        cmb1.setPreferredSize(new Dimension(60, 20));
        if (financial.getCurrency() != null) {
            for (int index = 0; index < cmb1.getItemCount(); ++index) {
                String item = (String)cmb1.getItemAt(index);
                if (item == null || !financial.getCurrency().equalsIgnoreCase(item)) continue;
                cmb1.setSelectedItem(item);
            }
        }
        cmb1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JComboBox cb = (JComboBox)evt.getSource();
                String currencyValue = (String)cb.getSelectedItem();
                financial.setCurrency(currencyValue);
            }
        });
        headerPanel.add(cmb1, Float.valueOf(1.0f));
        headerPanel.add(Box.createHorizontalGlue());
        if (!financial.getFdrAllowed().booleanValue()) {
            txtFurtherDiscount.setEnabled(false);
            txtFurtherDiscount.setBackground(Color.LIGHT_GRAY);
        }
        txtFurtherDiscount.setInputVerifier(new DoubleinputVerifier());
        ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                block5: {
                    String text = txtFurtherDiscount.getText();
                    if (text != null && !text.trim().equals("")) {
                        try {
                            Double fdr = Double.parseDouble(text);
                            if (fdr < 0.0 || fdr > 100.0) {
                                txtFurtherDiscount.transferFocus();
                                break block5;
                            }
                            financial.getFurtherDiscountValue().setValue(fdr);
                            model.setFurtherDiscountValue(fdr / 100.0);
                            model.recalculateAll();
                        }
                        catch (NumberFormatException e) {
                            txtFurtherDiscount.transferFocus();
                            System.out.println("NOT A DOUBLE " + text + " IN FDR ACTION PERFORMED");
                        }
                    } else {
                        txtFurtherDiscount.setText("0.00");
                        Double fdr = 0.0;
                        financial.getFurtherDiscountValue().setValue(fdr);
                        model.setFurtherDiscountValue(fdr / 100.0);
                        model.recalculateAll();
                    }
                }
            }
        };
        FocusListener focus = new FocusListener(){

            public void focusLost(FocusEvent evt) {
                block5: {
                    String text = txtFurtherDiscount.getText();
                    if (text != null && !text.trim().equals("")) {
                        try {
                            Double fdr = Double.parseDouble(text);
                            if (fdr < 0.0 || fdr > 100.0) {
                                txtFurtherDiscount.transferFocus();
                                break block5;
                            }
                            financial.getFurtherDiscountValue().setValue(fdr);
                            model.setFurtherDiscountValue(fdr / 100.0);
                            model.recalculateAll();
                        }
                        catch (NumberFormatException e) {
                            txtFurtherDiscount.transferFocus();
                            System.out.println("NOT A DOUBLE " + text + " IN FDR ACTION PERFORMED");
                        }
                    } else {
                        txtFurtherDiscount.setText("0.00");
                        Double fdr = 0.0;
                        financial.getFurtherDiscountValue().setValue(fdr);
                        model.setFurtherDiscountValue(fdr / 100.0);
                        model.recalculateAll();
                    }
                }
            }

            public void focusGained(FocusEvent e) {
            }
        };
        if (financial.getFdrAllowed().booleanValue()) {
            txtFurtherDiscount.addActionListener(action);
            txtFurtherDiscount.addFocusListener(focus);
            VetoableChangeListener vcl = new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
                    block4: {
                        String text = txtFurtherDiscount.getText();
                        if (text != null && !text.trim().equals("")) {
                            try {
                                Double fdr = Double.parseDouble(text);
                                if (fdr < 0.0 || fdr > 100.0) {
                                    throw new PropertyVetoException("PPPPPpercent", arg0);
                                }
                                break block4;
                            }
                            catch (NumberFormatException e) {
                                throw new PropertyVetoException("SSSSSstring", arg0);
                            }
                        }
                        txtFurtherDiscount.setText("0.00");
                    }
                    financial.getFurtherDiscountValue().setValue(Double.valueOf(txtFurtherDiscount.getText()));
                }
            };
            TreeSelectionModel o = tree.getSelectionModel();
            VetoableTreeSelectionModel vetomodel = (VetoableTreeSelectionModel)o;
            vetomodel.addSeletionChangedVetoListener(vcl);
        }
        txtFurtherDiscount.setMaximumSize(new Dimension(60, 20));
        txtFurtherDiscount.setPreferredSize(new Dimension(60, 20));
        JLabel lblFurtherDiscount = new JLabel(C4TApplicationResources.getLabel("label.fo.further.discount.rate"));
        JLabel percentage = new JLabel("%");
        headerPanel.add((Component)lblFurtherDiscount, Float.valueOf(1.0f));
        headerPanel.add((Component)txtFurtherDiscount, Float.valueOf(1.0f));
        headerPanel.add((Component)percentage, Float.valueOf(1.0f));
        panel.setLayout(boxLayout);
        panel.add(headerPanel);
        panel.add(scroll);
        JPanel tempPanelBottom = JTreeC4TCompopnentFactory.addPanelBottom();
        panel.add(tempPanelBottom);
        return panel;
    }

    private static JPanel getPanelForYear(C4TYear year, C4TTreeNode node, JTree tree) {
        String[] labels;
        List<C4TPrice> prices = year.getCriterionPrices();
        final FOTableModel model = new FOTableModel();
        System.out.println("prices.size()" + prices.size());
        if (prices.size() > 1) {
            labels = new String[]{"", C4TApplicationResources.getLabel("label.fo.value"), C4TApplicationResources.getLabel("label.fo.value.present"), C4TApplicationResources.getLabel("label.fo.value.discounted") + System.getProperty("line.separator") + "\n " + C4TApplicationResources.getLabel("label.fo.value.present"), C4TApplicationResources.getLabel("label.relevant.document.all.years"), ""};
            model.setColumnNames(labels);
        } else {
            labels = new String[]{"", C4TApplicationResources.getLabel("label.fo.value"), C4TApplicationResources.getLabel("label.fo.value.present"), C4TApplicationResources.getLabel("label.fo.value.discounted") + System.getProperty("line.separator") + "\n " + C4TApplicationResources.getLabel("label.fo.value.present"), C4TApplicationResources.getLabel("label.relevant.document"), ""};
            model.setColumnNames(labels);
        }
        final C4TEnvelope financial = (C4TEnvelope)node.getUserObject();
        List<C4TSectionComponent> criteria = financial.getNodes();
        model.setDiscount(financial.getDiscount() != null ? financial.getDiscount().getValue() / 100.0 : 0.0);
        Double fdrValue = 0.0;
        if (financial.getFdrAllowed().booleanValue()) {
            if (financial.getFurtherDiscountValue() == null) {
                financial.setFurtherDiscountValue(new C4TPositiveDouble());
            }
            fdrValue = financial.getFurtherDiscountValue().getValue();
        }
        model.setFdrAllowed(financial.getFdrAllowed());
        model.setFurtherDiscountValue(fdrValue / 100.0);
        model.setYearPosition(year.getPosition());
        int j = 0;
        Object[][] data = new Object[prices.size()][6];
        for (C4TPrice price : prices) {
            C4TCriterion criterion = (C4TCriterion)criteria.get(j);
            boolean mandatory = criterion.getMandatory() != 0;
            data[j][0] = (mandatory ? "* " : "") + C4TXStreamUtil.convertStringToUTF(price.getCriterionLabel());
            data[j][1] = price;
            data[j][2] = "0.00";
            data[j][3] = "0.00";
            if (price.getValue() != null && !price.getValue().equals("")) {
                Double currentValueDouble = price.getValue().getValue();
                Double discountPercentage = financial.getDiscount() != null ? financial.getDiscount().getValue() / 100.0 : 0.0;
                Double presentValueD = currentValueDouble / Math.pow(1.0 + discountPercentage, year.getPosition().doubleValue());
                data[j][2] = String.format("%,.2f", presentValueD);
                Double fdrVal = 0.0;
                if (model.getFdrAllowed().booleanValue()) {
                    fdrVal = model.getFurtherDiscountValue();
                }
                data[j][3] = String.format("%,.2f", presentValueD * (1.0 - fdrVal));
            }
            data[j][4] = criterion.getRelevantDoc();
            data[j][5] = criterion;
            ++j;
        }
        model.setData(data);
        final JTextField txtFurtherDiscount = new JTextField(financial.getFdrAllowed() != false ? fdrValue.toString() : "");
        FOJTable table = new FOJTable(model, tree, node, financial, txtFurtherDiscount);
        JScrollPane scroll = new JScrollPane(table, 20, 30);
        JPanel panel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        JPanel headerPanel = new JPanel();
        BoxLayout boxLayout2 = new BoxLayout(headerPanel, 0);
        headerPanel.setLayout(boxLayout2);
        JLabel lblYear = new JLabel(C4TApplicationResources.getLabel("label.year") + " " + year.getYear().toString());
        lblYear.setFont(PanelUtils.fontSansSerifBig);
        headerPanel.add((Component)lblYear, Float.valueOf(0.0f));
        headerPanel.add(Box.createHorizontalGlue());
        JLabel lblCurrency = new JLabel(C4TApplicationResources.getLabel("label.currency"));
        lblYear.setFont(PanelUtils.fontSansSerifBig);
        headerPanel.add((Component)lblCurrency, Float.valueOf(1.0f));
        Vector<String> option = new Vector<String>();
        option.add(C4TApplicationResources.CURRENCY_PROPS.getProperty("currency.main"));
        String currencyOther = C4TApplicationResources.CURRENCY_PROPS.getProperty("currency.other");
        if (currencyOther != null && currencyOther.length() > 0) {
            String[] currencies = currencyOther.split(",");
            for (int i = 0; i < currencies.length; ++i) {
                option.add(currencies[i]);
            }
        }
        JComboBox cmb1 = new JComboBox(option);
        cmb1.setMaximumSize(new Dimension(60, 20));
        cmb1.setPreferredSize(new Dimension(60, 20));
        if (financial.getCurrency() != null) {
            for (int index = 0; index < cmb1.getItemCount(); ++index) {
                String item = (String)cmb1.getItemAt(index);
                if (item == null || !financial.getCurrency().equalsIgnoreCase(item)) continue;
                cmb1.setSelectedItem(item);
            }
        }
        cmb1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JComboBox cb = (JComboBox)evt.getSource();
                String currencyValue = (String)cb.getSelectedItem();
                financial.setCurrency(currencyValue);
            }
        });
        headerPanel.add(cmb1, Float.valueOf(1.0f));
        headerPanel.add(Box.createHorizontalGlue());
        if (!financial.getFdrAllowed().booleanValue()) {
            txtFurtherDiscount.setEnabled(false);
            txtFurtherDiscount.setBackground(Color.LIGHT_GRAY);
        }
        txtFurtherDiscount.setInputVerifier(new DoubleinputVerifier());
        ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                block5: {
                    String text = txtFurtherDiscount.getText();
                    if (text != null && !text.trim().equals("")) {
                        try {
                            Double fdr = Double.parseDouble(text);
                            if (fdr < 0.0 || fdr > 100.0) {
                                txtFurtherDiscount.transferFocus();
                                break block5;
                            }
                            financial.getFurtherDiscountValue().setValue(fdr);
                            model.setFurtherDiscountValue(fdr / 100.0);
                            model.recalculateAll();
                        }
                        catch (NumberFormatException e) {
                            txtFurtherDiscount.transferFocus();
                            System.out.println("NOT A DOUBLE " + text + " IN FDR ACTION PERFORMED");
                        }
                    } else {
                        txtFurtherDiscount.setText("0.00");
                        Double fdr = 0.0;
                        financial.getFurtherDiscountValue().setValue(fdr);
                        model.setFurtherDiscountValue(fdr / 100.0);
                        model.recalculateAll();
                    }
                }
            }
        };
        FocusListener focus = new FocusListener(){

            public void focusLost(FocusEvent evt) {
                block5: {
                    String text = txtFurtherDiscount.getText();
                    if (text != null && !text.trim().equals("")) {
                        try {
                            Double fdr = Double.parseDouble(text);
                            if (fdr < 0.0 || fdr > 100.0) {
                                txtFurtherDiscount.transferFocus();
                                break block5;
                            }
                            financial.getFurtherDiscountValue().setValue(fdr);
                            model.setFurtherDiscountValue(fdr / 100.0);
                            model.recalculateAll();
                        }
                        catch (NumberFormatException e) {
                            txtFurtherDiscount.transferFocus();
                            System.out.println("NOT A DOUBLE " + text + " IN FDR ACTION PERFORMED");
                        }
                    } else {
                        txtFurtherDiscount.setText("0.00");
                        Double fdr = 0.0;
                        financial.getFurtherDiscountValue().setValue(fdr);
                        model.setFurtherDiscountValue(fdr / 100.0);
                        model.recalculateAll();
                    }
                }
            }

            public void focusGained(FocusEvent e) {
            }
        };
        if (financial.getFdrAllowed().booleanValue()) {
            txtFurtherDiscount.addActionListener(action);
            txtFurtherDiscount.addFocusListener(focus);
            VetoableChangeListener vcl = new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
                    block4: {
                        String text = txtFurtherDiscount.getText();
                        if (text != null && !text.trim().equals("")) {
                            try {
                                Double fdr = Double.parseDouble(text);
                                if (fdr < 0.0 || fdr > 100.0) {
                                    throw new PropertyVetoException("PPPPPpercent", arg0);
                                }
                                break block4;
                            }
                            catch (NumberFormatException e) {
                                throw new PropertyVetoException("SSSSSstring", arg0);
                            }
                        }
                        txtFurtherDiscount.setText("0.00");
                    }
                    financial.getFurtherDiscountValue().setValue(Double.valueOf(txtFurtherDiscount.getText()));
                }
            };
            TreeSelectionModel o = tree.getSelectionModel();
            VetoableTreeSelectionModel vetomodel = (VetoableTreeSelectionModel)o;
            vetomodel.addSeletionChangedVetoListener(vcl);
        }
        txtFurtherDiscount.setMaximumSize(new Dimension(60, 20));
        txtFurtherDiscount.setPreferredSize(new Dimension(60, 20));
        JLabel lblFurtherDiscount = new JLabel(C4TApplicationResources.getLabel("label.fo.further.discount.rate"));
        JLabel percentage = new JLabel("%");
        headerPanel.add((Component)lblFurtherDiscount, Float.valueOf(1.0f));
        headerPanel.add((Component)txtFurtherDiscount, Float.valueOf(1.0f));
        headerPanel.add((Component)percentage, Float.valueOf(1.0f));
        panel.setLayout(boxLayout);
        panel.add(headerPanel);
        panel.add(scroll);
        JPanel tempPanelBottom = JTreeC4TCompopnentFactory.addPanelBottom();
        panel.add(tempPanelBottom);
        return panel;
    }

    private static void changePresentDiscountedValua(C4TEnvelope financial, FOTableModel model, JTextField txtFurtherDiscount) {
        block5: {
            String text = txtFurtherDiscount.getText();
            if (text != null && !text.trim().equals("")) {
                try {
                    Double fdr = Double.parseDouble(text);
                    if (fdr < 0.0 || fdr > 100.0) {
                        txtFurtherDiscount.transferFocus();
                        break block5;
                    }
                    financial.getFurtherDiscountValue().setValue(fdr);
                    model.setFurtherDiscountValue(fdr / 100.0);
                    model.recalculateAll();
                }
                catch (NumberFormatException ex) {
                    System.out.println("NOT A DOUBLE " + text + " IN FDR ACTION PERFORMED");
                }
            } else {
                txtFurtherDiscount.setText("0.00");
                Double fdr = 0.0;
                financial.getFurtherDiscountValue().setValue(fdr);
                model.setFurtherDiscountValue(fdr / 100.0);
                model.recalculateAll();
            }
        }
    }
}

