/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.helper;

import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ConfigHelper {
    private JLabel proxyHostLbl;
    private JTextField proxyHostTxt;
    private JLabel proxyPassLbl;
    private JTextField proxyPassTxt;
    private JLabel proxyPortLbl;
    private JTextField proxyPortTxt;
    private JLabel proxyUserLbl;
    private JTextField proxyUserTxt;
    private JPanel hostPanel;
    private JPanel userPanel;
    private JPanel passPanel;
    private JPanel portPanel;

    public void createConfigdialog(Frame owner) {
        final JDialog config = new JDialog(owner, "Configuration", true);
        config.setSize(400, 260);
        config.setBackground(Color.WHITE);
        config.setResizable(false);
        JPanel configPanel = new JPanel();
        configPanel.setBackground(Color.WHITE);
        configPanel.setLayout(new BoxLayout(configPanel, 1));
        configPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        config.add(configPanel);
        JPanel proxyPanel = new JPanel();
        proxyPanel.setBackground(Color.WHITE);
        proxyPanel.setBorder(BorderFactory.createTitledBorder(C4TApplicationResources.getLabel("prompt.area.communication.settings")));
        this.createInputFields();
        proxyPanel.setLayout(this.createProxyPanelLayout(proxyPanel));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.setBackground(Color.WHITE);
        JButton saveButton = new JButton("<html><center><font color=#ffffdd>Save</font>");
        saveButton.setMaximumSize(new Dimension(40, 30));
        Font f = saveButton.getFont().deriveFont(0);
        saveButton.setFont(f);
        saveButton.setBackground(new Color(39, 83, 118));
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigHelper.this.saveApplicationConfigurationOptionsAction(config);
            }
        });
        JButton closeButton = new JButton("<html><center><font color=#ffffdd>Close</font>");
        closeButton.setMaximumSize(new Dimension(40, 30));
        f = closeButton.getFont().deriveFont(0);
        closeButton.setFont(f);
        closeButton.setBackground(new Color(39, 83, 118));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                config.setVisible(false);
            }
        });
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(saveButton);
        bottomPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        bottomPanel.add(closeButton);
        configPanel.add(proxyPanel);
        configPanel.add(Box.createVerticalGlue());
        configPanel.add(bottomPanel);
        configPanel.add(Box.createHorizontalGlue());
        config.setVisible(true);
    }

    private GroupLayout createProxyPanelLayout(JPanel proxyPanel) {
        GroupLayout layout = new GroupLayout(proxyPanel);
        JLabel helpTextLbl = new JLabel(C4TApplicationResources.getLabel("helptext.area.communication.settings"));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(helpTextLbl, GroupLayout.Alignment.LEADING, -1, 340, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proxyHostLbl, -1, 149, Short.MAX_VALUE).addComponent(this.proxyPortLbl, -1, 149, Short.MAX_VALUE).addComponent(this.proxyUserLbl, -1, 149, Short.MAX_VALUE).addComponent(this.proxyPassLbl, -1, 149, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.proxyPassTxt, GroupLayout.Alignment.TRAILING, -1, 187, Short.MAX_VALUE).addComponent(this.proxyUserTxt, GroupLayout.Alignment.TRAILING, -1, 187, Short.MAX_VALUE).addComponent(this.proxyPortTxt, GroupLayout.Alignment.TRAILING, -1, 187, Short.MAX_VALUE).addComponent(this.proxyHostTxt, GroupLayout.Alignment.TRAILING, -1, 187, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(helpTextLbl, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proxyHostLbl).addComponent(this.proxyHostTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proxyPortLbl).addComponent(this.proxyPortTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proxyUserLbl).addComponent(this.proxyUserTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proxyPassLbl).addComponent(this.proxyPassTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        return layout;
    }

    private void createInputFields() {
        this.hostPanel = new JPanel();
        this.hostPanel.setBackground(Color.WHITE);
        this.hostPanel.setLayout(new BoxLayout(this.hostPanel, 0));
        this.hostPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.proxyHostLbl = this.createLabel(C4TApplicationResources.getLabel("prompt.proxy.host"));
        this.proxyHostTxt = this.createInputText();
        this.proxyHostTxt.setText(C4TApplicationResources.PACK_PROPS.getProperty("proxy.host"));
        this.hostPanel.add(this.proxyHostLbl);
        this.hostPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.hostPanel.add(this.proxyHostTxt);
        this.portPanel = new JPanel();
        this.portPanel.setBackground(Color.WHITE);
        this.portPanel.setLayout(new BoxLayout(this.portPanel, 0));
        this.portPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.proxyPortLbl = this.createLabel(C4TApplicationResources.getLabel("prompt.proxy.port"));
        this.proxyPortTxt = this.createInputText();
        this.proxyPortTxt.setText(C4TApplicationResources.PACK_PROPS.getProperty("proxy.port"));
        this.portPanel.add(this.proxyPortLbl);
        this.portPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.portPanel.add(this.proxyPortTxt);
        this.userPanel = new JPanel();
        this.userPanel.setBackground(Color.WHITE);
        this.userPanel.setLayout(new BoxLayout(this.userPanel, 0));
        this.userPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.proxyUserTxt = this.createInputText();
        this.proxyUserTxt.setText(C4TApplicationResources.PACK_PROPS.getProperty("proxy.user"));
        this.proxyUserLbl = this.createLabel(C4TApplicationResources.getLabel("prompt.proxy.user"));
        this.userPanel.add(this.proxyUserLbl);
        this.userPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.userPanel.add(this.proxyUserTxt);
        this.passPanel = new JPanel();
        this.passPanel.setBackground(Color.WHITE);
        this.passPanel.setLayout(new BoxLayout(this.passPanel, 0));
        this.passPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.proxyPassLbl = this.createLabel(C4TApplicationResources.getLabel("prompt.proxy.pass"));
        this.proxyPassTxt = this.createInputText();
        this.proxyPassTxt.setText(C4TApplicationResources.PACK_PROPS.getProperty("proxy.pass"));
        this.passPanel.add(this.proxyPassLbl);
        this.passPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.passPanel.add(this.proxyPassTxt);
    }

    private JTextField createInputText() {
        JTextField textField = new JTextField();
        textField.setMinimumSize(new Dimension(150, 20));
        textField.setPreferredSize(new Dimension(150, 20));
        textField.setMaximumSize(new Dimension(150, 20));
        return textField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel();
        label.setFont(new Font("Tahoma", 1, 11));
        label.setText(text);
        label.setHorizontalTextPosition(0);
        return label;
    }

    private void saveApplicationConfigurationOptionsAction(JDialog config) {
        this.updateAndStoreConfigurationProperties();
        config.dispose();
        config.setVisible(false);
    }

    private void updateAndStoreConfigurationProperties() {
        Properties configurationProperties = C4TApplicationResources.PACK_PROPS;
        configurationProperties.setProperty("proxy.host", this.proxyHostTxt.getText());
        configurationProperties.setProperty("proxy.port", this.proxyPortTxt.getText());
        configurationProperties.setProperty("proxy.user", this.proxyUserTxt.getText());
        configurationProperties.setProperty("proxy.pass", this.proxyPassTxt.getText());
        C4TApplicationResources.storeProps("packing.properties", configurationProperties);
    }
}

