/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.helper;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.C4TSectionStatistics;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.ImageC4TUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TLot;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TSection;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.JTreeC4TCompopnent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class CustomTreeCellRenderer
extends DefaultTreeCellRenderer {
    static Icon[] treeIcons = new Icon[]{ImageC4TUtils.getImageIcon(4), ImageC4TUtils.getImageIcon(4), ImageC4TUtils.getImageIcon(8), ImageC4TUtils.getImageIcon(5), ImageC4TUtils.getImageIcon(6), ImageC4TUtils.getImageIcon(6), ImageC4TUtils.getImageIcon(9), ImageC4TUtils.getImageIcon(7)};
    static Icon bodyIcon = ImageC4TUtils.getImageTreeIcon(0);
    static Icon[] treeSectionIcons = new Icon[]{ImageC4TUtils.getImageTreeIcon(1), ImageC4TUtils.getImageTreeIcon(2), ImageC4TUtils.getImageTreeIcon(3), ImageC4TUtils.getImageTreeIcon(4)};
    static Icon[] treeEnvelopeIcons = new Icon[]{ImageC4TUtils.getImageTreeIcon(5), ImageC4TUtils.getImageTreeIcon(6), ImageC4TUtils.getImageTreeIcon(7), ImageC4TUtils.getImageTreeIcon(8)};
    static Icon[] treeLotIcons = new Icon[]{ImageC4TUtils.getImageTreeIcon(9), ImageC4TUtils.getImageTreeIcon(10), ImageC4TUtils.getImageTreeIcon(11), ImageC4TUtils.getImageTreeIcon(12)};
    static Icon[] yearLotIcons = new Icon[]{ImageC4TUtils.getImageTreeIcon(13), ImageC4TUtils.getImageTreeIcon(14), ImageC4TUtils.getImageTreeIcon(15), ImageC4TUtils.getImageTreeIcon(16)};

    public CustomTreeCellRenderer(Icon[] icon) {
        treeIcons = icon;
    }

    public CustomTreeCellRenderer(JTree xmlTree) {
        ToolTipManager.sharedInstance().registerComponent(xmlTree);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        C4TTreeNode node = (C4TTreeNode)value;
        int typeIndex = 0;
        int completeIndex = 0;
        int hasCriterionIndex = 0;
        Object obj = node.getUserObject();
        JTreeC4TCompopnent nodeTree = (JTreeC4TCompopnent)obj;
        if (node.getState().getIsCompleted() != null) {
            switch (node.getState().getIsCompleted()) {
                case True: {
                    completeIndex = 1;
                    break;
                }
                case False: {
                    completeIndex = 0;
                }
            }
        }
        if (node.getState().getHasCriterions() != null) {
            switch (node.getState().getHasCriterions()) {
                case True: {
                    hasCriterionIndex = 1;
                    break;
                }
                case False: {
                    hasCriterionIndex = 0;
                }
            }
        }
        int fullIndex = completeIndex * 2 + hasCriterionIndex;
        switch (node.getState().getNodeType()) {
            case C4TCriterion: {
                typeIndex = 1;
                this.setIcon(treeIcons[(typeIndex - 1) * 2 + completeIndex]);
                this.setPreferredSize(new Dimension(200, 20));
                break;
            }
            case C4TEnvelope: {
                this.setIcon(treeEnvelopeIcons[fullIndex]);
                C4TEnvelope env = (C4TEnvelope)node.getUserObject();
                this.setText(C4TApplicationResources.getLabel(env.getName()));
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int width = SwingUtilities.computeStringWidth(fm, this.getText()) + 50;
                this.setPreferredSize(new Dimension(width, 20));
                break;
            }
            case C4TSection: {
                this.setIcon(treeSectionIcons[fullIndex]);
                C4TSection sec = (C4TSection)node.getUserObject();
                C4TSectionStatistics ss = new C4TSectionStatistics(sec);
                this.setToolTipText(C4TApplicationResources.getLabel("label.completed") + " " + ss.getCompleteCriterions() + "/" + ss.getCriterions());
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int width = SwingUtilities.computeStringWidth(fm, sec.writeValues()) + 50;
                this.setPreferredSize(new Dimension(width, 20));
                break;
            }
            case C4TLot: {
                this.setIcon(bodyIcon);
                C4TLot lot = (C4TLot)node.getUserObject();
                this.setText(C4TApplicationResources.getLabel("label.lot") + " " + C4TXStreamUtil.convertStringToUTF(lot.getTitle()));
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int width = SwingUtilities.computeStringWidth(fm, this.getText()) + 50;
                this.setPreferredSize(new Dimension(width, 20));
                break;
            }
            case C4TBody: {
                this.setIcon(bodyIcon);
                this.setText(C4TApplicationResources.getLabel("label.tender"));
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int width = SwingUtilities.computeStringWidth(fm, this.getText()) + 50;
                this.setPreferredSize(new Dimension(width, 20));
                break;
            }
            case C4TYear: {
                this.setIcon(yearLotIcons[3]);
                this.setText(C4TApplicationResources.getLabel("label.year"));
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int width = SwingUtilities.computeStringWidth(fm, this.getText()) + 50;
                this.setPreferredSize(new Dimension(width, 20));
                break;
            }
            default: {
                typeIndex = 1;
                JTreeC4TCompopnent jTreeC4TCompopnent = (JTreeC4TCompopnent)obj;
            }
        }
        return this;
    }
}

