/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.helper;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.JTreeC4TCompopnentType;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNodeState;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TBody;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TLot;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TPrice;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TSection;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TYear;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamConstants;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.C4TSectionComponent;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.JTreeC4TCompopnent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodesUtil {
    public static boolean isValid(C4TTreeNode node) {
        if (node.getState().getNodeType() == JTreeC4TCompopnentType.C4TBody) {
            JTreeC4TCompopnent sectionComponent = (JTreeC4TCompopnent)node.getUserObject();
            C4TBody body = (C4TBody)sectionComponent;
            boolean validFlag = true;
            int numberOfChildren = node.getChildCount();
            ArrayList uncompletedTreeNodes = new ArrayList();
            for (int i = 0; i < numberOfChildren; ++i) {
                C4TTreeNode currentTreeNode = (C4TTreeNode)node.getChildAt(i);
                JTreeC4TCompopnent currentTreeNodeC4T = (JTreeC4TCompopnent)currentTreeNode.getUserObject();
                if (currentTreeNodeC4T.getJType() == JTreeC4TCompopnentType.C4TLot) {
                    C4TLot lot = (C4TLot)currentTreeNodeC4T;
                    if ((lot.getIncluded_in_submission() == null || !lot.getIncluded_in_submission().equalsIgnoreCase("yes")) && !body.getSubmissionfor().equalsIgnoreCase("prompt.all.lots")) continue;
                    int childrenSize = currentTreeNode.getChildCount();
                    List<Object> tempTreeNodes = new ArrayList();
                    for (int j = 0; j < childrenSize; ++j) {
                        tempTreeNodes = TreeNodesUtil.getUnCompletedTreeNodes((C4TTreeNode)currentTreeNode.getChildAt(j));
                        uncompletedTreeNodes.addAll(tempTreeNodes);
                    }
                    continue;
                }
                if (currentTreeNode.getState().getIsCompleted() != C4TTreeNodeState.C4TTreeNodeIsCompleted.False) continue;
                List<C4TTreeNode> tempTreeNodes = TreeNodesUtil.getUnCompletedTreeNodes(currentTreeNode);
                uncompletedTreeNodes.addAll(tempTreeNodes);
            }
            if (uncompletedTreeNodes.size() > 0) {
                validFlag = false;
            }
            return validFlag;
        }
        return false;
    }

    public static void refreshSelectedPath(C4TTreeNode node) {
        C4TTreeNodeState.C4TTreeNodeIsCompleted isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.True;
        switch (node.getState().getNodeType()) {
            case C4TBody: {
                return;
            }
            case C4TCriterion: {
                return;
            }
            case C4TLot: {
                break;
            }
            case C4TSection: {
                C4TSection section = (C4TSection)node.getUserObject();
                for (C4TSectionComponent sc : section.getNodes()) {
                    switch (sc.getJType()) {
                        case C4TCriterion: {
                            C4TCriterion crit = (C4TCriterion)sc;
                            if (C4TXStreamUtil.isCriterionCompleted(crit)) break;
                            isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                        }
                    }
                }
                break;
            }
            case C4TEnvelope: {
                break;
            }
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            C4TTreeNode childNode = (C4TTreeNode)en.nextElement();
            switch (childNode.getState().getIsCompleted()) {
                case False: {
                    isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                    break;
                }
            }
        }
        node.getState().setIsCompleted(isComplete);
        TreeNodesUtil.refreshSelectedPath((C4TTreeNode)node.getParent());
    }

    public static void refreshSelectedPathCert(C4TTreeNode node) {
        C4TTreeNodeState.C4TTreeNodeIsCompleted isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.True;
        switch (node.getState().getNodeType()) {
            case C4TBody: {
                return;
            }
            case C4TCriterion: {
                return;
            }
            case C4TLot: {
                break;
            }
            case C4TSection: {
                C4TSection section = (C4TSection)node.getUserObject();
                boolean isCertificate = "sectionCertificate".equals(section.getSectionType());
                boolean useCertificate = section.isUseCertificate();
                if (isCertificate) {
                    if (useCertificate) {
                        TreeNodesUtil.markCertSection(node, C4TTreeNodeState.C4TTreeNodeIsCompleted.True);
                        TreeNodesUtil.refreshSelectedPath((C4TTreeNode)node.getParent());
                        return;
                    }
                    TreeNodesUtil.markCertSection(node, C4TTreeNodeState.C4TTreeNodeIsCompleted.False);
                }
                for (C4TSectionComponent sc : section.getNodes()) {
                    switch (sc.getJType()) {
                        case C4TCriterion: {
                            C4TCriterion crit = (C4TCriterion)sc;
                            if (C4TXStreamUtil.isCriterionCompleted(crit)) break;
                            isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                        }
                    }
                }
                break;
            }
            case C4TEnvelope: {
                break;
            }
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            C4TTreeNode childNode = (C4TTreeNode)en.nextElement();
            switch (childNode.getState().getIsCompleted()) {
                case False: {
                    isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                    break;
                }
            }
        }
        node.getState().setIsCompleted(isComplete);
        TreeNodesUtil.refreshSelectedPath((C4TTreeNode)node.getParent());
    }

    private static void markCertSection(C4TTreeNode node, C4TTreeNodeState.C4TTreeNodeIsCompleted isCompleted) {
        node.getState().setIsCompleted(isCompleted);
        if (node.getState().getNodeType() == JTreeC4TCompopnentType.C4TSection) {
            C4TSection section = (C4TSection)node.getUserObject();
            Enumeration<TreeNode> en = node.children();
            while (en.hasMoreElements()) {
                C4TTreeNode childNode = (C4TTreeNode)en.nextElement();
                TreeNodesUtil.markCertSection(childNode, isCompleted);
            }
        }
    }

    public static void refreshSelectedPathForFinancialOld(C4TTreeNode node) {
        switch (node.getState().getNodeType()) {
            case C4TBody: {
                return;
            }
            case C4TEnvelope: {
                node.getState().setIsCompleted(C4TTreeNodeState.C4TTreeNodeIsCompleted.True);
                C4TEnvelope envelope = (C4TEnvelope)node.getUserObject();
                if (envelope.getPresentValueCalc() != null && !envelope.getPresentValueCalc().booleanValue()) {
                    for (C4TSectionComponent sc : envelope.getNodes()) {
                        C4TCriterion crit = (C4TCriterion)sc;
                        for (C4TPrice price : crit.getPrices()) {
                            if (price.getValue().getValue() != 0.0) continue;
                            node.getState().setIsCompleted(C4TTreeNodeState.C4TTreeNodeIsCompleted.False);
                        }
                    }
                } else {
                    Enumeration<TreeNode> en = node.children();
                    while (en.hasMoreElements()) {
                        C4TTreeNode childNode = (C4TTreeNode)en.nextElement();
                        switch (childNode.getState().getIsCompleted()) {
                            case False: {
                                node.getState().setIsCompleted(C4TTreeNodeState.C4TTreeNodeIsCompleted.False);
                                break;
                            }
                        }
                    }
                }
                break;
            }
            case C4TYear: {
                C4TYear year = (C4TYear)node.getUserObject();
                node.getState().setIsCompleted(C4TTreeNodeState.C4TTreeNodeIsCompleted.True);
                List<C4TPrice> criterionPrices = year.getCriterionPrices();
                for (C4TPrice cp : criterionPrices) {
                    if (cp.getValue().getValue() != 0.0) continue;
                    node.getState().setIsCompleted(C4TTreeNodeState.C4TTreeNodeIsCompleted.False);
                }
                break;
            }
        }
        TreeNodesUtil.refreshSelectedPathForFinancialOld((C4TTreeNode)node.getParent());
    }

    public static void refreshSelectedPathForFinancial(C4TTreeNode node) {
        switch (node.getState().getNodeType()) {
            case C4TBody: {
                return;
            }
            case C4TEnvelope: {
                boolean isCompletedEnvelope = true;
                C4TEnvelope envelope = (C4TEnvelope)node.getUserObject();
                for (C4TSectionComponent sc : envelope.getNodes()) {
                    C4TCriterion crit = (C4TCriterion)sc;
                    if (crit.getMandatory() == 1) {
                        boolean isCompletedCriterion = false;
                        for (C4TPrice price : crit.getPrices()) {
                            if (!(price.getValue().getValue() > 0.0)) continue;
                            isCompletedCriterion = true;
                        }
                        if (!isCompletedCriterion) {
                            isCompletedEnvelope = false;
                        }
                    }
                    if (crit.getMandatorytAttachment() == null || crit.getMandatorytAttachment() != 1 || crit.getRelevantDoc() != null && !crit.getRelevantDoc().equals("")) continue;
                    isCompletedEnvelope = false;
                }
                if (isCompletedEnvelope) {
                    node.getState().setIsCompleted(C4TTreeNodeState.C4TTreeNodeIsCompleted.True);
                    break;
                }
                node.getState().setIsCompleted(C4TTreeNodeState.C4TTreeNodeIsCompleted.False);
                break;
            }
        }
        TreeNodesUtil.refreshSelectedPathForFinancial((C4TTreeNode)node.getParent());
    }

    public static void refreshSelectedPathForFinancialMultiItem(C4TTreeNode node) {
        switch (node.getState().getNodeType()) {
            case C4TEnvelope: {
                C4TTreeNodeState.C4TTreeNodeIsCompleted isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.True;
                C4TEnvelope envelope = (C4TEnvelope)node.getUserObject();
                if (!envelope.getAwarded_per_item().getValue().booleanValue()) {
                    for (C4TSectionComponent sc : envelope.getNodes()) {
                        C4TCriterion crit = (C4TCriterion)sc;
                        if (crit.getUnit_price() != null && crit.getUnit_price() != 0.0) continue;
                        isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                    }
                } else {
                    for (C4TSectionComponent sc : envelope.getNodes()) {
                        C4TCriterion crit = (C4TCriterion)sc;
                        if (crit.getMandatory() == 1 && (crit.getUnit_price() == null || crit.getUnit_price() == 0.0)) {
                            isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                        }
                        if (crit.getMandatorytAttachment() == null || crit.getMandatorytAttachment() != 1 || crit.getRelevantDoc() != null && !crit.getRelevantDoc().equals("")) continue;
                        isComplete = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                    }
                }
                node.getState().setIsCompleted(isComplete);
            }
        }
    }

    private static List<C4TTreeNode> getUnCompletedTreeNodes(C4TTreeNode node) {
        boolean nodeUncompleted = false;
        JTreeC4TCompopnent sectionComponent = (JTreeC4TCompopnent)node.getUserObject();
        List<Object> listC4T = new ArrayList();
        switch (sectionComponent.getJType()) {
            case C4TSection: {
                listC4T = ((C4TSection)sectionComponent).getNodes();
                break;
            }
            case C4TEnvelope: {
                listC4T = ((C4TEnvelope)sectionComponent).getNodes();
                C4TEnvelope env = (C4TEnvelope)sectionComponent;
                if (!env.getType().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_SECTION_TYPE_FINANCIAL)) break;
                ArrayList<C4TTreeNode> unCompletedFinancialEnvelope = new ArrayList<C4TTreeNode>();
                switch (node.getState().getIsCompleted()) {
                    case False: {
                        unCompletedFinancialEnvelope.add(node);
                        break;
                    }
                }
                return unCompletedFinancialEnvelope;
            }
        }
        int numberOfChildren = node.getChildCount();
        HashMap<BigInteger, C4TTreeNode> map = new HashMap<BigInteger, C4TTreeNode>();
        for (int i = 0; i < numberOfChildren; ++i) {
            C4TTreeNode currentTreeNode = (C4TTreeNode)node.getChildAt(i);
            JTreeC4TCompopnent jTreeC4TCompopnent = (JTreeC4TCompopnent)currentTreeNode.getUserObject();
            C4TSection mapSection = (C4TSection)jTreeC4TCompopnent;
            map.put(mapSection.getId(), currentTreeNode);
        }
        ArrayList<C4TTreeNode> list = new ArrayList<C4TTreeNode>();
        if (listC4T != null) {
            for (C4TSectionComponent c4TSectionComponent : listC4T) {
                List<C4TTreeNode> listTemp = null;
                C4TTreeNode tempTreeNode = null;
                switch (c4TSectionComponent.getJType()) {
                    case C4TCriterion: {
                        if (C4TXStreamUtil.isCriterionCompleted((C4TCriterion)c4TSectionComponent)) break;
                        nodeUncompleted = true;
                        break;
                    }
                    case C4TSection: {
                        C4TSection tempSec = (C4TSection)c4TSectionComponent;
                        tempTreeNode = (C4TTreeNode)map.get(tempSec.getId());
                        if (tempTreeNode.getState().getIsCompleted() != C4TTreeNodeState.C4TTreeNodeIsCompleted.False) break;
                        listTemp = TreeNodesUtil.getUnCompletedTreeNodes(tempTreeNode);
                        list.addAll(listTemp);
                        break;
                    }
                }
            }
        }
        if (nodeUncompleted) {
            list.add(0, node);
        }
        return list;
    }
}

