/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.hyperlink;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.hyperlink.BrowserCommandLexer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;

public class Browser {
    private static Browser instance = null;
    private static String[] exec = null;

    protected Browser() {
    }

    public static Browser getInstance() {
        if (instance == null) {
            instance = new Browser();
            instance.init();
        }
        return instance;
    }

    private void init() {
        exec = this.defaultCommands();
        System.out.println("exec = " + exec);
    }

    private String[] defaultCommands() {
        Object execLocal = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            execLocal = new String[]{"rundll32 url.dll,FileProtocolHandler {0}"};
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            ArrayList<String> browsers = new ArrayList<String>();
            try {
                Process p = Runtime.getRuntime().exec("which open");
                if (p.waitFor() == 0) {
                    browsers.add("open {0}");
                }
            }
            catch (IOException p) {
            }
            catch (InterruptedException p) {
                // empty catch block
            }
            execLocal = browsers.size() == 0 ? null : browsers.toArray(new String[0]);
        } else if (System.getProperty("os.name").startsWith("SunOS")) {
            execLocal = new String[]{"/usr/dt/bin/sdtwebclient {0}"};
        } else {
            Process p2;
            ArrayList<String> browsers = new ArrayList<String>();
            try {
                p2 = Runtime.getRuntime().exec("which firefox");
                if (p2.waitFor() == 0) {
                    browsers.add("firefox -remote openURL({0})");
                    browsers.add("firefox {0}");
                }
            }
            catch (IOException p2) {
            }
            catch (InterruptedException p2) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which mozilla");
                if (p2.waitFor() == 0) {
                    browsers.add("mozilla -remote openURL({0})");
                    browsers.add("mozilla {0}");
                }
            }
            catch (IOException p3) {
            }
            catch (InterruptedException p3) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which opera");
                if (p2.waitFor() == 0) {
                    browsers.add("opera -remote openURL({0})");
                    browsers.add("opera {0}");
                }
            }
            catch (IOException p4) {
            }
            catch (InterruptedException p4) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which galeon");
                if (p2.waitFor() == 0) {
                    browsers.add("galeon {0}");
                }
            }
            catch (IOException p5) {
            }
            catch (InterruptedException p5) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which konqueror");
                if (p2.waitFor() == 0) {
                    browsers.add("konqueror {0}");
                }
            }
            catch (IOException p6) {
            }
            catch (InterruptedException p6) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which netscape");
                if (p2.waitFor() == 0) {
                    browsers.add("netscape -remote openURL({0})");
                    browsers.add("netscape {0}");
                }
            }
            catch (IOException p7) {
            }
            catch (InterruptedException p7) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("which xterm");
                if (p2.waitFor() == 0 && (p2 = Runtime.getRuntime().exec("which lynx")).waitFor() == 0) {
                    browsers.add("xterm -e lynx {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            execLocal = browsers.size() == 0 ? null : browsers.toArray(new String[0]);
        }
        return execLocal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void displayURL(String url) throws IOException {
        if (exec == null || exec.length == 0) {
            if (!System.getProperty("os.name").startsWith("Mac")) throw new IOException("nocommand");
            boolean success = false;
            try {
                Class<?> nSWorkspace;
                if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                    URLClassLoader classLoader = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                    nSWorkspace = Class.forName("com.apple.cocoa.application.NSWorkspace", true, classLoader);
                } else {
                    nSWorkspace = Class.forName("com.apple.cocoa.application.NSWorkspace");
                }
                Method sharedWorkspace = nSWorkspace.getMethod("sharedWorkspace", new Class[0]);
                Object workspace = sharedWorkspace.invoke(null, new Object[0]);
                Method openURL = nSWorkspace.getMethod("openURL", Class.forName("java.net.URL"));
                success = (Boolean)openURL.invoke(workspace, new URL(url));
            }
            catch (Exception x) {
                success = false;
            }
            if (success) return;
            try {
                Class<?> mrjFileUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                Method openURL = mrjFileUtils.getMethod("openURL", Class.forName("java.lang.String"));
                openURL.invoke(null, url);
                return;
            }
            catch (Exception x) {
                System.err.println(x.getMessage());
                throw new IOException("failed");
            }
        }
        new URL(url);
        StringBuffer sb = new StringBuffer(url.length());
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == ':' || c == '&' || c == '@' || c == '/' || c == '?' || c == '%' || c == '+' || c == '=' || c == '#' || c == '-' || c == '\\') {
                sb.append(c);
                continue;
            }
            if ((c = (char)(c & 0xFF)) < '\u0010') {
                sb.append("%0" + Integer.toHexString(c));
                continue;
            }
            sb.append("%" + Integer.toHexString(c));
        }
        String[] messageArray = new String[]{sb.toString()};
        String command = null;
        boolean found = false;
        try {
            for (int i = 0; i < exec.length && !found; ++i) {
                try {
                    String t;
                    command = MessageFormat.format(exec[i], messageArray);
                    ArrayList<String> argumentList = new ArrayList<String>();
                    BrowserCommandLexer lex = new BrowserCommandLexer(new StringReader(command));
                    while ((t = lex.getNextToken()) != null) {
                        argumentList.add(t);
                    }
                    String[] args = new String[argumentList.size()];
                    args = argumentList.toArray(args);
                    boolean useShortCut = false;
                    if (args[0].equals("rundll32") && args[1].equals("url.dll,FileProtocolHandler")) {
                        if (args[2].startsWith("file:/")) {
                            if (args[2].charAt(6) != '/') {
                                args[2] = "file://" + args[2].substring(6);
                            }
                            if (args[2].charAt(7) != '/') {
                                args[2] = "file:///" + args[2].substring(7);
                            }
                            useShortCut = true;
                        } else if (args[2].toLowerCase().endsWith("html") || args[2].toLowerCase().endsWith("htm")) {
                            useShortCut = true;
                        }
                    }
                    if (useShortCut) {
                        File shortcut = File.createTempFile("OpenInBrowser", ".url");
                        shortcut = shortcut.getCanonicalFile();
                        shortcut.deleteOnExit();
                        PrintWriter out = new PrintWriter(new FileWriter(shortcut));
                        out.println("[InternetShortcut]");
                        out.println("URL=" + args[2]);
                        out.close();
                        args[2] = shortcut.getCanonicalPath();
                    }
                    Process p = Runtime.getRuntime().exec(args);
                    for (int j = 0; j < 2; ++j) {
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ix) {
                            throw new RuntimeException(ix);
                        }
                    }
                    if (p.exitValue() != 0) continue;
                    found = true;
                    continue;
                }
                catch (IOException x) {
                    System.err.println("warning " + x.getMessage());
                }
            }
            if (found) return;
            throw new IOException("failed");
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }
}

