/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.components.hyperlink;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.hyperlink.Browser;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JLabel;

public class HyperlinkLabel
extends JLabel {
    private URL url;
    private static MouseListener linker = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            HyperlinkLabel self = (HyperlinkLabel)e.getSource();
            if (self.url == null) {
                return;
            }
            try {
                Browser.getInstance().displayURL(self.url.toString());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }

        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        }
    };

    public HyperlinkLabel(String label) {
        super(label);
        this.setForeground(Color.BLUE);
        this.addMouseListener(linker);
    }

    public HyperlinkLabel(String label, String tip) {
        this(label);
        this.setToolTipText(tip);
    }

    public HyperlinkLabel(String label, URL url) {
        this(label);
        this.url = url;
    }

    public HyperlinkLabel(String label, String tip, URL url) {
        this(label, url);
        this.setToolTipText(tip);
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }
}

