/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.exception;

import com.eurodyn.eprocurement.tools.c4t.ApplicationSingleton;
import com.eurodyn.eprocurement.tools.c4t.preparation.exception.C4TExceptionCode;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TBody;

public class C4TException
extends Exception {
    C4TExceptionCode errorCode;

    public C4TException() {
        this.errorCode = C4TExceptionCode.C4TUnknown;
    }

    public C4TException(C4TExceptionCode err, Exception e) {
        super(e);
        this.errorCode = err;
    }

    public C4TException(C4TExceptionCode err) {
        this.errorCode = err;
    }

    public C4TException(String msgKey) {
        super(msgKey);
    }

    public String getError() {
        switch (this.errorCode) {
            case C4TXMLParsing: {
                return C4TApplicationResources.getLabel("c4t.exception.error.xmlparsing");
            }
            case C4TEncrypting: {
                return C4TApplicationResources.getLabel("c4t.exception.error.encrypting");
            }
            case C4TFileIO: {
                return C4TApplicationResources.getLabel("c4t.exception.error.file.IO");
            }
            case C4TPackageSize: {
                String size = C4TApplicationResources.PACK_PROPS.getProperty("max.allowed.tender.package.size");
                C4TBody body = ApplicationSingleton.getInstance().getBody();
                if (body.getTenderPackageMaxSize() != null && !"".equals(body.getTenderPackageMaxSize())) {
                    size = body.getTenderPackageMaxSize();
                }
                return C4TApplicationResources.getLabel("c4t.exception.error.package.size", new String[]{size});
            }
            case C4TNoError: {
                return C4TApplicationResources.getLabel("c4t.exception.error.no.error");
            }
            case C4TUnknown: {
                return C4TApplicationResources.getLabel("c4t.exception.error.unknown");
            }
        }
        return C4TApplicationResources.getLabel("c4t.exception.error");
    }

    public String getShortError() {
        switch (this.errorCode) {
            case C4TXMLParsing: {
                return C4TApplicationResources.getLabel("c4t.exception.error.short.xmlparsing");
            }
            case C4TEncrypting: {
                return C4TApplicationResources.getLabel("c4t.exception.error.short.encrypting");
            }
            case C4TFileIO: {
                return C4TApplicationResources.getLabel("c4t.exception.error.short.file.IO");
            }
            case C4TPackageSize: {
                return C4TApplicationResources.getLabel("c4t.exception.error.short.package.size");
            }
            case C4TNoError: {
                return C4TApplicationResources.getLabel("c4t.exception.error.short.no.error");
            }
            case C4TUnknown: {
                return C4TApplicationResources.getLabel("c4t.exception.error.short.unknown");
            }
        }
        return C4TApplicationResources.getLabel("c4t.exception.error");
    }

    public C4TExceptionCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(C4TExceptionCode errorCode) {
        this.errorCode = errorCode;
    }
}

