/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PanelUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.MultiItemReportTable;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.text.DoubleinputVerifier;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.tree.VetoableTreeSelectionModel;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreeSelectionModel;

public class MultiItemReport
extends JPanel {
    private static final long serialVersionUID = -3279420235867111065L;
    protected MultiItemReportTable m_table;
    protected NumberFormat m_moneyFormat = NumberFormat.getInstance();

    public MultiItemReport(JTree xmlTree, C4TTreeNode node) {
        this.setLayout(new BoxLayout(this, 1));
        final C4TEnvelope envelope = (C4TEnvelope)node.getUserObject();
        JPanel totalPanel = new JPanel();
        final JTextField txtFurtherDiscount = new JTextField(this.m_table.getFdrAllowed() != false ? envelope.getFurtherDiscountValue().toString() : "");
        BoxLayout boxLayoutTotal = new BoxLayout(totalPanel, 1);
        totalPanel.setLayout(boxLayoutTotal);
        this.m_moneyFormat.setMaximumFractionDigits(2);
        this.m_moneyFormat.setGroupingUsed(true);
        this.m_table = new MultiItemReportTable(envelope, xmlTree, node, this.m_moneyFormat, totalPanel, txtFurtherDiscount);
        JPanel headerPanel = new JPanel();
        BoxLayout boxLayout2 = new BoxLayout(headerPanel, 0);
        headerPanel.setLayout(boxLayout2);
        JLabel lblFdr = new JLabel(C4TXStreamUtil.convertStringToUTF(envelope.getLabel()));
        lblFdr.setFont(PanelUtils.fontSansSerifBig);
        headerPanel.add((Component)lblFdr, Float.valueOf(0.0f));
        headerPanel.add(Box.createHorizontalGlue());
        if (!this.m_table.getFdrAllowed().booleanValue()) {
            txtFurtherDiscount.setEnabled(false);
            txtFurtherDiscount.setBackground(Color.LIGHT_GRAY);
        }
        txtFurtherDiscount.setInputVerifier(new DoubleinputVerifier());
        ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MultiItemReport.this.changePresentDiscountValua(envelope, txtFurtherDiscount);
            }
        };
        if (this.m_table.getFdrAllowed().booleanValue()) {
            txtFurtherDiscount.addActionListener(action);
            VetoableChangeListener vcl = new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
                    String text = txtFurtherDiscount.getText();
                    Double fdr = 0.0;
                    if (text != null && !text.trim().equals("")) {
                        try {
                            fdr = Double.parseDouble(text);
                        }
                        catch (NumberFormatException e) {
                            throw new PropertyVetoException("SSSSSstring", arg0);
                        }
                        if (fdr < 0.0 || fdr > 100.0) {
                            throw new PropertyVetoException("Number out of range", arg0);
                        }
                    } else {
                        txtFurtherDiscount.setText("0.00");
                    }
                    envelope.getFurtherDiscountValue().setValue(fdr);
                }
            };
            TreeSelectionModel o = xmlTree.getSelectionModel();
            VetoableTreeSelectionModel vetomodel = (VetoableTreeSelectionModel)o;
            vetomodel.addSeletionChangedVetoListener(vcl);
        }
        txtFurtherDiscount.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                MultiItemReport.this.changePresentDiscountValua(envelope, txtFurtherDiscount);
            }
        });
        txtFurtherDiscount.setMaximumSize(new Dimension(60, 20));
        txtFurtherDiscount.setPreferredSize(new Dimension(60, 20));
        JLabel lblFurtherDiscount = new JLabel(C4TApplicationResources.getLabel("label.fo.further.discount.rate"));
        JLabel percentage = new JLabel("%");
        headerPanel.add((Component)lblFurtherDiscount, Float.valueOf(1.0f));
        headerPanel.add((Component)txtFurtherDiscount, Float.valueOf(1.0f));
        headerPanel.add((Component)percentage, Float.valueOf(1.0f));
        this.add(headerPanel);
        this.add(this.m_table.getTableHeader());
        this.add(this.m_table);
        this.add(totalPanel);
    }

    private void changePresentDiscountValua(C4TEnvelope envelope, JTextField txtFurtherDiscount) {
        block5: {
            String text = txtFurtherDiscount.getText();
            if (text != null && !text.trim().equals("")) {
                try {
                    Double fdr = Double.parseDouble(text);
                    if (fdr < 0.0 || fdr > 100.0) {
                        txtFurtherDiscount.transferFocus();
                        break block5;
                    }
                    this.m_table.setFurtherDiscountValue(fdr);
                    envelope.getFurtherDiscountValue().setValue(fdr);
                    this.m_table.fillTotalPanel();
                }
                catch (NumberFormatException ex) {
                    System.out.println("NOT A DOUBLE " + text + " IN FDR ACTION PERFORMED");
                }
            } else {
                txtFurtherDiscount.setText("0.00");
                Double fdr = 0.0;
                this.m_table.setFurtherDiscountValue(fdr);
                envelope.getFurtherDiscountValue().setValue(fdr);
                this.m_table.fillTotalPanel();
            }
        }
    }
}

