/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem;

import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.MultiItemColumnData;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.MultiItemData;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TPositiveDouble;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.C4TSectionComponent;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiItemReportData
extends AbstractTableModel {
    private static final long serialVersionUID = -4067232391046962639L;
    public static final MultiItemColumnData[] m_columns = new MultiItemColumnData[]{new MultiItemColumnData(C4TApplicationResources.getLabel("label.fo.id"), 100, 0), new MultiItemColumnData(C4TApplicationResources.getLabel("label.fo.code"), 40, 0), new MultiItemColumnData(C4TApplicationResources.getLabel("label.fo.description"), 130, 2), new MultiItemColumnData(C4TApplicationResources.getLabel("label.fo.quantity"), 55, 0), new MultiItemColumnData(C4TApplicationResources.getLabel("label.fo.meas.unit"), 65, 0), new MultiItemColumnData(C4TApplicationResources.getLabel("label.fo.unit.price"), 60, 0), new MultiItemColumnData(C4TApplicationResources.getLabel("label.fo.total"), 50, 0), new MultiItemColumnData(C4TApplicationResources.getLabel("label.fo.value.discounted"), 50, 0), new MultiItemColumnData(C4TApplicationResources.getLabel("label.fo.comment"), 300, 2), new MultiItemColumnData(C4TApplicationResources.getLabel("label.relevant.document"), 50, 2), new MultiItemColumnData("", 150, 2)};
    private Vector<MultiItemData> m_vector = new Vector();
    private Vector<C4TCriterion> root_vector;
    private Boolean fdrAllowed;
    private Double furtherDiscountValue;

    public static final MultiItemColumnData[] getColumns() {
        m_columns[0].setLabel(C4TApplicationResources.getLabel("label.fo.id"));
        m_columns[1].setLabel(C4TApplicationResources.getLabel("label.fo.code"));
        m_columns[2].setLabel(C4TApplicationResources.getLabel("label.fo.description"));
        m_columns[3].setLabel(C4TApplicationResources.getLabel("label.fo.quantity"));
        m_columns[4].setLabel(C4TApplicationResources.getLabel("label.fo.meas.unit"));
        m_columns[5].setLabel(C4TApplicationResources.getLabel("label.fo.unit.price"));
        m_columns[6].setLabel(C4TApplicationResources.getLabel("label.fo.total"));
        m_columns[7].setLabel(C4TApplicationResources.getLabel("label.fo.value.discounted"));
        m_columns[8].setLabel(C4TApplicationResources.getLabel("label.fo.comment"));
        m_columns[9].setLabel(C4TApplicationResources.getLabel("label.relevant.document"));
        m_columns[10].setLabel("");
        return m_columns;
    }

    @Override
    public Object getValueAt(int nRow, int nCol) {
        if (nRow < 0 || nRow >= this.getRowCount()) {
            return "";
        }
        MultiItemData row = this.m_vector.elementAt(nRow);
        C4TCriterion criterion = this.root_vector.elementAt(nRow);
        switch (nCol) {
            case 0: {
                return row.getId();
            }
            case 1: {
                return row.getCode();
            }
            case 2: {
                return row.getDescription();
            }
            case 3: {
                return row.getQuantity();
            }
            case 4: {
                return row.getUnit();
            }
            case 5: {
                if (row.getUnitPrice() != null) {
                    return row.getUnitPrice();
                }
                return null;
            }
            case 6: {
                return row.getTotal();
            }
            case 7: {
                return this.calculateFDR(row);
            }
            case 8: {
                return row.getComment();
            }
            case 9: {
                return criterion.getRelevantDoc();
            }
            case 10: {
                return criterion;
            }
        }
        return "";
    }

    public MultiItemReportData(C4TEnvelope source) {
        this.setRootVector(source.getNodes());
        this.setDefaultData(source);
        this.fdrAllowed = source.getFdrAllowed() != null ? source.getFdrAllowed() : Boolean.FALSE;
        if (this.fdrAllowed.booleanValue()) {
            if (source.getFurtherDiscountValue() != null) {
                this.furtherDiscountValue = source.getFurtherDiscountValue().getValue() / 100.0;
            } else {
                this.furtherDiscountValue = 0.0;
                source.setFurtherDiscountValue(new C4TPositiveDouble());
            }
        } else {
            this.furtherDiscountValue = 0.0;
        }
    }

    private Double calculateFDR(MultiItemData row) {
        if (this.fdrAllowed.booleanValue()) {
            return row.getTotal() - row.getTotal() * this.furtherDiscountValue;
        }
        return row.getTotal();
    }

    private void setRootVector(List<C4TSectionComponent> nodes) {
        this.root_vector = new Vector();
        for (C4TSectionComponent component : nodes) {
            C4TCriterion criterion = (C4TCriterion)component;
            this.root_vector.add(criterion);
        }
    }

    private void setDefaultData(C4TEnvelope source) {
        this.m_vector = new Vector();
        for (C4TSectionComponent comp : source.getNodes()) {
            switch (comp.getJType()) {
                case C4TCriterion: {
                    C4TCriterion criterion = (C4TCriterion)comp;
                    this.m_vector.add(new MultiItemData(criterion));
                    break;
                }
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.m_vector == null ? 0 : this.m_vector.size();
    }

    @Override
    public int getColumnCount() {
        return m_columns.length;
    }

    @Override
    public String getColumnName(int nCol) {
        return MultiItemReportData.m_columns[nCol].m_tolatLbl;
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        return nCol == 5 || nCol == 8 || nCol == 10;
    }

    @Override
    public void setValueAt(Object value, int nRow, int nCol) {
        if (nRow < 0 || nRow >= this.getRowCount() || value == null) {
            return;
        }
        MultiItemData row = this.m_vector.elementAt(nRow);
        String svalue = value.toString();
        if (nCol == 5) {
            Double longValue = new Double(svalue);
            row.setUnitPrice(longValue);
            row.setTotal(longValue * row.getQuantity());
            this.fireTableRowsUpdated(nRow, nRow);
            this.updateInRootVector(nRow, longValue);
        }
        if (nCol == 8) {
            row.setComment(svalue);
            this.updateCommentInRootVector(nRow, svalue);
        }
    }

    private void updateInRootVector(int nRow, Double unit_price) {
        this.root_vector.get(nRow).setUnit_price(unit_price);
    }

    private void updateCommentInRootVector(int nRow, String comment) {
        this.root_vector.get(nRow).setComment(comment);
    }

    public void updateFDR(Double valueFDR) {
        this.furtherDiscountValue = valueFDR;
    }

    public Double getTotal() {
        Double total = 0.0;
        for (C4TCriterion row : this.root_vector) {
            total = total + row.getQuantity() * row.getUnit_price();
        }
        return total;
    }

    public Double getTotalDiscounted() {
        Double totalDiscounted = 0.0;
        for (C4TCriterion row : this.root_vector) {
            totalDiscounted = totalDiscounted + this.calculateFDR(new MultiItemData(row));
        }
        return totalDiscounted;
    }

    public Double getTotalDiscount() {
        return this.getTotal() - this.getTotalDiscounted();
    }

    public Boolean getFdrAllowed() {
        return this.fdrAllowed;
    }

    public void setFdrAllowed(Boolean fdrAllowed) {
        this.fdrAllowed = fdrAllowed;
    }

    public Double getFurtherDiscountValue() {
        return this.furtherDiscountValue;
    }

    public void setFurtherDiscountValue(Double furtherDiscountValue) {
        this.furtherDiscountValue = furtherDiscountValue / 100.0;
    }

    public Boolean isRowValid(int row) {
        if (this.m_vector.get(row).getMandatory() == 1) {
            if (this.m_vector.get(row).getUnitPrice() > 0.0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

