/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PanelUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.ColoredTableCellRenderer;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.FormattedCellRenderer;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.MultiItemReportData;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.TextAreaCellEditor;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.TextAreaCellRenderer;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.table.FOTableFileCellRenderer;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.table.FileCellEditor;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.table.IntegerEditor;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class MultiItemReportTable
extends JTable {
    private static final long serialVersionUID = 3848519133355262330L;
    JTree xmlTree;
    C4TTreeNode node;
    NumberFormat m_moneyFormat;
    JPanel totalPanel;

    public MultiItemReportTable(C4TEnvelope envelope, JTree xmlTree, C4TTreeNode node, NumberFormat m_moneyFormat, JPanel totalPanel, JTextField txtFurtherDiscount) {
        this.totalPanel = totalPanel;
        this.xmlTree = xmlTree;
        this.node = node;
        this.m_moneyFormat = m_moneyFormat;
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(new MultiItemReportData(envelope));
        this.setSelectionMode(0);
        for (int k = 0; k < this.getModel().getColumnCount(); ++k) {
            TableCellRenderer renderer = null;
            AbstractCellEditor editor = null;
            if (k == 5) {
                renderer = new FormattedCellRenderer(xmlTree, node, "%,.2f", PanelUtils.editableCellBackground, 4);
                editor = new IntegerEditor(txtFurtherDiscount, xmlTree, node);
            }
            if (k == 6) {
                renderer = new ColoredTableCellRenderer(PanelUtils.totalCellBackground, "%,.2f", 4);
            }
            if (k == 7) {
                renderer = new ColoredTableCellRenderer(PanelUtils.totalCellBackground, "%,.2f", 4);
            }
            if (k == 8) {
                renderer = new TextAreaCellRenderer(PanelUtils.editableCellBackground);
                editor = new TextAreaCellEditor();
            }
            if (k == 10) {
                renderer = new FOTableFileCellRenderer();
                editor = new FileCellEditor(xmlTree, node);
            }
            if (k != 5 && k != 6 && k != 7 && k != 8 && k != 10) {
                renderer = new ColoredTableCellRenderer(PanelUtils.noneditableCellBackground);
            }
            TableColumn column = new TableColumn(k, MultiItemReportData.getColumns()[k].m_width, renderer, (TableCellEditor)((Object)editor));
            this.addColumn(column);
        }
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
        header.setUpdateTableInRealTime(false);
        this.fillTotalPanel();
    }

    public Component prepareRenderer(TableCellRenderer tcr, int row, int column) {
        Component c = super.prepareRenderer(tcr, row, column);
        c.setForeground(Color.BLACK);
        if (column == 5) {
            c.setBackground(PanelUtils.editableCellBackground);
        }
        if (column == 6) {
            c.setBackground(PanelUtils.totalCellBackground);
            c.setFont(PanelUtils.cellFont);
        }
        if (column == 7) {
            c.setBackground(PanelUtils.totalCellBackground);
            c.setFont(PanelUtils.cellFont);
        }
        if (column == 8) {
            c.setBackground(PanelUtils.editableCellBackground);
        }
        if (column == 10) {
            c.setBackground(UIManager.getColor("Button.background"));
        }
        if (column != 5 && column != 6 && column != 7 && column != 8 && column != 10) {
            c.setBackground(PanelUtils.noneditableCellBackground);
        }
        if (!this.isRowValid(row).booleanValue() && column != 5 && column != 8 && column != 10) {
            c.setBackground(PanelUtils.mandatoryCellBackground);
            c.setForeground(PanelUtils.mandatoryCellForeground);
        }
        return c;
    }

    public void editingStopped(ChangeEvent e) {
        super.editingStopped(e);
        this.fillTotalPanel();
    }

    public Boolean getFdrAllowed() {
        return ((MultiItemReportData)this.getModel()).getFdrAllowed();
    }

    public void setFurtherDiscountValue(Double furtherDiscountValue) {
        ((MultiItemReportData)this.getModel()).setFurtherDiscountValue(furtherDiscountValue);
        this.updateUI();
    }

    protected Double getTotal() {
        return ((MultiItemReportData)this.getModel()).getTotal();
    }

    protected Double getTotalDiscounted() {
        return ((MultiItemReportData)this.getModel()).getTotalDiscounted();
    }

    protected Double getTotalDiscount() {
        return ((MultiItemReportData)this.getModel()).getTotalDiscount();
    }

    public void fillTotalPanel() {
        if (this.totalPanel != null) {
            this.totalPanel.removeAll();
            this.totalPanel.add(Box.createVerticalStrut(40));
            JPanel panelTotal = new JPanel();
            BoxLayout boxLayoutTotal = new BoxLayout(panelTotal, 0);
            panelTotal.setLayout(boxLayoutTotal);
            JLabel labelTotal = new JLabel(C4TApplicationResources.getLabel("label.fo.total") + " = " + String.format("%,.2f", this.getTotal()));
            labelTotal.setFont(PanelUtils.fontSansSerifBig);
            panelTotal.add(labelTotal);
            panelTotal.add(Box.createHorizontalGlue());
            this.totalPanel.add(panelTotal);
            if (this.getFdrAllowed().booleanValue()) {
                JPanel panelDiscount = new JPanel();
                BoxLayout boxLayoutDiscount = new BoxLayout(panelDiscount, 0);
                panelDiscount.setLayout(boxLayoutDiscount);
                JLabel labelDiscount = new JLabel(C4TApplicationResources.getLabel("label.fo.total.discount") + " = " + String.format("%,.2f", this.getTotalDiscount()));
                labelDiscount.setFont(PanelUtils.fontSansSerifBig);
                panelDiscount.add(labelDiscount);
                panelDiscount.add(Box.createHorizontalGlue());
                this.totalPanel.add(panelDiscount);
                JPanel panelDiscounted = new JPanel();
                BoxLayout boxLayoutDiscounted = new BoxLayout(panelDiscounted, 0);
                panelDiscounted.setLayout(boxLayoutDiscounted);
                JLabel labelDiscounted = new JLabel(C4TApplicationResources.getLabel("label.fo.total.discounted") + " = " + String.format("%,.2f", this.getTotalDiscounted()));
                labelDiscounted.setFont(PanelUtils.fontSansSerifBig);
                panelDiscounted.add(labelDiscounted);
                panelDiscounted.add(Box.createHorizontalGlue());
                this.totalPanel.add(panelDiscounted);
            }
            this.totalPanel.add(Box.createHorizontalGlue());
            this.totalPanel.updateUI();
        }
    }

    private Boolean isRowValid(int row) {
        return ((MultiItemReportData)this.getModel()).isRowValid(row);
    }
}

