/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.table;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PanelUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.multiitem.TextAreaCellRenderer;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.table.FOTableCellRenderer;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.table.FOTableFileCellRenderer;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.table.FileCellEditor;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.table.IntegerEditor;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TPrice;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.C4TSectionComponent;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FOJTable
extends JTable {
    private static final long serialVersionUID = -9108206364136228389L;
    private final ArrayList<C4TCriterion> criterions = new ArrayList();

    public FOJTable(TableModel dm, JTree tree, C4TTreeNode node, C4TEnvelope financial, JTextField txtFurtherDiscount) {
        this.setAutoResizeMode(0);
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(dm);
        for (C4TSectionComponent comp : financial.getNodes()) {
            switch (comp.getJType()) {
                case C4TCriterion: {
                    C4TCriterion criterion = (C4TCriterion)comp;
                    this.criterions.add(criterion);
                    break;
                }
            }
        }
        this.setShowGrid(false);
        for (int k = 0; k < this.getModel().getColumnCount(); ++k) {
            TableCellRenderer renderer = null;
            int colunWidth = 100;
            AbstractCellEditor editor = null;
            if (k == 0) {
                renderer = new TextAreaCellRenderer(PanelUtils.noneditableCellBackground);
            }
            if (k == 1) {
                editor = new IntegerEditor(txtFurtherDiscount, tree, node);
                renderer = new FOTableCellRenderer(tree, node);
            }
            if (k == 2) {
                renderer = new DefaultTableCellRenderer();
            }
            if (k == 3) {
                renderer = new DefaultTableCellRenderer();
            }
            if (k == 4) {
                renderer = new DefaultTableCellRenderer();
            }
            if (k == 5) {
                renderer = new FOTableFileCellRenderer();
                editor = new FileCellEditor(tree, node);
                colunWidth = 200;
            }
            TableColumn column = new TableColumn(k, colunWidth, renderer, (TableCellEditor)((Object)editor));
            this.addColumn(column);
        }
        this.getTableHeader().setReorderingAllowed(false);
    }

    public Component prepareRenderer(TableCellRenderer tcr, int row, int column) {
        Component c = super.prepareRenderer(tcr, row, column);
        c.setForeground(Color.BLACK);
        if (column != 1 && column != 5) {
            c.setBackground(PanelUtils.noneditableCellBackground);
        } else if (column == 5) {
            c.setBackground(UIManager.getColor("Button.background"));
        } else {
            c.setBackground(PanelUtils.editableCellBackground);
        }
        if (row == this.getRowCount() - 1) {
            c.setFont(PanelUtils.cellFont);
            c.setBackground(PanelUtils.totalCellBackground);
            return c;
        }
        c.setFont(this.getFont());
        if (!this.isRowValid(row).booleanValue() && column != 1 && column != 5) {
            c.setBackground(PanelUtils.mandatoryCellBackground);
            c.setForeground(PanelUtils.mandatoryCellForeground);
        }
        return c;
    }

    public Boolean isRowValid(int row) {
        C4TCriterion criterion = this.criterions.get(row);
        if (criterion.getMandatory() == 1) {
            boolean isCompletedCriterion = false;
            for (C4TPrice price : criterion.getPrices()) {
                if (!(price.getValue().getValue() > 0.0)) continue;
                isCompletedCriterion = true;
            }
            if (!isCompletedCriterion) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getPreferredSize().width < this.getParent().getWidth();
    }
}

