/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.table;

import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TPrice;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TPositiveDouble;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -16613861665240535L;
    private String[] columnNames;
    private Object[][] data;
    private Vector<Vector<C4TPrice>> dataValues;
    private Double discount;
    private Boolean fdrAllowed;
    private Double furtherDiscountValue;
    private Integer yearPosition;

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == this.data.length) {
            if (col == 0) {
                return C4TApplicationResources.getLabel("label.totals");
            }
            if (col == 1) {
                double summ = 0.0;
                for (int i = 0; i < this.data.length; ++i) {
                    C4TPrice price = (C4TPrice)this.data[i][1];
                    summ += price.getValue().getValue().doubleValue();
                }
                C4TPrice returnPrice = new C4TPrice();
                C4TPositiveDouble summPositiveDouble = new C4TPositiveDouble();
                summPositiveDouble.setValue(summ);
                returnPrice.setValue(summPositiveDouble);
                return returnPrice;
            }
            if (col == 2) {
                double summValue = 0.0;
                for (int i = 0; i < this.data.length; ++i) {
                    C4TPrice price = (C4TPrice)this.data[i][1];
                    summValue += price.getValue().getValue() / Math.pow(1.0 + this.discount, this.yearPosition.doubleValue());
                }
                return String.format("%,.2f", summValue);
            }
            if (col == 3) {
                double summFdrValue = 0.0;
                for (int i = 0; i < this.data.length; ++i) {
                    C4TPrice price = (C4TPrice)this.data[i][1];
                    double presentValue = price.getValue().getValue() / Math.pow(1.0 + this.discount, this.yearPosition.doubleValue());
                    summFdrValue += presentValue * (1.0 - this.furtherDiscountValue);
                }
                return String.format("%,.2f", summFdrValue);
            }
            if (col == 4) {
                return "";
            }
            if (col == 5) {
                return "";
            }
            return "";
        }
        if (col == 4) {
            C4TCriterion theCriterion = (C4TCriterion)this.data[row][5];
            return theCriterion.getRelevantDoc();
        }
        return this.data[row][col];
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row == this.data.length) {
            return false;
        }
        return col == 1 || col == 5;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row < this.data.length) {
            if (col == 4 || col == 5) {
                this.data[row][col] = value;
            } else {
                C4TPrice crValue = (C4TPrice)this.getValueAt(row, col);
                if (value != null) {
                    crValue.setValue(value.toString());
                    this.data[row][col] = crValue;
                    if (col == 1 && crValue.getValue() != null && crValue.getValue().getValue() != null) {
                        Double presentValueD = crValue.getValue().getValue() / Math.pow(1.0 + this.discount, this.yearPosition.doubleValue());
                        this.data[row][2] = String.format("%,.2f", presentValueD);
                        this.data[row][3] = String.format("%,.2f", presentValueD * (1.0 - this.furtherDiscountValue));
                    }
                } else {
                    crValue.setValue("");
                    this.data[row][2] = "";
                    this.data[row][3] = "";
                }
                if (col == 1) {
                    this.fireTableRowsUpdated(row, row);
                    this.fireTableCellUpdated(this.data.length, 1);
                }
            }
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public Object[][] getData() {
        return this.data;
    }

    public void setData(Object[][] data) {
        this.data = data;
    }

    public Vector<Vector<C4TPrice>> getDataValues() {
        return this.dataValues;
    }

    public void setDataValues(Vector<Vector<C4TPrice>> dataValues) {
        this.dataValues = dataValues;
    }

    public Double getDiscount() {
        return this.discount;
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
    }

    public Integer getYearPosition() {
        return this.yearPosition;
    }

    public void setYearPosition(Integer yearPosition) {
        this.yearPosition = yearPosition;
    }

    public void recalculateAll() {
        for (int i = 0; i < this.data.length; ++i) {
            C4TPrice crValue = (C4TPrice)this.getValueAt(i, 1);
            Double currentValueDouble = crValue.getValue().getValue();
            Double presentValueD = currentValueDouble / Math.pow(1.0 + this.discount, this.yearPosition.doubleValue());
            this.data[i][2] = String.format("%,.2f", presentValueD);
            Double fdrVal = 0.0;
            if (this.getFdrAllowed().booleanValue()) {
                fdrVal = this.getFurtherDiscountValue();
            }
            this.data[i][3] = String.format("%,.2f", presentValueD * (1.0 - fdrVal));
        }
        this.fireTableDataChanged();
    }

    public Boolean getFdrAllowed() {
        return this.fdrAllowed;
    }

    public void setFdrAllowed(Boolean fdrAllowed) {
        this.fdrAllowed = fdrAllowed;
    }

    public Double getFurtherDiscountValue() {
        return this.furtherDiscountValue;
    }

    public void setFurtherDiscountValue(Double furtherDiscountValue) {
        this.furtherDiscountValue = furtherDiscountValue;
    }
}

