/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.table;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.PanelUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.AttachmentFileView;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEventsProducer;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SimpleFilter;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.TreeNodesUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.FileUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.JFileChooserUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class FileCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    C4TCriterion criterion;
    JButton theButton = new JButton();
    JButton theButton1;
    Box horizontalBox;
    JTable myTable;
    private C4TTreeNode node;
    private JTree xmlTree;
    protected static final String ATTACH = "attach";
    protected static final String SEE = "see";

    public FileCellEditor(JTree xmlTree, C4TTreeNode node) {
        this.theButton.setOpaque(true);
        this.theButton.setActionCommand(ATTACH);
        this.theButton.addActionListener(this);
        this.theButton.setBorderPainted(false);
        this.theButton.setPreferredSize(new Dimension(100, 40));
        this.theButton1 = new JButton();
        this.theButton1.setText(C4TApplicationResources.getLabel("label.criterion.button.file.see"));
        this.theButton1.setOpaque(true);
        this.theButton1.setActionCommand(SEE);
        this.theButton1.addActionListener(this);
        this.theButton1.setBorderPainted(false);
        this.theButton1.setPreferredSize(new Dimension(100, 40));
        this.node = node;
        this.xmlTree = xmlTree;
    }

    public void actionPerformed(ActionEvent e) {
        if (ATTACH.equals(e.getActionCommand())) {
            this.theButton.setEnabled(false);
            String oldFile = this.criterion.getRelevantDoc();
            String newFName = "";
            String relativeFilePath = "";
            if (oldFile != null && oldFile.length() > 0) {
                try {
                    relativeFilePath = FileUtils.makeRelativePath(this.criterion);
                    FileUtils.copyAttachedFile(relativeFilePath, oldFile);
                    FileUtils.deleteAttachedFile(relativeFilePath, oldFile);
                    this.theButton.setText(C4TApplicationResources.getLabel("label.criterion.button.file.attach"));
                    SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
                    this.theButton.setEnabled(true);
                    this.criterion.setRelevantDoc("");
                    this.horizontalBox.remove(PanelUtils.getComponentIndex(this.theButton) + 1);
                    this.horizontalBox.remove(this.theButton1);
                    TreeNodesUtil.refreshSelectedPathForFinancial(this.node);
                    SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.FOTABLE);
                    this.xmlTree.updateUI();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.horizontalBox, C4TApplicationResources.getLabel("label.file.copying.failed.message"), C4TApplicationResources.getLabel("label.file.copying.failed.title"), 0);
                }
            } else {
                File archiveFile = this.createArchive();
                try {
                    if (archiveFile != null) {
                        relativeFilePath = FileUtils.makeRelativePath(this.criterion);
                        newFName = FileUtils.copyAttachedFile(relativeFilePath, archiveFile, oldFile, this.criterion);
                        this.criterion.setFileSize(archiveFile.length());
                        this.theButton.setText(C4TApplicationResources.getLabel("label.criterion.button.file.remove"));
                        SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
                        this.horizontalBox.remove(PanelUtils.getComponentIndex(this.theButton) + 1);
                        this.horizontalBox.add(Box.createRigidArea(new Dimension(5, 0)));
                        this.horizontalBox.add(this.theButton1);
                        this.horizontalBox.add(Box.createGlue());
                        this.criterion.setRelevantDoc(relativeFilePath + newFName);
                        TreeNodesUtil.refreshSelectedPathForFinancial(this.node);
                        SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.FOTABLE);
                        this.xmlTree.updateUI();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.horizontalBox, C4TApplicationResources.getLabel("label.file.copying.failed.message"), C4TApplicationResources.getLabel("label.file.copying.failed.title"), 0);
                }
                this.theButton.setEnabled(true);
            }
            if (this.myTable != null) {
                this.myTable.repaint();
            }
        } else if (SEE.equals(e.getActionCommand())) {
            JFileChooser attachmentChooser = JFileChooserUtils.createJFileChooser();
            String absoluteAttachmentPath = FileUtils.makeAbsoluteAttachmentPath(this.criterion);
            attachmentChooser.setSelectedFile(new File(absoluteAttachmentPath));
            attachmentChooser.setDialogType(0);
            if (attachmentChooser.showDialog(this.theButton.getParent(), null) != 0) {
                return;
            }
            try {
                Desktop.getDesktop().open(attachmentChooser.getSelectedFile());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.horizontalBox, C4TApplicationResources.getLabel("label.file.opening.failed.message"), C4TApplicationResources.getLabel("label.file.opening.failed.title"), 0);
            }
        }
    }

    public Object getCellEditorValue() {
        SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
        return this.criterion;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.myTable = table;
        this.criterion = (C4TCriterion)value;
        String relDoc = this.criterion.getRelevantDoc();
        if (relDoc != null && !relDoc.trim().equals("")) {
            this.theButton.setText(C4TApplicationResources.getLabel("label.criterion.button.file.remove"));
        } else {
            this.theButton.setText(C4TApplicationResources.getLabel("label.criterion.button.file.attach"));
        }
        ((AbstractTableModel)table.getModel()).fireTableRowsUpdated(row, row);
        this.horizontalBox = Box.createHorizontalBox();
        this.horizontalBox.add(Box.createGlue());
        Integer mandAttachment = ((C4TCriterion)value).getMandatorytAttachment();
        if (mandAttachment != null && mandAttachment == 1) {
            this.horizontalBox.add(new JLabel("*"));
        }
        this.horizontalBox.add(this.theButton);
        if (relDoc != null && !relDoc.trim().equals("")) {
            this.horizontalBox.add(Box.createRigidArea(new Dimension(5, 0)));
            this.horizontalBox.add(this.theButton1);
        }
        this.horizontalBox.add(Box.createGlue());
        return this.horizontalBox;
    }

    private File createArchive() {
        JFileChooser attachmentChooser = JFileChooserUtils.createJFileChooser();
        SimpleFilter m_txtFilter = new SimpleFilter("txt", "TXT Files");
        SimpleFilter m_pdfFilter = new SimpleFilter("pdf", "PDF Files");
        SimpleFilter m_xlsFilter = new SimpleFilter("xls", "XLS Files");
        SimpleFilter m_docFilter = new SimpleFilter("doc", "DOC Files");
        SimpleFilter m_allFilter = new SimpleFilter("", "All (*.*)");
        attachmentChooser.addChoosableFileFilter(m_txtFilter);
        attachmentChooser.addChoosableFileFilter(m_pdfFilter);
        attachmentChooser.addChoosableFileFilter(m_xlsFilter);
        attachmentChooser.addChoosableFileFilter(m_docFilter);
        attachmentChooser.addChoosableFileFilter(m_allFilter);
        AttachmentFileView m_view = new AttachmentFileView();
        attachmentChooser.setFileView(m_view);
        attachmentChooser.setMultiSelectionEnabled(false);
        attachmentChooser.setFileFilter(m_allFilter);
        FileFilter ft = attachmentChooser.getAcceptAllFileFilter();
        attachmentChooser.removeChoosableFileFilter(ft);
        File m_currentDir = null;
        try {
            m_currentDir = new File(".").getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        attachmentChooser.setCurrentDirectory(m_currentDir);
        attachmentChooser.setDialogType(0);
        attachmentChooser.setDialogTitle(C4TApplicationResources.getLabel("label.criterion.button.file.attach"));
        if (attachmentChooser.showDialog(null, C4TApplicationResources.getLabel("label.criterion.button.file.attach")) != 0) {
            return null;
        }
        m_currentDir = attachmentChooser.getCurrentDirectory();
        File archiveFile = attachmentChooser.getSelectedFile();
        return archiveFile;
    }
}

