/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.table;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEvent;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEventsListener;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEventsProducer;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.TreeNodesUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.tree.VetoableTreeSelectionModel;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TPrice;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatter;

public class IntegerEditor
extends DefaultCellEditor {
    JFormattedTextField ftf;
    int minimum;
    int maximum;
    JTextField txtFurtherDiscount;
    NumberFormat currFormat = new DecimalFormat("####0.###");

    public IntegerEditor(JTextField txtFurtherDiscount, final JTree xmlTree, final C4TTreeNode node) {
        super(new JFormattedTextField(new DefaultFormatter(){

            public String valueToString(Object o) throws ParseException {
                return super.valueToString(o);
            }

            public Object stringToValue(String s) throws ParseException {
                try {
                    Double.parseDouble(s);
                    return super.stringToValue(s);
                }
                catch (NumberFormatException nex) {
                    JFormattedTextField field = super.getFormattedTextField();
                    return field.getValue();
                }
            }
        }));
        this.txtFurtherDiscount = txtFurtherDiscount;
        this.ftf = (JFormattedTextField)this.getComponent();
        this.ftf.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                if (!IntegerEditor.this.isEditValid()) {
                    if (IntegerEditor.this.userSaysRevert()) {
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                    return false;
                }
                try {
                    IntegerEditor.this.ftf.commitEdit();
                    IntegerEditor.this.ftf.postActionEvent();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return true;
            }

            public boolean shouldYieldFocus(JComponent input) {
                return this.verify(input);
            }
        });
        VetoableChangeListener vcl = IntegerEditor.getNumericVetoableChangeListener(this.ftf, xmlTree);
        VetoableTreeSelectionModel model = (VetoableTreeSelectionModel)xmlTree.getSelectionModel();
        model.addSeletionChangedVetoListener(vcl);
        DefaultFormatter formatter = (DefaultFormatter)this.ftf.getFormatter();
        formatter.setOverwriteMode(false);
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFocusLostBehavior(3);
        this.ftf.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (IntegerEditor.this.isEditValid()) {
                    TreeNodesUtil.refreshSelectedPathForFinancial(node);
                    SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.FOTABLE);
                    xmlTree.updateUI();
                }
            }

            public void focusGained(FocusEvent e) {
                IntegerEditor.this.ftf.setText((String)IntegerEditor.this.ftf.getValue());
                IntegerEditor.this.ftf.selectAll();
            }
        });
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.ftf.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String val = IntegerEditor.this.ftf.getText();
                if (!IntegerEditor.this.isEditValid()) {
                    if (IntegerEditor.this.userSaysRevert()) {
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                } else {
                    try {
                        IntegerEditor.this.ftf.commitEdit();
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
        SectionStatisticsEventsListener listener = new SectionStatisticsEventsListener(){

            public void sectionStatisticsEventsOccurred(SectionStatisticsEvent evt) {
                if (evt.getCodeType() != null && evt.getCodeType() == SectionStatisticsEventsProducer.EventType.FINVALUE) {
                    try {
                        IntegerEditor.this.ftf.commitEdit();
                        IntegerEditor.this.ftf.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        };
        SectionStatisticsEventsProducer.getInstance().addSectionStatisticsEventListener(listener);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (value instanceof C4TPrice) {
            C4TPrice crValue = (C4TPrice)value;
            Double currentValueDouble = 0.0;
            if (crValue != null && crValue.getValue() != null && !crValue.getValue().equals("")) {
                currentValueDouble = crValue.getValue().getValue();
            }
            ftf.setValue(String.format("%.2f", currentValueDouble));
        } else {
            ftf.setValue(value);
        }
        return ftf;
    }

    public Object getCellEditorValue() {
        SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTCHANGE);
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof C4TPrice) {
            return o;
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof Double || o instanceof Integer) {
            return o.toString();
        }
        return null;
    }

    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (this.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else if (!this.userSaysRevert()) {
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean userSaysRevert() {
        Toolkit.getDefaultToolkit().beep();
        this.ftf.selectAll();
        Object[] options = new Object[]{C4TApplicationResources.getLabel("label.button.edit"), C4TApplicationResources.getLabel("label.button.revert")};
        int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), C4TApplicationResources.getLabel("label.message.number.greater.positive") + " " + this.minimum + ".\n" + C4TApplicationResources.getLabel("label.message.number.edit") + " " + C4TApplicationResources.getLabel("label.message.number.revert") + " ", C4TApplicationResources.getLabel("label.message.invalid.text.entered"), 0, 0, null, options, options[1]);
        if (answer == 1) {
            this.ftf.setValue(this.ftf.getValue());
            return true;
        }
        SwingUtilities.getWindowAncestor(this.ftf).requestFocus();
        this.ftf.requestFocus();
        return false;
    }

    protected boolean isEditValid() {
        String value = this.ftf.getText();
        try {
            Double currValue = Double.parseDouble(value);
            this.ftf.setValue(currValue);
            return true;
        }
        catch (NumberFormatException nex) {
            return false;
        }
    }

    public boolean isCellEditable(EventObject anEvent) {
        boolean result = true;
        String text = this.txtFurtherDiscount.getText();
        if (text.length() != 0) {
            try {
                Double value = Double.parseDouble(text);
                if (value < 0.0 || value > 100.0) {
                    result = false;
                }
            }
            catch (NumberFormatException ex) {
                result = false;
            }
        }
        if (result && anEvent instanceof MouseEvent) {
            result = ((MouseEvent)anEvent).getClickCount() >= 0;
        }
        return result;
    }

    private static VetoableChangeListener getNumericVetoableChangeListener(final JFormattedTextField ftf, JTree xmlTree) {
        VetoableChangeListener vcl = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
                String text = ftf.getText();
                if (text.length() != 0) {
                    try {
                        Double.parseDouble(text);
                    }
                    catch (NumberFormatException ex) {
                        throw new PropertyVetoException("Number format", arg0);
                    }
                }
            }
        };
        return vcl;
    }
}

