/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.text;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;

public class DoubleinputVerifier
extends InputVerifier {
    private Double minimum = 0.0;
    private Double maximum = 100.0;

    public boolean verify(JComponent input) {
        JTextComponent source = (JTextComponent)input;
        String text = source.getText();
        if (text.length() != 0) {
            try {
                Double value = Double.parseDouble(text);
                if (value < this.minimum || value > this.maximum) {
                    JOptionPane.showMessageDialog(source, "Number must be between " + this.minimum + " and " + this.maximum, "Error Dialog", 0);
                    return false;
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(source, "Number must be between " + this.minimum + " and " + this.maximum, "Error Dialog", 0);
                return false;
            }
        }
        return true;
    }

    public boolean shouldYieldFocus(JComponent input) {
        return this.verify(input);
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }
}

