/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.text;

import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import java.math.BigDecimal;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;

public class NumericCriterionFiledVerifier
extends InputVerifier {
    private C4TCriterion criterion;

    public NumericCriterionFiledVerifier(C4TCriterion criterion) {
        this.criterion = criterion;
    }

    public boolean verify(JComponent input) {
        JTextComponent source = (JTextComponent)input;
        String text = source.getText();
        if (text != null && text.length() != 0) {
            try {
                BigDecimal newValue = new BigDecimal(text);
                boolean inRange = true;
                if (this.criterion.getMax() != null && this.criterion.getMax().getIsPresent().booleanValue() && newValue.compareTo(this.criterion.getMax().getValue()) == 1) {
                    inRange = false;
                }
                if (inRange && this.criterion.getMin() != null && this.criterion.getMin().getIsPresent().booleanValue()) {
                    if (inRange && newValue.compareTo(this.criterion.getMin().getValue()) == -1) {
                        inRange = false;
                    } else if (this.criterion.getStep() != null && this.criterion.getStep().getValue().compareTo(new BigDecimal("0")) == 1) {
                        if (newValue.subtract(this.criterion.getMin().getValue()).remainder(this.criterion.getStep().getValue()).compareTo(new BigDecimal("0")) == 0) {
                            return true;
                        }
                        JOptionPane.showMessageDialog(source, C4TApplicationResources.getLabel("label.out.step"), "Error Dialog", 0);
                        return false;
                    }
                }
                if (inRange) {
                    return true;
                }
                String min = " ";
                if (this.criterion.getMin() != null) {
                    min = this.criterion.getMin().toStringVerifyer();
                }
                String max = " ";
                if (this.criterion.getMax() != null) {
                    max = this.criterion.getMax().toStringVerifyer();
                }
                JOptionPane.showMessageDialog(source, C4TApplicationResources.getLabel("label.out.range") + ", " + C4TApplicationResources.getLabel("label.right.range") + ": [" + min + " : " + max + "]", "Error Dialog", 0);
                return false;
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(source, C4TApplicationResources.getLabel("label.not.number"), "Error Dialog", 0);
                return false;
            }
        }
        return true;
    }

    public boolean shouldYieldFocus(JComponent input) {
        return this.verify(input);
    }
}

