/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.swing.workers;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;

public class ProgressGlassPane
extends JComponent {
    private static final int BAR_WIDTH = 200;
    private static final int BAR_HEIGHT = 20;
    private static final Color TEXT_COLOR = new Color(0x333333);
    private static final Color BORDER_COLOR = new Color(0x333333);
    private static final float[] GRADIENT_FRACTIONS = new float[]{0.0f, 0.499f, 0.5f, 1.0f};
    private static final Color[] GRADIENT_COLORS = new Color[]{Color.GRAY, Color.DARK_GRAY, Color.BLACK, Color.GRAY};
    private static final Color GRADIENT_COLOR2 = Color.WHITE;
    private static final Color GRADIENT_COLOR1 = Color.GRAY;
    private static final Color GRADIENT_COLOR3 = Color.YELLOW;
    private static final Color GRADIENT_COLOR4 = Color.BLUE;
    private String message = " tender ...";
    private int progress = 0;
    private String status;

    public ProgressGlassPane() {
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.addKeyListener(new KeyAdapter(){});
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ProgressGlassPane.this.requestFocusInWindow();
            }
        });
        this.setFocusTraversalKeysEnabled(false);
        this.setBackground(Color.WHITE);
        this.setFont(new Font("Default", 1, 16));
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.repaint();
    }

    public void setProgress(int progress, String status) {
        this.status = status;
        this.progress = progress;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clip = g.getClipBounds();
        AlphaComposite alpha = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), 0.5f);
        Composite composite = g2.getComposite();
        g2.setComposite(alpha);
        g2.setColor(this.getBackground());
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        FontMetrics metrics = g.getFontMetrics();
        int x = (this.getWidth() - 200) / 2;
        int y = (this.getHeight() - 20 - metrics.getDescent()) / 2;
        g2.setColor(TEXT_COLOR);
        g2.drawString(this.status + this.message + "  " + this.progress + "%", x, y);
        int w = (int)(200.0f * ((float)this.progress / 100.0f));
        int h = 20;
        Paint paint = g2.getPaint();
        GradientPaint gradient = new GradientPaint(x, y += metrics.getDescent(), GRADIENT_COLOR1, x, y + h, GRADIENT_COLOR2);
        g2.setPaint(gradient);
        g2.fillRect(x, y, 200, 20);
        gradient = new GradientPaint(x, y, GRADIENT_COLOR3, x, y + h, GRADIENT_COLOR4);
        g2.setPaint(gradient);
        g2.fillRect(x, y, w, h);
        g2.setPaint(paint);
        g2.drawRect(x, y, 200, 20);
        g2.setComposite(composite);
    }
}

