/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class C4TApplicationResources {
    protected static String language = "en";
    protected static ResourceBundle labels = ResourceBundle.getBundle("c4t", new Locale(language));
    protected static Map<String, String> helpFilesPaths = new HashMap<String, String>(){
        {
            this.put("en", "appwithhelp/docs/appwithhelpEng-hs.xml");
        }
    };
    public static Properties CURRENCY_PROPS = C4TApplicationResources.initProps("currency.properties");
    public static Properties PACK_PROPS = C4TApplicationResources.initProps("packing.properties");
    public static Boolean INVALID_TENDER_PACK_ENABLED = C4TApplicationResources.getBooleanProperty("invalid.tender.pack.enabled", true);

    public static String getLabel(String key) {
        String value = "";
        try {
            value = labels.getString(key);
            value = new String(value.getBytes("ISO-8859-1"), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getLabelUTF8(String key) {
        String value = labels.getString(key);
        return value;
    }

    public static String getLabel(String key, String[] params) {
        String value = "";
        try {
            value = labels.getString(key);
            value = new String(value.getBytes("ISO-8859-1"), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                value = value.replace("{" + i + "}", params[i]);
            }
        }
        return value;
    }

    public static final void changeLanguage(String lang) {
        try {
            labels = ResourceBundle.getBundle("c4t", new Locale(lang));
            language = lang;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final String getHelpPath() {
        return helpFilesPaths.get(language);
    }

    private static Properties initProps(String propertyName) {
        Properties retVal = null;
        try {
            URL propertyFileUrl = null;
            InputStream in = null;
            File configFile = new File(System.getProperty("java.io.tmpdir") + "/epps_tpt/" + propertyName);
            if (!configFile.exists()) {
                propertyFileUrl = C4TApplicationResources.class.getResource("/" + propertyName);
                in = propertyFileUrl.openStream();
            } else if (C4TApplicationResources.isTptVersionAndBuildKeySame(propertyName)) {
                in = new FileInputStream(configFile);
            } else {
                propertyFileUrl = C4TApplicationResources.class.getResource("/" + propertyName);
                in = propertyFileUrl.openStream();
            }
            retVal = new Properties();
            retVal.load(in);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            retVal = null;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProps(String propertyName, Properties props) {
        FileOutputStream fos = null;
        try {
            File configFile = new File(System.getProperty("java.io.tmpdir") + "/epps_tpt/" + propertyName);
            File appConfigFolder = new File(System.getProperty("java.io.tmpdir") + "/epps_tpt/");
            if (!appConfigFolder.exists()) {
                appConfigFolder.mkdirs();
            }
            fos = new FileOutputStream(configFile);
            props.store(fos, "Created on: " + new Date(System.currentTimeMillis()));
            PACK_PROPS = C4TApplicationResources.initProps("packing.properties");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTptVersionAndBuildKeySame(String propertyName) {
        URL propertyFileUrl = null;
        InputStream is1 = null;
        InputStream is2 = null;
        Properties properties1 = new Properties();
        Properties properties2 = new Properties();
        try {
            File configFile = new File(System.getProperty("java.io.tmpdir") + "/epps_tpt/" + propertyName);
            if (!configFile.exists()) {
                boolean bl = false;
                return bl;
            }
            propertyFileUrl = C4TApplicationResources.class.getResource("/" + propertyName);
            is1 = propertyFileUrl.openStream();
            is2 = new FileInputStream(configFile);
            properties1.load(is1);
            properties2.load(is2);
            String buildKeyInResource = properties1.getProperty("test.build");
            String buildKeyInTemp = properties2.getProperty("test.build");
            if (!("".equals(buildKeyInResource) || "".equals(buildKeyInResource) || buildKeyInResource.equals(buildKeyInTemp))) {
                boolean bl = false;
                return bl;
            }
            String versionKeyInResource = properties1.getProperty("tpt.version");
            String versionKeyInTemp = properties2.getProperty("tpt.version");
            if (!("".equals(versionKeyInResource) || "".equals(versionKeyInResource) || versionKeyInResource.equals(versionKeyInTemp))) {
                boolean bl = false;
                return bl;
            }
            String urlKeyInResource = properties1.getProperty("tpt.version.check.url.main");
            String urlKeyInTemp = properties2.getProperty("tpt.version.check.url.main");
            if (!("".equals(urlKeyInResource) || "".equals(urlKeyInResource) || urlKeyInResource.equals(urlKeyInTemp))) {
                boolean bl = false;
                return bl;
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (is1 != null) {
                    is1.close();
                }
                if (is2 != null) {
                    is2.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = PACK_PROPS.getProperty(key);
        boolean result = defaultValue;
        if (value != null) {
            result = Boolean.valueOf(value);
        }
        return result;
    }
}

