/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.utils;

import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.FileUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.ImageC4TUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.JRViewer;
import net.sf.jasperreports.view.save.JRPdfSaveContributor;

public class C4TJasperViewer
extends JFrame {
    private C4TJRViewer viewer = null;
    private boolean isExitOnClose = false;
    private JPanel pnlMain;

    public C4TJasperViewer(String sourceFile, boolean isXMLFile) throws JRException {
        this(sourceFile, isXMLFile, false);
        this.init();
    }

    public C4TJasperViewer(InputStream is, boolean isXMLFile) throws JRException {
        this(is, isXMLFile, false);
        this.init();
    }

    public C4TJasperViewer(JasperPrint jasperPrint) {
        this(jasperPrint, false);
        this.init();
    }

    public C4TJasperViewer(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(sourceFile, isXMLFile, isExitOnClose, null);
        this.init();
    }

    public C4TJasperViewer(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(is, isXMLFile, isExitOnClose, null);
        this.init();
    }

    public C4TJasperViewer(JasperPrint jasperPrint, boolean isExitOnClose) {
        this(jasperPrint, isExitOnClose, null);
        this.init();
    }

    public C4TJasperViewer(String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new C4TJRViewer(sourceFile, isXMLFile, locale);
        this.pnlMain.add((Component)((Object)this.viewer), "Center");
        this.init();
    }

    public C4TJasperViewer(InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new C4TJRViewer(is, isXMLFile, locale);
        this.pnlMain.add((Component)((Object)this.viewer), "Center");
        this.init();
    }

    public C4TJasperViewer(JasperPrint jasperPrint, boolean isExitOnClose, Locale locale) {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new C4TJRViewer(jasperPrint, locale);
        this.pnlMain.add((Component)((Object)this.viewer), "Center");
        this.init();
    }

    private void init() {
        String fileTitle = FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
        fileTitle = fileTitle + ".pdf";
        this.setTitle(C4TApplicationResources.getLabel("label.cyprus.eProcurement") + " " + C4TApplicationResources.getLabel("label.export.print.tool") + " " + fileTitle);
        this.setIconImage(ImageC4TUtils.getApplicationIcon().getImage());
    }

    private void initComponents() {
        int width;
        this.pnlMain = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                C4TJasperViewer.this.exitForm();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenResolution = toolkit.getScreenResolution();
        float zoom = (float)screenResolution / 72.0f;
        int height = (int)(550.0f * zoom);
        if ((double)height > screenSize.getHeight()) {
            height = (int)screenSize.getHeight();
        }
        if ((double)(width = (int)(750.0f * zoom)) > screenSize.getWidth()) {
            width = (int)screenSize.getWidth();
        }
        Dimension dimension = new Dimension(width, height);
        this.setSize(dimension);
        this.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
    }

    void exitForm() {
        if (this.isExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.viewer.clear();
            this.viewer = null;
            this.getContentPane().removeAll();
            this.dispose();
        }
    }

    public void setZoomRatio(float zoomRatio) {
        this.viewer.setZoomRatio(zoomRatio);
    }

    public void setFitWidthZoomRatio() {
        this.viewer.setFitWidthZoomRatio();
    }

    public void setFitPageZoomRatio() {
        this.viewer.setFitPageZoomRatio();
    }

    public static void viewReport(String sourceFile, boolean isXMLFile) throws JRException {
        C4TJasperViewer.viewReport(sourceFile, isXMLFile, false, null);
    }

    public static void viewReport(InputStream is, boolean isXMLFile) throws JRException {
        C4TJasperViewer.viewReport(is, isXMLFile, false, null);
    }

    public static void viewReport(JasperPrint jasperPrint) {
        C4TJasperViewer.viewReport(jasperPrint, false, null);
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        C4TJasperViewer.viewReport(sourceFile, isXMLFile, isExitOnClose, null);
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        C4TJasperViewer.viewReport(is, isXMLFile, isExitOnClose, null);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose) {
        C4TJasperViewer.viewReport(jasperPrint, isExitOnClose, null);
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        C4TJasperViewer jasperViewer = new C4TJasperViewer(sourceFile, isXMLFile, isExitOnClose, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        C4TJasperViewer jasperViewer = new C4TJasperViewer(is, isXMLFile, isExitOnClose, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose, Locale locale) {
        C4TJasperViewer jasperViewer = new C4TJasperViewer(jasperPrint, isExitOnClose, locale);
        jasperViewer.setVisible(true);
    }

    private class C4TJRViewer
    extends JRViewer {
        public C4TJRViewer(String fileName, boolean isXML, Locale locale) throws JRException {
            super(fileName, isXML, locale, null);
            this.init();
        }

        public C4TJRViewer(JasperPrint jrPrint, Locale locale) {
            super(jrPrint, locale, null);
            this.init();
        }

        public C4TJRViewer(InputStream is, boolean isXML, Locale locale) throws JRException {
            super(is, isXML, locale);
            this.init();
        }

        private void init() {
            JRSaveContributor[] exports = this.getSaveContributors();
            ArrayList<JRSaveContributor> pdfContributor = new ArrayList<JRSaveContributor>();
            for (JRSaveContributor c : exports) {
                if (!(c instanceof JRPdfSaveContributor)) continue;
                pdfContributor.add(c);
            }
            this.setSaveContributors(pdfContributor.toArray(new JRSaveContributor[0]));
            exports = this.getSaveContributors();
            this.btnSave.setVisible(true);
            this.btnSave.setToolTipText(C4TApplicationResources.getLabel("menu.file.save"));
            this.btnSave.setFocusPainted(false);
            this.btnActualSize.setFocusPainted(false);
            this.btnActualSize.setToolTipText(C4TApplicationResources.getLabel("label.actual.size"));
            this.btnFirst.setFocusPainted(false);
            this.btnFirst.setToolTipText(C4TApplicationResources.getLabel("label.first.page"));
            this.txtGoTo.setToolTipText(C4TApplicationResources.getLabel("label.go.to.page"));
            this.btnFitPage.setFocusPainted(false);
            this.btnFitPage.setToolTipText(C4TApplicationResources.getLabel("label.fit.to.page"));
            this.btnFitWidth.setFocusPainted(false);
            this.btnFitWidth.setToolTipText(C4TApplicationResources.getLabel("label.fit.width"));
            this.btnLast.setFocusPainted(false);
            this.btnLast.setToolTipText(C4TApplicationResources.getLabel("label.last.page"));
            this.btnNext.setFocusPainted(false);
            this.btnNext.setToolTipText(C4TApplicationResources.getLabel("label.next.page"));
            this.btnPrevious.setFocusPainted(false);
            this.btnPrevious.setToolTipText(C4TApplicationResources.getLabel("label.previous.page"));
            this.btnPrint.setFocusPainted(false);
            this.btnPrint.setToolTipText(C4TApplicationResources.getLabel("label.print"));
            this.btnReload.setFocusPainted(false);
            this.btnReload.setToolTipText(C4TApplicationResources.getLabel("label.reload"));
            this.btnSave.setFocusPainted(false);
            this.btnZoomIn.setFocusPainted(false);
            this.btnZoomIn.setToolTipText(C4TApplicationResources.getLabel("label.zoom.in"));
            this.btnZoomOut.setFocusPainted(false);
            this.btnZoomOut.setToolTipText(C4TApplicationResources.getLabel("label.zoom.out"));
            this.cmbZoom.setToolTipText(C4TApplicationResources.getLabel("label.zoom.ratio"));
        }
    }
}

