/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.utils;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.JTreeC4TCompopnentType;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.helper.SectionStatisticsEventsProducer;
import com.eurodyn.eprocurement.tools.c4t.preparation.exception.C4TException;
import com.eurodyn.eprocurement.tools.c4t.preparation.exception.C4TExceptionCode;
import com.eurodyn.eprocurement.tools.c4t.preparation.swing.workers.ProgressGlassPane;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.CriterionMissingFile;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.JFileChooserUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.XMLFileFilter;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.security.SecuritateUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TBody;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TLot;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TSection;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamConstants;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.C4TSectionComponent;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.JTreeC4TCompopnent;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.pack.C4TEnvelopePack;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.pack.C4TTenderMetadataPackUtil;
import com.thoughtworks.xstream.XStream;
import java.awt.Container;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final String xml = "xml";
    private static File currentFile;
    private static String temporaryDir;
    public static String tempDirPrefix;
    public static String package1;
    public static String package2;
    public static String package3;
    public static String package4;
    public static String indexFile;
    public static String infoFile;
    private static String TENDER_FOLDER_MARKER;
    private static String sysoutFile;
    private static String syserrFile;
    private static HashMap<String, String> attachmentMap;
    private static int numberOfAttachmentsInZip;
    private static ArrayList<FileInputStream> lockedFiles;
    private static ArrayList<String> referencedFiles;

    public static File getCurrentFile() {
        return currentFile;
    }

    public static void setCurrentFile(File currentFile) {
        FileUtils.currentFile = currentFile;
    }

    public static String getCurrentTitle() {
        String title = C4TApplicationResources.getLabel("label.cyprus.eProcurement") + " (";
        title = title + currentFile.getName() + ")";
        return title;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = FileUtils.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static C4TExceptionCode pack(C4TBody body, Container panel) {
        C4TExceptionCode c4TExceptionCode;
        block12: {
            File workDir = null;
            try {
                String tmp = FileUtils.getCurrentFile().getParent() + File.separator + FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
                String strTarget = tmp + "_TENDER.zip";
                long time = System.currentTimeMillis();
                String strWorkDir = FileUtils.getCurrentFile().getParent() + File.separator + "C4T" + time;
                workDir = FileUtils.createWorkFolder(body, strWorkDir);
                FileUtils.lockFiles(workDir);
                String strSource = strWorkDir + File.separator + FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
                if (body.getPack() == null || body.getPack().length() == 0 || body.getPack().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_PACKING_TYPE_SINGLE)) {
                    FileUtils.packAll(strTarget, strSource, body, panel);
                } else {
                    FileUtils.packByEnvelopes(strTarget, strSource, body, panel);
                }
                if (body.getOffset24().getValue().booleanValue()) {
                    FileUtils.generateHashFile(tmp, body.getRound(), body.getCftid());
                }
                if (C4TApplicationResources.getBooleanProperty("check.tender.package.size", false)) {
                    FileUtils.checkPackageSize(strTarget, body);
                }
                c4TExceptionCode = C4TExceptionCode.C4TNoError;
                FileUtils.unlockFiles();
                if (workDir == null) break block12;
            }
            catch (C4TException ex) {
                ex.printStackTrace();
                C4TExceptionCode c4TExceptionCode2 = ex.getErrorCode();
                return c4TExceptionCode2;
            }
            catch (IOException e) {
                System.out.println("Error with coping files to work directory " + e);
                C4TExceptionCode c4TExceptionCode3 = C4TExceptionCode.C4TFileIO;
                return c4TExceptionCode3;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtils.unlockFiles();
                if (workDir != null) {
                    FileUtils.deleteDir(workDir, null);
                }
            }
            FileUtils.deleteDir(workDir, null);
        }
        return c4TExceptionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static C4TExceptionCode pack(C4TBody body, ProgressGlassPane viewer) {
        try {
            String tmp = FileUtils.getCurrentFile().getParent() + File.separator + FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
            String strTarget = tmp + "_TENDER.zip";
            String strSource = tmp;
            if (body.getPack() == null || body.getPack().length() == 0 || body.getPack().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_PACKING_TYPE_SINGLE)) {
                FileUtils.packAll(strTarget, strSource, body, viewer);
                try {
                    File fNew = new File(strTarget);
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                    messageDigest.update(FileUtils.getBytesFromFile(fNew));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                FileUtils.packByEnvelopes(strTarget, strSource, body, viewer);
            }
            if (body.getOffset24().getValue().booleanValue()) {
                FileUtils.generateHashFile(tmp, body.getRound(), body.getCftid());
            }
            if (C4TApplicationResources.getBooleanProperty("check.tender.package.size", false)) {
                FileUtils.checkPackageSize(strTarget, body);
            }
            C4TExceptionCode c4TExceptionCode = C4TExceptionCode.C4TNoError;
            return c4TExceptionCode;
        }
        catch (C4TException ex) {
            ex.printStackTrace();
            C4TExceptionCode c4TExceptionCode = ex.getErrorCode();
            return c4TExceptionCode;
        }
    }

    public static String generateHashFile(File sourceFile, Integer cftId, Integer cycleId) throws C4TException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(FileUtils.getBytesFromFile(sourceFile));
            String shaHash = FileUtils.byteToHexaString(messageDigest.digest());
            String shaHashfinal = Integer.toString(cftId) + System.getProperty("line.separator") + Integer.toString(cycleId) + System.getProperty("line.separator") + shaHash;
            String filePath = sourceFile.getAbsolutePath();
            int dotIndex = filePath.lastIndexOf(".") != -1 ? filePath.lastIndexOf(".") : filePath.length();
            String dpFilePath = filePath.substring(0, dotIndex) + "_DIGITAL_PRINT.hf";
            System.out.println("dpFilePath = " + dpFilePath);
            BufferedWriter out = new BufferedWriter(new FileWriter(dpFilePath));
            out.write(shaHashfinal);
            out.flush();
            out.close();
            String sourceFileName = sourceFile.getName();
            dotIndex = sourceFileName.lastIndexOf(".") != -1 ? sourceFileName.lastIndexOf(".") : sourceFileName.length();
            String destinationName = sourceFileName.substring(0, dotIndex) + "_DIGITAL_PRINT.hf";
            return destinationName;
        }
        catch (NoSuchAlgorithmException eAlgo) {
            throw new C4TException(C4TExceptionCode.C4TEncrypting, eAlgo);
        }
        catch (IOException eIO) {
            throw new C4TException(C4TExceptionCode.C4TFileIO, eIO);
        }
    }

    private static boolean generateHashFile(String filePath, Integer cycleId, Integer cftId) {
        try {
            String fullName = filePath + "_TENDER.zip";
            SecuritateUtil su = SecuritateUtil.getInstance();
            MessageDigest messageDigest = su.getDigest(fullName);
            String shaHash = FileUtils.byteToHexaString(messageDigest.digest());
            String shaHashfinal = Integer.toString(cftId) + System.getProperty("line.separator") + Integer.toString(cycleId) + System.getProperty("line.separator") + shaHash;
            BufferedWriter out = new BufferedWriter(new FileWriter(filePath + "_DIGITAL_PRINT.hf"));
            out.write(shaHashfinal);
            out.flush();
            out.close();
        }
        catch (NoSuchAlgorithmException eAlgo) {
            eAlgo.printStackTrace();
        }
        catch (IOException eIO) {
            eIO.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private static String byteToHexaString(byte[] data) {
        String out = "";
        for (int i = 0; i < data.length; ++i) {
            out = out + FileUtils.byteToHex(data[i]);
        }
        return out;
    }

    public static String byteToHex(byte data) {
        StringBuffer buf = new StringBuffer();
        buf.append(FileUtils.toHexChar(data >>> 4 & 0xF));
        buf.append(FileUtils.toHexChar(data & 0xF));
        return buf.toString();
    }

    public static char toHexChar(int i) {
        if (0 <= i && i <= 9) {
            return (char)(48 + i);
        }
        return (char)(97 + (i - 10));
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            return null;
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static String makeAbsoluteAttachmentPath(C4TCriterion criterion) {
        String dirPath = temporaryDir;
        if (dirPath == null || dirPath.length() == 0) {
            FileUtils.createTempDir();
            dirPath = temporaryDir;
        }
        String absolutePath = dirPath + (criterion.getRelevantDoc() != null ? criterion.getRelevantDoc() : criterion.getValue());
        return absolutePath;
    }

    public static String makeRelativePath(C4TCriterion criterion) {
        String packagePrefix = "";
        String lotPath = "";
        if (criterion.getLotId() != null) {
            lotPath = "Lot_" + criterion.getLotId() + File.separator;
        }
        packagePrefix = File.separator + criterion.getEnvelopeId().toString() + File.separator + lotPath;
        String relativePath = packagePrefix + "C_" + criterion.getId() + File.separator;
        return relativePath;
    }

    public static String copyAttachedFile(String relativePath, File file, String oldFileName, C4TCriterion criterion) throws IOException {
        String fname;
        String dirPath = temporaryDir;
        if (dirPath == null || dirPath.length() == 0) {
            FileUtils.createTempDir();
            dirPath = temporaryDir;
        }
        FileUtils.makeDirForCriterionAttachment(relativePath, dirPath);
        if (oldFileName != null && oldFileName.length() > 0) {
            FileUtils.deleteOldCriterionAttachment(dirPath, oldFileName);
        }
        if ((fname = file.getName()).indexOf(46) > 0) {
            String[] splitfname = fname.split("\\.");
            fname = splitfname[splitfname.length - 1];
        }
        fname = criterion.getId().toString() + "." + fname;
        String newFileName = dirPath + relativePath + fname;
        File fNew = new File(newFileName);
        FileUtils.copy(file, fNew);
        return fname;
    }

    public static void copyAttachedFile(String relativePath, String oldFileName) throws IOException {
        String dirPath = temporaryDir;
        if (dirPath == null || dirPath.length() == 0) {
            FileUtils.createTempDir();
            dirPath = temporaryDir;
        }
        FileUtils.makeDirForCriterionAttachment(relativePath, dirPath);
    }

    protected static String deleteOldCriterionAttachment(String criterionPath, String oldFileName) throws IOException {
        String oldFilePath = criterionPath + File.separator + oldFileName;
        new File(oldFilePath).delete();
        return criterionPath;
    }

    protected static void makeDirForCriterionAttachment(String relativePath, String dirPath) throws IOException {
        String criterionPath = dirPath + relativePath;
        boolean exists = new File(criterionPath).exists();
        if (!exists) {
            File direct = new File(criterionPath);
            direct.mkdirs();
        }
    }

    protected static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packByEnvelopes(String strTarget, String strSource, C4TBody body, Container panel) throws C4TException {
        ZipOutputStream cpZipOutputStream = null;
        FileOutputStream fos = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String prefixName = FileUtils.getCurrentFile().getName();
            SecuritateUtil su = SecuritateUtil.getInstance();
            fos = new FileOutputStream(strTarget);
            cpZipOutputStream = new ZipOutputStream(fos);
            cpZipOutputStream.setLevel(9);
            int maxSequenceNum = C4TXStreamUtil.getMaxSequenceNum(body);
            ArrayList<String> targetTempSequenceLst = new ArrayList<String>();
            ArrayList<C4TEnvelopePack> c4TEnvelopePackLst = new ArrayList<C4TEnvelopePack>();
            for (int i = 1; i <= maxSequenceNum; ++i) {
                ArrayList<String> envelopesIds = new ArrayList<String>();
                String targetTempSequence = prefixName.substring(0, prefixName.length() - 4) + "_" + i + ".zip";
                targetTempSequenceLst.add(targetTempSequence);
                ByteArrayInputStream sequenceXML = C4TXStreamUtil.extractEnvelopesBySequence(body, i, envelopesIds);
                FileUtils.packEnvelope(targetTempSequence, strSource, sequenceXML, body, envelopesIds, panel);
                Key keySequence = su.generateAESKey();
                su.encryptWithAES_CBC(keySequence, FileUtils.getCurrentFile().getParent() + File.separator + "tmp.zip", FileUtils.getCurrentFile().getParent() + File.separator + "enc.tmp.zip");
                MessageDigest messageDigest = su.getDigest(FileUtils.getCurrentFile().getParent() + File.separator + "enc.tmp.zip");
                String shaHashTechnical = FileUtils.byteToHexaString(messageDigest.digest());
                FileUtils.addFileEntry(cpZipOutputStream, new File(FileUtils.getCurrentFile().getParent() + File.separator + "enc.tmp.zip"), targetTempSequence);
                C4TEnvelopePack cpSequence = new C4TEnvelopePack(su.encryptKeyWithRSA(keySequence, body.getPubKey()), shaHashTechnical, Integer.toString(i));
                c4TEnvelopePackLst.add(cpSequence);
                FileUtils.deleteEncryptionTmp();
            }
            C4TTenderMetadataPackUtil.createXStreamTenderMetaDataPack(cpZipOutputStream, c4TEnvelopePackLst, body);
            for (String targetTempSequence : targetTempSequenceLst) {
                String temp1 = "/" + targetTempSequence + '\n';
                out.write(temp1.getBytes());
            }
            FileUtils.addByteArrayEntry(cpZipOutputStream, new ByteArrayInputStream(out.toByteArray()), indexFile);
            if (C4TApplicationResources.getBooleanProperty("generate.info.file", false)) {
                ByteArrayInputStream is = FileUtils.makeInfoForZip();
                FileUtils.addByteArrayEntry(cpZipOutputStream, is, infoFile);
            }
            String tmpFileName = System.getProperty("user.home") + File.separator + sysoutFile;
            FileUtils.addFileEntry(cpZipOutputStream, new File(tmpFileName), sysoutFile);
            tmpFileName = System.getProperty("user.home") + File.separator + syserrFile;
            FileUtils.addFileEntry(cpZipOutputStream, new File(tmpFileName), syserrFile);
        }
        catch (C4TException ex) {
            if (ex.getErrorCode() == C4TExceptionCode.C4TFileIO) {
                cpZipOutputStream = null;
                FileUtils.deleteEncryptionTmp();
            }
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (cpZipOutputStream != null) {
                    cpZipOutputStream.finish();
                    cpZipOutputStream.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void packByEnvelopes(String strTarget, String strSource, C4TBody body, ProgressGlassPane viewer) throws C4TException {
        try {
            throw new C4TException();
        }
        catch (C4TException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packEnvelope(String strTarget, String strSource, ByteArrayInputStream is, C4TBody body, List<String> envelopesIds, Container panel) throws C4TException {
        String fileName = "tender.xml";
        FileOutputStream out = null;
        ZipOutputStream cpZipOutputStream = null;
        ByteArrayInputStream isIndex = null;
        try {
            out = new FileOutputStream(FileUtils.getCurrentFile().getParent() + File.separator + "tmp.zip");
            cpZipOutputStream = new ZipOutputStream(out);
            cpZipOutputStream.setLevel(9);
            File cpFile = new File(strSource);
            boolean isAttachedFiles = true;
            if (!cpFile.isFile() && !cpFile.isDirectory()) {
                isAttachedFiles = false;
            }
            FileUtils.addByteArrayEntry(cpZipOutputStream, is, fileName);
            isIndex = FileUtils.makeIndexForZip(body, fileName, false, envelopesIds);
            if (isAttachedFiles) {
                FileUtils.zipFiles(strTarget, strSource, cpZipOutputStream, cpFile, envelopesIds);
            }
            FileUtils.addByteArrayEntry(cpZipOutputStream, isIndex, indexFile);
            cpZipOutputStream.finish();
            cpZipOutputStream.close();
            cpZipOutputStream = null;
            if (!FileUtils.isInnerZipContentValid(body, panel, isAttachedFiles)) {
                if (!C4TApplicationResources.INVALID_TENDER_PACK_ENABLED.booleanValue()) {
                    JOptionPane.showMessageDialog(panel, C4TApplicationResources.getLabel("label.attach.files.missing.missing.unable.continue"), C4TApplicationResources.getLabel("label.files.missing.file.package.zip"), 0);
                    throw new C4TException(C4TExceptionCode.C4TFileIO);
                }
                Object[] missingFileOptions = new Object[]{C4TApplicationResources.getLabel("label.yes"), C4TApplicationResources.getLabel("label.no")};
                int missingFileAnswer = 0;
                missingFileAnswer = JOptionPane.showOptionDialog(panel, C4TApplicationResources.getLabel("label.attach.files.missing.missing.continue"), C4TApplicationResources.getLabel("label.files.missing.file.package.zip"), 0, 3, null, missingFileOptions, missingFileOptions[0]);
                if (missingFileAnswer != 0) {
                    FileUtils.deleteEncryptionTmp();
                    C4TException c4tEx = new C4TException(C4TExceptionCode.C4TFileIO);
                    throw c4tEx;
                }
                System.out.println(C4TApplicationResources.getLabel("label.files.missing.file.package.zip"));
            }
        }
        catch (C4TException ex) {
            throw ex;
        }
        catch (Exception e) {
            System.out.println("Error in: zip2envelopes proofandtechnical");
            e.printStackTrace();
        }
        finally {
            try {
                if (cpZipOutputStream != null) {
                    cpZipOutputStream.finish();
                    cpZipOutputStream.close();
                }
                if (isIndex != null) {
                    isIndex.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packAll(String strTarget, String strSource, C4TBody body, Container panel) throws C4TException {
        FileOutputStream fosEnvelope = null;
        ZipOutputStream cpZipOutputStreamEnvelope = null;
        FileOutputStream out = null;
        try {
            boolean isAttachedFiles = true;
            File cpFile = new File(strSource);
            if (!cpFile.isFile() && !cpFile.isDirectory()) {
                isAttachedFiles = false;
            }
            fosEnvelope = new FileOutputStream(strTarget);
            cpZipOutputStreamEnvelope = new ZipOutputStream(fosEnvelope);
            cpZipOutputStreamEnvelope.setLevel(9);
            out = new FileOutputStream(FileUtils.getCurrentFile().getParent() + File.separator + "tmp.zip");
            ZipOutputStream cpZipOutputStream = new ZipOutputStream(out);
            cpZipOutputStream.setLevel(9);
            File xmlF = new File(strSource + ".xml");
            FileUtils.addFileEntry(cpZipOutputStream, xmlF, xmlF.getName());
            ByteArrayInputStream is = FileUtils.makeIndexForZip(body, FileUtils.getCurrentFile().getName(), true, null);
            if (isAttachedFiles) {
                FileUtils.zipFiles(strTarget, strSource, cpZipOutputStream, cpFile);
            }
            FileUtils.addByteArrayEntry(cpZipOutputStream, is, indexFile);
            if (C4TApplicationResources.getBooleanProperty("generate.info.file", false)) {
                is = FileUtils.makeInfoForZip();
                FileUtils.addByteArrayEntry(cpZipOutputStream, is, infoFile);
            }
            cpZipOutputStream.finish();
            cpZipOutputStream.close();
            if (!FileUtils.isInnerZipContentValid(body, panel, isAttachedFiles)) {
                if (!C4TApplicationResources.INVALID_TENDER_PACK_ENABLED.booleanValue()) {
                    JOptionPane.showMessageDialog(panel, C4TApplicationResources.getLabel("label.attach.files.missing.missing.unable.continue"), C4TApplicationResources.getLabel("label.files.missing.file.package.zip"), 0);
                    throw new C4TException(C4TExceptionCode.C4TFileIO);
                }
                Object[] missingFileOptions = new Object[]{C4TApplicationResources.getLabel("label.yes"), C4TApplicationResources.getLabel("label.no")};
                int missingFileAnswer = 0;
                missingFileAnswer = JOptionPane.showOptionDialog(panel, C4TApplicationResources.getLabel("label.attach.files.missing.missing.continue"), C4TApplicationResources.getLabel("label.files.missing.file.package.zip"), 0, 3, null, missingFileOptions, missingFileOptions[0]);
                if (missingFileAnswer != 0) {
                    C4TException c4tEx = new C4TException(C4TExceptionCode.C4TFileIO);
                    throw c4tEx;
                }
                System.out.println(C4TApplicationResources.getLabel("label.files.missing.file.package.zip"));
            }
            String innerName = FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
            innerName = innerName + ".zip";
            SecuritateUtil su = SecuritateUtil.getInstance();
            Key key = su.generateAESKey();
            su.encryptWithAES_CBC(key, FileUtils.getCurrentFile().getParent() + File.separator + "tmp.zip", FileUtils.getCurrentFile().getParent() + File.separator + "enc.tmp.zip");
            FileUtils.addFileEntry(cpZipOutputStreamEnvelope, new File(FileUtils.getCurrentFile().getParent() + File.separator + "enc.tmp.zip"), innerName);
            MessageDigest messageDigest = su.getDigest(FileUtils.getCurrentFile().getParent() + File.separator + "enc.tmp.zip");
            String shaHash = FileUtils.byteToHexaString(messageDigest.digest());
            C4TEnvelopePack cp = new C4TEnvelopePack(su.encryptKeyWithRSA(key, body.getPubKey()), shaHash, "1");
            ArrayList<C4TEnvelopePack> c4TEnvelopePackLst = new ArrayList<C4TEnvelopePack>();
            c4TEnvelopePackLst.add(cp);
            C4TTenderMetadataPackUtil.createXStreamTenderMetaDataPack(cpZipOutputStreamEnvelope, c4TEnvelopePackLst, body);
            String tmpFileName = System.getProperty("user.home") + File.separator + sysoutFile;
            FileUtils.addFileEntry(cpZipOutputStreamEnvelope, new File(tmpFileName), sysoutFile);
            tmpFileName = System.getProperty("user.home") + File.separator + syserrFile;
            FileUtils.addFileEntry(cpZipOutputStreamEnvelope, new File(tmpFileName), syserrFile);
            FileUtils.deleteEncryptionTmp();
        }
        catch (C4TException ex) {
            if (ex.getErrorCode() == C4TExceptionCode.C4TFileIO) {
                cpZipOutputStreamEnvelope = null;
                FileUtils.deleteEncryptionTmp();
            }
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (cpZipOutputStreamEnvelope != null) {
                    cpZipOutputStreamEnvelope.finish();
                    cpZipOutputStreamEnvelope.close();
                }
                if (out != null) {
                    out.close();
                }
                if (fosEnvelope != null) {
                    fosEnvelope.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static File createWorkFolder(C4TBody body, String strWorkDir) throws IOException {
        File tempDir = new File(strWorkDir);
        tempDir.mkdir();
        File xmlF = new File(strWorkDir + File.separator + FileUtils.getCurrentFile().getName());
        XStream xst = C4TXStreamUtil.createXStream();
        C4TXStreamUtil.writeToFile(xmlF, xst, body);
        referencedFiles = FileUtils.getReferencedFiles(body);
        String srcDirPathTemp = FileUtils.getCurrentFile().getParent() + File.separator + FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
        boolean isAttachedFiles = true;
        File cpFile = new File(srcDirPathTemp);
        if (!cpFile.isFile() && !cpFile.isDirectory()) {
            isAttachedFiles = false;
        }
        if (isAttachedFiles) {
            FileUtils.copyDirectory(cpFile, new File(strWorkDir + File.separator + FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4)));
        }
        return tempDir;
    }

    private static void lockFiles(File file) {
        if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                FileUtils.lockFiles(new File(fileList[i].getAbsolutePath()));
            }
        } else {
            try {
                FileInputStream fis = new FileInputStream(file);
                lockedFiles.add(fis);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static void unlockFiles() {
        Iterator<FileInputStream> iterator = lockedFiles.iterator();
        while (iterator.hasNext()) {
            try {
                FileInputStream fis = iterator.next();
                if (fis == null) continue;
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        lockedFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInnerZipContentValid(C4TBody body, Container panel, boolean isAttachedFiles) throws C4TException, ZipException, IOException {
        boolean valid = false;
        ZipFile zipFile = new ZipFile(new File(FileUtils.getCurrentFile().getParent() + File.separator + "tmp.zip"));
        ArrayList<String> zipEntriesList = new ArrayList<String>();
        ArrayList<String> requiredEntriesList = new ArrayList<String>();
        if (body.getPack() == null || body.getPack().length() == 0 || body.getPack().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_PACKING_TYPE_SINGLE)) {
            requiredEntriesList.add(FileUtils.getCurrentFile().getName());
        } else {
            requiredEntriesList.add("tender.xml");
        }
        requiredEntriesList.add(indexFile);
        try {
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                zipEntriesList.add(ze.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            zipFile.close();
        }
        valid = zipEntriesList.containsAll(requiredEntriesList);
        if (!valid) {
            JOptionPane.showMessageDialog(panel, C4TApplicationResources.getLabel("label.req.files.missing.unable.continue"), C4TApplicationResources.getLabel("label.files.missing.file.package.zip"), 0);
            throw new C4TException(C4TExceptionCode.C4TFileIO);
        }
        if (isAttachedFiles) {
            requiredEntriesList.add(TENDER_FOLDER_MARKER);
            requiredEntriesList.addAll(attachmentMap.values());
            valid = zipEntriesList.containsAll(requiredEntriesList);
        }
        return valid;
    }

    private static void deleteEncryptionTmp() {
        File tmpFile;
        try {
            tmpFile = new File(FileUtils.getCurrentFile().getParent() + File.separator + "tmp.zip");
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception ex) {
            System.out.println("could not delete tmp.zip");
        }
        try {
            tmpFile = new File(FileUtils.getCurrentFile().getParent() + File.separator + "enc.tmp.zip");
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception ex) {
            System.out.println("could not delete enc.tmp.zip");
        }
    }

    private static void checkPackageSize(String strTarget, C4TBody body) throws C4TException {
        File packageFile = new File(strTarget);
        Long packageFileSize = packageFile.length() / 0x100000L;
        String size = C4TApplicationResources.PACK_PROPS.getProperty("max.allowed.tender.package.size");
        if (body.getTenderPackageMaxSize() != null && !"".equals(body.getTenderPackageMaxSize())) {
            size = body.getTenderPackageMaxSize();
        }
        if (packageFileSize.compareTo(Long.parseLong(size)) > 0) {
            try {
                if (packageFile != null && packageFile.exists()) {
                    packageFile.delete();
                }
            }
            catch (Exception ex) {
                System.out.println("could not delete " + strTarget);
            }
            C4TException c4tEx = new C4TException(C4TExceptionCode.C4TPackageSize);
            throw c4tEx;
        }
    }

    private static void packAll(String strTarget, String strSource, C4TBody body, ProgressGlassPane viewer) throws C4TException {
        try {
            boolean isAttachedFiles = true;
            File cpFile = new File(strSource);
            if (!cpFile.isFile() && !cpFile.isDirectory()) {
                isAttachedFiles = false;
            }
            viewer.setProgress(0, "Archiving ");
            FileOutputStream fosEnvelope = new FileOutputStream(strTarget);
            ZipOutputStream cpZipOutputStreamEnvelope = new ZipOutputStream(fosEnvelope);
            cpZipOutputStreamEnvelope.setLevel(9);
            viewer.setProgress(2, "Archiving ");
            FileOutputStream out = new FileOutputStream("testZipaMaliZipa.zip");
            ZipOutputStream cpZipOutputStream = new ZipOutputStream(out);
            cpZipOutputStream.setLevel(9);
            FileUtils.addFileEntry(cpZipOutputStream, FileUtils.getCurrentFile(), FileUtils.getCurrentFile().getName());
            ByteArrayInputStream is = FileUtils.makeIndexForZip(body, FileUtils.getCurrentFile().getName(), true, null);
            if (isAttachedFiles) {
                FileUtils.zipFiles(strTarget, strSource, cpZipOutputStream, cpFile);
            }
            viewer.setProgress(70, "Archiving ");
            FileUtils.addByteArrayEntry(cpZipOutputStream, is, indexFile);
            if (C4TApplicationResources.getBooleanProperty("generate.info.file", false)) {
                is = FileUtils.makeInfoForZip();
                FileUtils.addByteArrayEntry(cpZipOutputStream, is, infoFile);
            }
            cpZipOutputStream.finish();
            cpZipOutputStream.close();
            out.flush();
            out.close();
            FileInputStream in2 = new FileInputStream("testZipaMaliZipa.zip");
            String innerName = FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
            innerName = innerName + ".zip";
            viewer.setProgress(75, "Encrypting ");
            SecuritateUtil su = SecuritateUtil.getInstance();
            Key key = su.generateAESKey();
            byte[] fileEncrptedByAES = su.encryptWithAES_CBC(key, in2);
            System.out.println("fileEncrptedByAES size = " + fileEncrptedByAES.length);
            ByteArrayInputStream inputStreamEncrptedByAES = new ByteArrayInputStream(fileEncrptedByAES);
            File zippedFile = new File("testZipaMaliZipa.zip");
            FileUtils.addFileEntry(cpZipOutputStreamEnvelope, zippedFile, innerName);
            viewer.setProgress(95, "Generating metadata for ");
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(fileEncrptedByAES);
            String shaHash = FileUtils.byteToHexaString(messageDigest.digest());
            C4TEnvelopePack cp = new C4TEnvelopePack(su.encryptKeyWithRSA(key, body.getPubKey()), shaHash, "1");
            ArrayList<C4TEnvelopePack> c4TEnvelopePackLst = new ArrayList<C4TEnvelopePack>();
            c4TEnvelopePackLst.add(cp);
            C4TTenderMetadataPackUtil.createXStreamTenderMetaDataPack(cpZipOutputStreamEnvelope, c4TEnvelopePackLst, body);
            cpZipOutputStreamEnvelope.finish();
            cpZipOutputStreamEnvelope.close();
            viewer.setProgress(100, "Done packing ");
        }
        catch (C4TException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void zipFiles(String strTarget, String strSource, ZipOutputStream cpZipOutputStream, File cpFile) throws C4TException {
        if (cpFile.isDirectory()) {
            File[] fList = cpFile.listFiles();
            for (int i = 0; i < fList.length; ++i) {
                FileUtils.zipFiles(strTarget, strSource, cpZipOutputStream, fList[i]);
            }
        } else {
            String strZipEntryName;
            if (cpFile.getAbsolutePath().equalsIgnoreCase(strTarget)) {
                return;
            }
            String strAbsPath = cpFile.getPath();
            String strFileName = cpFile.getName();
            System.out.println("Currently packing file: " + strAbsPath);
            if (attachmentMap.containsKey(strFileName)) {
                strZipEntryName = attachmentMap.get(strFileName);
                ++numberOfAttachmentsInZip;
            } else if (strFileName.endsWith(TENDER_FOLDER_MARKER)) {
                strZipEntryName = TENDER_FOLDER_MARKER;
            } else {
                return;
            }
            if (strAbsPath.indexOf(package1) >= 0 && strZipEntryName.indexOf(package1) < 0 || strAbsPath.indexOf(package2) >= 0 && strZipEntryName.indexOf(package2) < 0 || strAbsPath.indexOf(package3) >= 0 && strZipEntryName.indexOf(package3) < 0) {
                throw new C4TException(C4TExceptionCode.C4TFileIO, new Exception("Corrupted folder name!"));
            }
            FileUtils.addFileEntry(cpZipOutputStream, cpFile, strZipEntryName);
        }
    }

    private static void zipFiles(String strTarget, String strSource, ZipOutputStream cpZipOutputStream, File cpFile, List<String> envelopesIds) throws C4TException {
        if (cpFile.isDirectory()) {
            File[] fList = cpFile.listFiles();
            block0: for (int i = 0; i < fList.length; ++i) {
                for (String envelopeId : envelopesIds) {
                    if (!envelopeId.equals(fList[i].getName()) && fList[i].isDirectory()) continue;
                    FileUtils.zipFiles(strTarget, strSource, cpZipOutputStream, fList[i]);
                    continue block0;
                }
            }
        }
    }

    private static void addByteArrayEntry(ZipOutputStream cpZipOutputStream, ByteArrayInputStream is, String strZipEntryName) {
        int DATA_BLOCK_SIZE = 2048;
        try {
            int byteCount;
            ZipEntry cpZipEntry = new ZipEntry(strZipEntryName);
            cpZipOutputStream.putNextEntry(cpZipEntry);
            byte[] b = new byte[2048];
            while ((byteCount = is.read(b, 0, 2048)) != -1) {
                cpZipOutputStream.write(b, 0, byteCount);
            }
            cpZipOutputStream.closeEntry();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addFileEntry(ZipOutputStream cpZipOutputStream, File cpFile, String strZipEntryName) {
        int DATA_BLOCK_SIZE = 2048;
        try {
            int byteCount;
            FileInputStream cpFileInputStream = new FileInputStream(cpFile);
            ZipEntry cpZipEntry = new ZipEntry(strZipEntryName);
            cpZipOutputStream.putNextEntry(cpZipEntry);
            int i = 0;
            byte[] b = new byte[2048];
            while ((byteCount = cpFileInputStream.read(b, 0, 2048)) != -1) {
                ++i;
                cpZipOutputStream.write(b, 0, byteCount);
            }
            cpZipOutputStream.closeEntry();
            cpFileInputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ByteArrayInputStream makeInfoForZip() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StringBuffer infoData = new StringBuffer();
        String eol = System.getProperty("line.separator");
        infoData.append("Operating system name = " + System.getProperty("os.name") + eol);
        infoData.append("Java Version = " + System.getProperty("java.version") + eol);
        infoData.append("Java home = " + System.getProperty("java.home") + eol);
        infoData.append("Operating system architecture = " + System.getProperty("os.arch") + eol);
        infoData.append("Operating system version = " + System.getProperty("os.version") + eol);
        if (C4TApplicationResources.getBooleanProperty("version.control.enabled", false)) {
            infoData.append("TPT version = " + C4TApplicationResources.PACK_PROPS.getProperty("tpt.version") + eol);
        }
        infoData.append("Number of attachment references in tender xml file = " + referencedFiles.size() + eol);
        infoData.append("Number of file attachments in package zip file= " + numberOfAttachmentsInZip + eol);
        try {
            out.write(infoData.toString().getBytes());
        }
        catch (Exception e) {
            System.out.println("Error while writing xml in info.txt");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
        return is;
    }

    public static ByteArrayInputStream makeIndexForZip(C4TBody body, String xmlName, boolean isAll, List<String> envelopesIds) {
        List<C4TLot> lots;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String xmlNameForPacking = "/" + xmlName + '\n';
        try {
            out.write(xmlNameForPacking.getBytes());
        }
        catch (Exception e) {
            System.out.println("Error while writing xml in index.txt");
        }
        List<C4TEnvelope> envelopes = body.getEnvelopes();
        attachmentMap.clear();
        numberOfAttachmentsInZip = 0;
        if (envelopes != null && envelopes.size() > 0) {
            block2: for (C4TEnvelope c4TEnvelope : envelopes) {
                if (isAll) {
                    FileUtils.makeIndexForEnvelope(c4TEnvelope, out);
                    continue;
                }
                for (String envelopeId : envelopesIds) {
                    if (!envelopeId.equals(c4TEnvelope.getId().toString())) continue;
                    FileUtils.makeIndexForEnvelope(c4TEnvelope, out);
                    continue block2;
                }
            }
        }
        if ((lots = body.getLots()) != null && lots.size() > 0) {
            for (C4TLot lt : lots) {
                block5: for (C4TEnvelope en : lt.getNodes()) {
                    if (isAll) {
                        FileUtils.makeIndexForEnvelope(en, out);
                        continue;
                    }
                    for (String envelopeId : envelopesIds) {
                        if (!envelopeId.equals(en.getId().toString())) continue;
                        FileUtils.makeIndexForEnvelope(en, out);
                        continue block5;
                    }
                }
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
        return byteArrayInputStream;
    }

    private static void makeIndexForEnvelope(C4TEnvelope en, ByteArrayOutputStream out) {
        try {
            for (C4TSectionComponent sc : en.getNodes()) {
                if (sc.getJType() == JTreeC4TCompopnentType.C4TCriterion) {
                    String filePath;
                    C4TCriterion criterion = (C4TCriterion)sc;
                    if (criterion.getType().equalsIgnoreCase("file") && criterion.getValue() != null && !criterion.getValue().equals("")) {
                        FileUtils.addAttachmentData(criterion.getValue());
                        filePath = criterion.getValue() + '\n';
                        out.write(filePath.getBytes());
                    }
                    if (criterion.getRelevantDoc() == null || criterion.getRelevantDoc().equals("")) continue;
                    FileUtils.addAttachmentData(criterion.getRelevantDoc());
                    filePath = criterion.getRelevantDoc() + '\n';
                    out.write(filePath.getBytes());
                    continue;
                }
                if (sc.getJType() != JTreeC4TCompopnentType.C4TSection) continue;
                C4TSection temp = (C4TSection)sc;
                FileUtils.makeIndexForSection(temp, out);
            }
        }
        catch (Exception e) {
            System.out.println("Error while coping in the file ");
        }
    }

    private static void makeIndexForSection(C4TSection section, ByteArrayOutputStream out) {
        try {
            for (C4TSectionComponent sc : section.getNodes()) {
                if (sc.getJType() == JTreeC4TCompopnentType.C4TCriterion) {
                    String filePath;
                    C4TCriterion criterion = (C4TCriterion)sc;
                    if (criterion.getType().equalsIgnoreCase("file") && criterion.getValue() != null && !criterion.getValue().equals("")) {
                        FileUtils.addAttachmentData(criterion.getValue());
                        filePath = criterion.getValue() + '\n';
                        out.write(filePath.getBytes());
                    }
                    if (criterion.getRelevantDoc() == null || criterion.getRelevantDoc().equals("")) continue;
                    FileUtils.addAttachmentData(criterion.getRelevantDoc());
                    filePath = criterion.getRelevantDoc() + '\n';
                    out.write(filePath.getBytes());
                    continue;
                }
                if (sc.getJType() != JTreeC4TCompopnentType.C4TSection) continue;
                C4TSection temp = (C4TSection)sc;
                FileUtils.makeIndexForSection(temp, out);
            }
        }
        catch (Exception e) {
            System.out.println("Error while coping in the file ");
        }
    }

    private static void addAttachmentData(String value) {
        String attachmentKey = value.substring(value.lastIndexOf(File.separator) + File.separator.length(), value.length());
        attachmentMap.put(attachmentKey, value.substring(File.separator.length(), value.length()));
    }

    public static void createTempDir() {
        if (temporaryDir == null || temporaryDir.length() == 0) {
            String dirForAttachementsName = FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
            String dirPathAtt = FileUtils.getCurrentFile().getParent() + File.separator + dirForAttachementsName;
            File attachDir = new File(dirPathAtt);
            boolean exists = attachDir.exists();
            long time = System.currentTimeMillis();
            String dirPathTemp = FileUtils.getCurrentFile().getParent() + File.separator + "C4T" + time;
            temporaryDir = dirPathTemp;
            File tempDir = new File(temporaryDir);
            boolean success = tempDir.mkdir();
            if (success && exists) {
                try {
                    FileUtils.copyDirectory(attachDir, tempDir);
                }
                catch (Exception e) {
                    System.out.println("Error with coping files to temporary directory " + e);
                }
            }
        }
    }

    public static void createSystemOutputFile() {
        try {
            String userHome = System.getProperty("user.home");
            File file = new File(userHome + File.separator + sysoutFile);
            FileOutputStream fis = new FileOutputStream(file);
            PrintStream out = new PrintStream(fis);
            System.setOut(out);
            File errFile = new File(userHome + File.separator + syserrFile);
            FileOutputStream errFis = new FileOutputStream(errFile);
            PrintStream errOut = new PrintStream(errFis);
            System.setErr(errOut);
            System.out.println("Operating system name = " + System.getProperty("os.name"));
            System.out.println("Jave Version = " + System.getProperty("java.version"));
            System.out.println("Java home = " + System.getProperty("java.home"));
            System.out.println("Operating system architecture = " + System.getProperty("os.arch"));
            System.out.println("Operating system version = " + System.getProperty("os.version"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            FileUtils.copy(srcDir, dstDir);
        }
    }

    private static boolean deleteDir(File dir, File tmp) {
        if (dir.equals(tmp)) {
            return true;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]), tmp);
                if (success) continue;
                return false;
            }
        }
        dir.delete();
        return true;
    }

    public static void copyFromTempDir() {
        File tempDir;
        boolean exists;
        if (temporaryDir == null || temporaryDir.length() == 0) {
            FileUtils.createTempDir();
        }
        if (exists = (tempDir = new File(temporaryDir)).exists()) {
            String dirForAttachementsName = FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
            String dirPathAtt = FileUtils.getCurrentFile().getParent() + File.separator + dirForAttachementsName;
            File attachDir = new File(dirPathAtt);
            if (attachDir.exists()) {
                FileUtils.deleteDir(attachDir, tempDir);
            }
            boolean success = attachDir.mkdir();
            try {
                FileUtils.copyDirectory(tempDir, attachDir);
                File marker = new File(attachDir, TENDER_FOLDER_MARKER);
                marker.createNewFile();
                FileUtils.deleteTempDir();
            }
            catch (Exception e) {
                System.out.println("Error with coping files to temporary directory " + e);
            }
        }
    }

    public static void deleteTempDir() {
        if (FileUtils.getCurrentFile() != null && temporaryDir != null && temporaryDir.length() > 0) {
            String dirTempName = tempDirPrefix + FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4);
            String dirPathTemp = FileUtils.getCurrentFile().getParent() + File.separator + dirTempName;
            File tempDir = new File(temporaryDir);
            boolean exists = tempDir.exists();
            if (exists) {
                FileUtils.deleteDir(tempDir, null);
            }
            temporaryDir = null;
        }
    }

    private static URLConnection getConnection() throws IOException {
        URL uploadServlet = new URL("http:// + hostName + hostPort +/zc4twebapp333/uploadServlet");
        URLConnection con = uploadServlet.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        return con;
    }

    public static void sendFile(File file) throws MalformedURLException, IOException, ClassNotFoundException {
        JPanel dataPane = new JPanel();
        URLConnection con = FileUtils.getConnection();
        FileUtils.sendDataToServlet(con, file);
        String response = (String)FileUtils.getResponseFromServlet(con);
        JOptionPane.showMessageDialog(dataPane, response);
    }

    private static Object getResponseFromServlet(URLConnection con) throws IOException, ClassNotFoundException {
        InputStream instr = con.getInputStream();
        ObjectInputStream inputFromServlet = new ObjectInputStream(instr);
        Object result = inputFromServlet.readObject();
        inputFromServlet.close();
        instr.close();
        return result;
    }

    private static void sendDataToServlet(URLConnection con, File file) throws IOException {
        int len;
        OutputStream os = con.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        FileInputStream is = new FileInputStream(file);
        byte[] buf = new byte[1024];
        String name = file.getName();
        oos.writeObject(name);
        while ((len = ((InputStream)is).read(buf)) > 0) {
            oos.write(buf, 0, len);
        }
        oos.flush();
        oos.close();
    }

    public static boolean isFilesMissing(String realPath, JTreeC4TCompopnent cftElement) {
        boolean isMissing = false;
        switch (cftElement.getJType()) {
            case C4TBody: {
                C4TBody body = (C4TBody)cftElement;
                ArrayList<JTreeC4TCompopnent> elementList = new ArrayList<JTreeC4TCompopnent>();
                if (body.getEnvelopes() != null) {
                    elementList.addAll(body.getEnvelopes());
                }
                if (body.getLots() != null) {
                    elementList.addAll(body.getLots());
                }
                for (JTreeC4TCompopnent newElement : elementList) {
                    if (!FileUtils.isFilesMissing(realPath, newElement)) continue;
                    return true;
                }
                break;
            }
            case C4TLot: {
                C4TLot lot = (C4TLot)cftElement;
                for (JTreeC4TCompopnent jTreeC4TCompopnent : lot.getNodes()) {
                    if (!FileUtils.isFilesMissing(realPath, jTreeC4TCompopnent)) continue;
                    return true;
                }
                break;
            }
            case C4TEnvelope: {
                C4TEnvelope envelope = (C4TEnvelope)cftElement;
                if (envelope.getNodes() == null || envelope.getNodes().size() <= 0) break;
                for (JTreeC4TCompopnent jTreeC4TCompopnent : envelope.getNodes()) {
                    if (!FileUtils.isFilesMissing(realPath, jTreeC4TCompopnent)) continue;
                    return true;
                }
                break;
            }
            case C4TSection: {
                C4TSection section = (C4TSection)cftElement;
                for (JTreeC4TCompopnent jTreeC4TCompopnent : section.getNodes()) {
                    if (!FileUtils.isFilesMissing(realPath, jTreeC4TCompopnent)) continue;
                    return true;
                }
                break;
            }
            case C4TCriterion: {
                C4TCriterion criterion = (C4TCriterion)cftElement;
                String relevantDocument = criterion.getRelevantDoc();
                if (relevantDocument != null && relevantDocument.length() > 0) {
                    String string = realPath + relevantDocument;
                    System.out.println("(relevant document) checking existenze of file: " + string);
                    boolean exists = new File(string).exists();
                    if (!exists) {
                        return true;
                    }
                }
                if (!criterion.getType().equalsIgnoreCase("file") || criterion.getValue() == null || criterion.getValue().equals("")) break;
                String string = criterion.getValue();
                String path = realPath + string;
                System.out.println("(criterion file) checking existenze of file: " + path);
                boolean exists = new File(path).exists();
                if (exists) break;
                return true;
            }
        }
        return isMissing;
    }

    public static List<CriterionMissingFile> getMissingFiles(String realPath, JTreeC4TCompopnent cftElement, boolean cleanCFTFile) {
        ArrayList<CriterionMissingFile> criterionMissingFile = new ArrayList<CriterionMissingFile>();
        switch (cftElement.getJType()) {
            case C4TBody: {
                C4TBody body = (C4TBody)cftElement;
                ArrayList<JTreeC4TCompopnent> elementList = new ArrayList<JTreeC4TCompopnent>();
                if (body.getEnvelopes() != null) {
                    elementList.addAll(body.getEnvelopes());
                }
                if (body.getLots() != null) {
                    elementList.addAll(body.getLots());
                }
                for (JTreeC4TCompopnent newElement : elementList) {
                    criterionMissingFile.addAll(FileUtils.getMissingFiles(realPath, newElement, cleanCFTFile));
                }
                break;
            }
            case C4TLot: {
                C4TLot lot = (C4TLot)cftElement;
                for (JTreeC4TCompopnent jTreeC4TCompopnent : lot.getNodes()) {
                    criterionMissingFile.addAll(FileUtils.getMissingFiles(realPath, jTreeC4TCompopnent, cleanCFTFile));
                }
                break;
            }
            case C4TEnvelope: {
                C4TEnvelope envelope = (C4TEnvelope)cftElement;
                for (JTreeC4TCompopnent jTreeC4TCompopnent : envelope.getNodes()) {
                    criterionMissingFile.addAll(FileUtils.getMissingFiles(realPath, jTreeC4TCompopnent, cleanCFTFile));
                }
                break;
            }
            case C4TSection: {
                C4TSection section = (C4TSection)cftElement;
                for (JTreeC4TCompopnent jTreeC4TCompopnent : section.getNodes()) {
                    criterionMissingFile.addAll(FileUtils.getMissingFiles(realPath, jTreeC4TCompopnent, cleanCFTFile));
                }
                break;
            }
            case C4TCriterion: {
                boolean bl;
                C4TCriterion criterion = (C4TCriterion)cftElement;
                String relevantDocument = criterion.getRelevantDoc();
                boolean bl2 = true;
                String oldRelevantDocPath = new String();
                String oldFileCriterionPath = new String();
                if (relevantDocument != null && relevantDocument.length() > 0) {
                    String path = realPath + relevantDocument;
                    System.out.println("(relevant document) checking existenze of file: " + path);
                    boolean exists = new File(path).exists();
                    if (!exists) {
                        oldRelevantDocPath = criterion.getRelevantDoc();
                        bl = false;
                        if (cleanCFTFile) {
                            criterion.setRelevantDoc("");
                        }
                    }
                }
                if (criterion.getType().equalsIgnoreCase("file") && criterion.getValue() != null && !criterion.getValue().equals("")) {
                    String filePath = criterion.getValue();
                    String path = realPath + filePath;
                    System.out.println("(criterion file) checking existenze of file: " + path);
                    boolean exists = new File(path).exists();
                    if (!exists) {
                        oldFileCriterionPath = criterion.getValue();
                        if (cleanCFTFile) {
                            criterion.setValue("");
                        }
                    }
                }
                if (bl) break;
                CriterionMissingFile cmf = new CriterionMissingFile(criterion, oldRelevantDocPath, oldFileCriterionPath);
                criterionMissingFile.add(cmf);
            }
        }
        return criterionMissingFile;
    }

    public static ArrayList<String> getReferencedFiles(JTreeC4TCompopnent cftElement) {
        ArrayList<String> referencedFilesList = new ArrayList<String>();
        switch (cftElement.getJType()) {
            case C4TBody: {
                C4TBody body = (C4TBody)cftElement;
                ArrayList<JTreeC4TCompopnent> elementList = new ArrayList<JTreeC4TCompopnent>();
                if (body.getEnvelopes() != null) {
                    elementList.addAll(body.getEnvelopes());
                }
                if (body.getLots() != null) {
                    elementList.addAll(body.getLots());
                }
                for (JTreeC4TCompopnent newElement : elementList) {
                    referencedFilesList.addAll(FileUtils.getReferencedFiles(newElement));
                }
                break;
            }
            case C4TLot: {
                C4TLot lot = (C4TLot)cftElement;
                for (JTreeC4TCompopnent jTreeC4TCompopnent : lot.getNodes()) {
                    referencedFilesList.addAll(FileUtils.getReferencedFiles(jTreeC4TCompopnent));
                }
                break;
            }
            case C4TEnvelope: {
                C4TEnvelope envelope = (C4TEnvelope)cftElement;
                for (JTreeC4TCompopnent jTreeC4TCompopnent : envelope.getNodes()) {
                    referencedFilesList.addAll(FileUtils.getReferencedFiles(jTreeC4TCompopnent));
                }
                break;
            }
            case C4TSection: {
                C4TSection section = (C4TSection)cftElement;
                for (JTreeC4TCompopnent jTreeC4TCompopnent : section.getNodes()) {
                    referencedFilesList.addAll(FileUtils.getReferencedFiles(jTreeC4TCompopnent));
                }
                break;
            }
            case C4TCriterion: {
                C4TCriterion criterion = (C4TCriterion)cftElement;
                String relevantDocument = criterion.getRelevantDoc();
                if (relevantDocument != null && relevantDocument.length() > 0) {
                    referencedFilesList.add(relevantDocument);
                }
                if (!criterion.getType().equalsIgnoreCase("file") || criterion.getValue() == null || criterion.getValue().equals("")) break;
                referencedFilesList.add(criterion.getValue());
            }
        }
        return referencedFilesList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean saveXML(C4TBody body, Container panel, boolean saveAs) {
        boolean isNotTemplate;
        XStream xst = C4TXStreamUtil.createXStream();
        if (body == null) return false;
        File xmlF = FileUtils.getCurrentFile();
        boolean bl = isNotTemplate = body.getTimeStamp() != null && body.getTimeStamp().length() > 0;
        if (isNotTemplate && !saveAs) {
            C4TXStreamUtil.writeToFile(xmlF, xst, body);
            FileUtils.copyFromTempDir();
        } else {
            JFileChooser fc = JFileChooserUtils.createJFileChooser();
            fc.addChoosableFileFilter(new XMLFileFilter());
            fc.setAcceptAllFileFilterUsed(false);
            fc.setCurrentDirectory(FileUtils.getCurrentFile().getParentFile());
            int returnVal = fc.showSaveDialog(panel);
            if (returnVal != 0) return false;
            File file = fc.getSelectedFile();
            Object[] okoption = new Object[]{C4TApplicationResources.getLabel("label.ok")};
            if (new File(file.getParentFile(), TENDER_FOLDER_MARKER).exists()) {
                JOptionPane.showOptionDialog(panel, C4TApplicationResources.getLabel("message.in.tender.folder"), C4TApplicationResources.getLabel("c4t.exception.error"), 0, 0, null, okoption, okoption[0]);
                return false;
            }
            Object[] options = new Object[]{C4TApplicationResources.getLabel("label.yes"), C4TApplicationResources.getLabel("label.cancel")};
            if (file.exists()) {
                int option = JOptionPane.showOptionDialog(panel, C4TApplicationResources.getLabel("message.file.overwrite.existing"), C4TApplicationResources.getLabel("message.file.overwrite.existing"), 0, 3, null, options, options[0]);
                if (option != 0) return false;
                long time = System.currentTimeMillis();
                body.setTimeStamp("time" + time);
                FileUtils.createTempDir();
                C4TXStreamUtil.writeToFile(file, xst, body);
                FileUtils.setCurrentFile(file);
                FileUtils.copyFromTempDir();
                JOptionPane.showOptionDialog(panel, C4TApplicationResources.getLabel("label.created.folder") + file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 4) + C4TApplicationResources.getLabel("label.dont.modify.folder"), C4TApplicationResources.getLabel("message.info"), 0, 1, null, okoption, okoption[0]);
            } else {
                try {
                    boolean result;
                    if (!file.getName().endsWith(".xml")) {
                        file = new File(file.getAbsolutePath() + ".xml");
                    }
                    if (!(result = file.createNewFile())) {
                        JOptionPane.showMessageDialog(panel, C4TApplicationResources.getLabel("label.error.saving.use.diff.name.or.location"), C4TApplicationResources.getLabel("label.error.saving"), 0);
                        return false;
                    }
                    long time = System.currentTimeMillis();
                    body.setTimeStamp("time" + time);
                    FileUtils.createTempDir();
                    C4TXStreamUtil.writeToFile(file, xst, body);
                    FileUtils.setCurrentFile(file);
                    FileUtils.copyFromTempDir();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        SectionStatisticsEventsProducer.getInstance().fire(SectionStatisticsEventsProducer.EventType.CFTSAVED);
        return true;
    }

    public static void deleteAttachedFile(String relativeFilePath, String oldFileName) throws IOException {
        String dirPath = temporaryDir;
        FileUtils.deleteOldCriterionAttachment(dirPath, oldFileName);
        boolean exists = new File(temporaryDir).delete();
        File tempDir = new File(temporaryDir + relativeFilePath);
        FileUtils.deleteDir(tempDir, null);
    }

    public static void unzip(String strZipFile) {
        try {
            File fSourceZip = new File(strZipFile);
            String zipPath = strZipFile.substring(0, strZipFile.length() - 4);
            File temp = new File(zipPath);
            temp.mkdir();
            System.out.println(zipPath + " created");
            ZipFile zipFile = new ZipFile(fSourceZip);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                int b;
                ZipEntry entry = e.nextElement();
                File destinationFilePath = new File(zipPath, entry.getName());
                destinationFilePath.getParentFile().mkdirs();
                if (entry.isDirectory()) continue;
                System.out.println("Extracting " + destinationFilePath);
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(destinationFilePath);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
                while ((b = bis.read(buffer, 0, 1024)) != -1) {
                    bos.write(buffer, 0, b);
                }
                bos.flush();
                bos.close();
                bis.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("IOError :" + ioe);
        }
    }

    static {
        tempDirPrefix = "temp_";
        package1 = "Proof_Documents";
        package2 = "Technical_Documents";
        package3 = "Financial_Documents";
        package4 = "Offline_Documents";
        indexFile = "index.txt";
        infoFile = "info.txt";
        TENDER_FOLDER_MARKER = "tender_folder_marker.c4t";
        sysoutFile = "sysout.txt";
        syserrFile = "syserr.txt";
        attachmentMap = new HashMap();
        numberOfAttachmentsInZip = 0;
        lockedFiles = new ArrayList();
        referencedFiles = new ArrayList();
    }
}

