/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.utils;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.JTreeC4TCompopnentType;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNode;
import com.eurodyn.eprocurement.tools.c4t.preparation.pojos.C4TTreeNodeState;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.FileUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TBody;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TLot;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TPrice;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TSection;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TYear;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamConstants;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.C4TSectionComponent;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.JTreeC4TCompopnent;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeC4TComponentUtils {
    public static C4TTreeNode createNodes(List<JTreeC4TCompopnent> jComponents, boolean isWithLots) {
        if (isWithLots) {
            ArrayList<C4TLot> lots = new ArrayList<C4TLot>();
            for (JTreeC4TCompopnent jComp : jComponents) {
                lots.add((C4TLot)jComp);
            }
            return JTreeC4TComponentUtils.createNodesForLot(lots, null);
        }
        ArrayList<C4TEnvelope> envelopes = new ArrayList<C4TEnvelope>();
        for (JTreeC4TCompopnent jComp : jComponents) {
            envelopes.add((C4TEnvelope)jComp);
        }
        return JTreeC4TComponentUtils.createNodesForEnvelope(envelopes, null);
    }

    public static C4TTreeNode createNodes(C4TBody body) {
        body.setName(C4TApplicationResources.getLabel("label.tender"));
        C4TTreeNode root = new C4TTreeNode(body);
        C4TTreeNodeState state = new C4TTreeNodeState(JTreeC4TCompopnentType.C4TBody, C4TTreeNodeState.C4TTreeNodeHasCriterions.NotSupported, C4TTreeNodeState.C4TTreeNodeIsCompleted.NotSupported);
        root.setState(state);
        if (body.getEnvelopes() != null && body.getEnvelopes().size() > 0) {
            Collections.sort(body.getEnvelopes());
            root = JTreeC4TComponentUtils.createNodesForEnvelope(body.getEnvelopes(), root);
        }
        if (body.getLots() != null && body.getLots().size() > 0) {
            root = JTreeC4TComponentUtils.createNodesForLot(body.getLots(), root);
        }
        return root;
    }

    public static C4TTreeNode createNodesForLot(List<C4TLot> lots, C4TTreeNode root) {
        if (root == null) {
            root = new C4TTreeNode(new C4TBody(C4TApplicationResources.getLabel("label.tender")));
            C4TTreeNodeState state = new C4TTreeNodeState(JTreeC4TCompopnentType.C4TBody, C4TTreeNodeState.C4TTreeNodeHasCriterions.NotSupported, C4TTreeNodeState.C4TTreeNodeIsCompleted.NotSupported);
            root.setState(state);
        }
        C4TBody body = (C4TBody)root.getUserObject();
        for (C4TLot lot : lots) {
            lot.setMulti_item(body.getMulti_item());
            C4TTreeNode lotNode = new C4TTreeNode(lot);
            Collections.sort(lot.getNodes());
            lotNode = JTreeC4TComponentUtils.createNodesForEnvelope(lot.getNodes(), lotNode);
            root.add(lotNode);
        }
        return root;
    }

    public static C4TTreeNode createNodesForEnvelope(List<C4TEnvelope> envelopes, C4TTreeNode root) {
        String lotId = null;
        Boolean multi_item = false;
        JTreeC4TCompopnentType rootType = JTreeC4TCompopnentType.C4TBody;
        if (root == null) {
            root = new C4TTreeNode(new C4TBody("Start"));
        } else {
            JTreeC4TCompopnent userObject = (JTreeC4TCompopnent)root.getUserObject();
            if (userObject.getJType().equals((Object)JTreeC4TCompopnentType.C4TLot)) {
                C4TLot lot = (C4TLot)userObject;
                multi_item = lot.getMulti_item().getValue();
                lotId = lot.getId() != null ? lot.getId().toString() : "";
                rootType = JTreeC4TCompopnentType.C4TLot;
            }
        }
        C4TTreeNodeState.C4TTreeNodeIsCompleted isCompletedRoot = C4TTreeNodeState.C4TTreeNodeIsCompleted.True;
        C4TTreeNodeState.C4TTreeNodeHasCriterions hasCriterionsRoot = C4TTreeNodeState.C4TTreeNodeHasCriterions.False;
        for (C4TEnvelope en : envelopes) {
            en.setMulti_item(multi_item);
            C4TTreeNode enNode = new C4TTreeNode(en);
            C4TTreeNodeState.C4TTreeNodeIsCompleted isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.True;
            C4TTreeNodeState.C4TTreeNodeHasCriterions hasCriterions = C4TTreeNodeState.C4TTreeNodeHasCriterions.False;
            if (en.getNodes() != null) {
                C4TCriterion criterion;
                if (!C4TXStreamConstants.C4T_XML_SECTION_TYPE_FINANCIAL.equalsIgnoreCase(en.getType())) {
                    Collections.sort(en.getNodes());
                    for (C4TSectionComponent sc : en.getNodes()) {
                        switch (sc.getJType()) {
                            case C4TCriterion: {
                                String absoluteAttachmentPath;
                                File attachment;
                                criterion = (C4TCriterion)sc;
                                if (lotId != null) {
                                    criterion.setLotId(lotId);
                                }
                                criterion.setEnvelopeType(en.getType());
                                criterion.setEnvelopeId(en.getId());
                                criterion.setSectionType(en.getType());
                                if (criterion.getType().equalsIgnoreCase("FILE") && criterion.getValue() != null && criterion.getValue().length() != 0 && (attachment = new File(absoluteAttachmentPath = FileUtils.makeAbsoluteAttachmentPath(criterion))) != null && attachment.exists()) {
                                    criterion.setFileSize(attachment.length());
                                }
                                if (!C4TXStreamUtil.isCriterionCompleted(criterion)) {
                                    isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                                }
                                hasCriterions = C4TTreeNodeState.C4TTreeNodeHasCriterions.True;
                                break;
                            }
                            case C4TSection: {
                                C4TSection c4tSec = (C4TSection)sc;
                                c4tSec.setType(en.getType());
                                C4TTreeNode grandpa = new C4TTreeNode(c4tSec);
                                if (!c4tSec.getNodes().isEmpty()) {
                                    grandpa = JTreeC4TComponentUtils.createNodes(c4tSec.getNodes(), grandpa, c4tSec.getType(), en.getId(), lotId);
                                }
                                C4TTreeNodeState childState = grandpa.getState();
                                boolean isUseCertificate = c4tSec.isUseCertificate();
                                if (!isUseCertificate) {
                                    switch (childState.getIsCompleted()) {
                                        case False: {
                                            isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                                        }
                                    }
                                } else {
                                    isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.True;
                                }
                                hasCriterions = C4TTreeNodeState.C4TTreeNodeHasCriterions.True;
                                enNode.add(grandpa);
                                break;
                            }
                        }
                    }
                } else if (rootType.equals((Object)JTreeC4TCompopnentType.C4TLot) && multi_item.booleanValue()) {
                    Boolean awardedPerItem = en.getAwarded_per_item().getValue();
                    for (C4TSectionComponent sc : en.getNodes()) {
                        switch (sc.getJType()) {
                            case C4TCriterion: {
                                hasCriterions = C4TTreeNodeState.C4TTreeNodeHasCriterions.True;
                                criterion = (C4TCriterion)sc;
                                if (lotId != null) {
                                    criterion.setLotId(lotId);
                                }
                                criterion.setEnvelopeType(en.getType());
                                criterion.setEnvelopeId(en.getId());
                                if (criterion.getUnit_price() == 0.0 && !awardedPerItem.booleanValue()) {
                                    isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                                }
                                if (criterion.getUnit_price() != 0.0 || criterion.getMandatory() != 1 || !awardedPerItem.booleanValue()) break;
                                isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                            }
                        }
                    }
                } else {
                    if (en.getNodes() != null && !en.getNodes().isEmpty()) {
                        hasCriterions = C4TTreeNodeState.C4TTreeNodeHasCriterions.True;
                        ArrayList<C4TYear> years = new ArrayList<C4TYear>(en.getNumOfYears());
                        int i = 0;
                        int j = 0;
                        criterion = null;
                        C4TYear year = null;
                        for (C4TSectionComponent comp : en.getNodes()) {
                            criterion = (C4TCriterion)comp;
                            if (lotId != null) {
                                criterion.setLotId(lotId);
                            }
                            criterion.setEnvelopeType(en.getType());
                            criterion.setEnvelopeId(en.getId());
                            j = 0;
                            for (C4TPrice price : criterion.getPrices()) {
                                price.setCriterionLabel(criterion.getLabel());
                                if (i == 0) {
                                    year = new C4TYear();
                                    year.setCompleted(true);
                                    year.setPosition(j);
                                    year.setYear(price.getYear());
                                    if (criterion.getMandatory() != null && criterion.getMandatory() > 0 && (price.getValue() == null || price.getValue().equals("") || price.getValue().equals("0") || price.getValue().equals("0.0"))) {
                                        year.setCompleted(false);
                                    }
                                    ArrayList<C4TPrice> prices = new ArrayList<C4TPrice>();
                                    prices.add(price);
                                    year.setCriterionPrices(prices);
                                    years.add(year);
                                } else {
                                    year = (C4TYear)years.get(j);
                                    if (criterion.getMandatory() != null && criterion.getMandatory() > 0 && (price.getValue() == null || price.getValue().equals("") || price.getValue().equals("0") || price.getValue().equals("0.0"))) {
                                        year.setCompleted(false);
                                    }
                                    if (year.getYear().intValue() == price.getYear().intValue()) {
                                        year.getCriterionPrices().add(price);
                                    }
                                }
                                ++j;
                            }
                            ++i;
                        }
                        boolean completed = true;
                        for (C4TYear yearN : years) {
                            C4TTreeNode yearNode = new C4TTreeNode(yearN);
                            boolean bl = completed = completed && yearN.isCompleted() != false;
                            if (!en.getPresentValueCalc().booleanValue()) continue;
                            C4TTreeNodeState yearstate = new C4TTreeNodeState(JTreeC4TCompopnentType.C4TYear, C4TTreeNodeState.C4TTreeNodeHasCriterions.True, yearN.isCompleted() != false ? C4TTreeNodeState.C4TTreeNodeIsCompleted.True : C4TTreeNodeState.C4TTreeNodeIsCompleted.False);
                            yearNode.setState(yearstate);
                            enNode.add(yearNode);
                        }
                        isCompleted = completed ? C4TTreeNodeState.C4TTreeNodeIsCompleted.True : C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                    }
                    C4TTreeNodeState stateNew = new C4TTreeNodeState(JTreeC4TCompopnentType.C4TEnvelope, hasCriterions, C4TTreeNodeState.C4TTreeNodeIsCompleted.NotSupported);
                    boolean isCompletedEnvelope = true;
                    for (C4TSectionComponent sc : en.getNodes()) {
                        C4TCriterion crit = (C4TCriterion)sc;
                        if (crit.getMandatory() != 1) continue;
                        boolean isCompletedCriterion = false;
                        for (C4TPrice price : crit.getPrices()) {
                            if (!(price.getValue().getValue() > 0.0)) continue;
                            isCompletedCriterion = true;
                        }
                        if (!isCompletedCriterion) {
                            isCompletedEnvelope = false;
                        }
                        if (crit.getMandatorytAttachment() == null || crit.getMandatorytAttachment() != 1 || crit.getRelevantDoc() != null && !crit.getRelevantDoc().equals("")) continue;
                        isCompletedEnvelope = false;
                    }
                    isCompleted = isCompletedEnvelope ? C4TTreeNodeState.C4TTreeNodeIsCompleted.True : C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                }
            }
            C4TTreeNodeState state = new C4TTreeNodeState(JTreeC4TCompopnentType.C4TEnvelope, hasCriterions, isCompleted);
            enNode.setState(state);
            root.add(enNode);
            switch (hasCriterions) {
                case True: {
                    hasCriterionsRoot = hasCriterions;
                }
            }
            switch (isCompleted) {
                case False: {
                    isCompletedRoot = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                }
            }
        }
        C4TTreeNodeState rootState = new C4TTreeNodeState(JTreeC4TCompopnentType.C4TBody, C4TTreeNodeState.C4TTreeNodeHasCriterions.NotSupported, C4TTreeNodeState.C4TTreeNodeIsCompleted.NotSupported);
        switch (rootType) {
            case C4TLot: {
                rootState = new C4TTreeNodeState(JTreeC4TCompopnentType.C4TLot, hasCriterionsRoot, isCompletedRoot);
            }
        }
        root.setState(rootState);
        return root;
    }

    public static C4TTreeNode createNodes(List<C4TSectionComponent> sections, C4TTreeNode root, String sectionType, Long envelopeId, String lotId) {
        if (sections != null && sections.size() > 0) {
            C4TTreeNodeState.C4TTreeNodeIsCompleted isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.True;
            C4TTreeNodeState.C4TTreeNodeHasCriterions hasCriterions = C4TTreeNodeState.C4TTreeNodeHasCriterions.False;
            int criterionNumber = 0;
            int criterionCompleted = 0;
            Collections.sort(sections);
            for (C4TSectionComponent sc : sections) {
                switch (sc.getJType()) {
                    case C4TCriterion: {
                        String absoluteAttachmentPath;
                        File attachment;
                        ++criterionNumber;
                        C4TCriterion criterion = (C4TCriterion)sc;
                        criterion.setEnvelopeType(sectionType);
                        criterion.setEnvelopeId(envelopeId);
                        criterion.setLotId(lotId);
                        criterion.setSectionType(sectionType);
                        boolean isFromCertifictate = false;
                        Object usrObject = root.getUserObject();
                        if (usrObject != null && usrObject instanceof C4TSection && ((C4TSection)usrObject).isUseCertificate()) {
                            isFromCertifictate = true;
                        }
                        if (criterion.getType().equalsIgnoreCase("FILE") && criterion.getValue() != null && criterion.getValue().length() != 0 && (attachment = new File(absoluteAttachmentPath = FileUtils.makeAbsoluteAttachmentPath(criterion))) != null && attachment.exists()) {
                            criterion.setFileSize(attachment.length());
                        }
                        if (!isFromCertifictate && !C4TXStreamUtil.isCriterionCompleted(criterion)) {
                            isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                        } else {
                            ++criterionCompleted;
                        }
                        hasCriterions = C4TTreeNodeState.C4TTreeNodeHasCriterions.True;
                        break;
                    }
                    case C4TSection: {
                        C4TSection c4tSec = (C4TSection)sc;
                        c4tSec.setType(sectionType);
                        C4TTreeNode grandpa = new C4TTreeNode(c4tSec);
                        if (!c4tSec.getNodes().isEmpty()) {
                            grandpa = JTreeC4TComponentUtils.createNodes(c4tSec.getNodes(), grandpa, c4tSec.getType(), envelopeId, lotId);
                        }
                        C4TTreeNodeState childState = grandpa.getState();
                        boolean isUseCertificate = c4tSec.isUseCertificate();
                        if (!isUseCertificate) {
                            switch (childState.getIsCompleted()) {
                                case False: {
                                    isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.False;
                                }
                            }
                        } else {
                            isCompleted = C4TTreeNodeState.C4TTreeNodeIsCompleted.True;
                        }
                        hasCriterions = C4TTreeNodeState.C4TTreeNodeHasCriterions.True;
                        root.add(grandpa);
                        break;
                    }
                }
            }
            C4TTreeNodeState state = new C4TTreeNodeState(JTreeC4TCompopnentType.C4TSection, hasCriterions, isCompleted);
            root.setState(state);
            root.setCriterinsStats(criterionNumber, criterionCompleted);
        }
        return root;
    }

    public static void propagateTextValueToCriteria(C4TTreeNode root, BigInteger masterId, String value) {
        if (masterId == null) {
            return;
        }
        List<C4TCriterion> criteriaToChange = JTreeC4TComponentUtils.findCriterion(root, masterId);
        for (C4TCriterion criterion : criteriaToChange) {
            criterion.setValue(value);
        }
    }

    public static void propagateDateRangeFromValueToCriteria(C4TTreeNode root, BigInteger masterId, Date value) {
        if (masterId == null) {
            return;
        }
        List<C4TCriterion> criteriaToChange = JTreeC4TComponentUtils.findCriterion(root, masterId);
        for (C4TCriterion criterion : criteriaToChange) {
            criterion.getDate1().setValue(value);
        }
    }

    public static void propagateDateRangeToValueToCriteria(C4TTreeNode root, BigInteger masterId, Date value) {
        if (masterId == null) {
            return;
        }
        List<C4TCriterion> criteriaToChange = JTreeC4TComponentUtils.findCriterion(root, masterId);
        for (C4TCriterion criterion : criteriaToChange) {
            criterion.getDate2().setValue(value);
        }
    }

    protected static List<C4TCriterion> findCriterion(C4TTreeNode root, BigInteger masterId) {
        ArrayList<C4TCriterion> result = new ArrayList<C4TCriterion>();
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            C4TTreeNode element = (C4TTreeNode)children.nextElement();
            if (element.getUserObject() instanceof C4TLot) {
                JTreeC4TComponentUtils.findCriterionThroughEnvelopes(result, masterId, ((C4TLot)element.getUserObject()).getNodes());
            }
            if (!(element.getUserObject() instanceof C4TEnvelope)) continue;
            ArrayList<C4TEnvelope> list = new ArrayList<C4TEnvelope>();
            list.add((C4TEnvelope)element.getUserObject());
            JTreeC4TComponentUtils.findCriterionThroughEnvelopes(result, masterId, list);
        }
        return result;
    }

    protected static void findCriterionThroughEnvelopes(List<C4TCriterion> resultList, BigInteger masterId, List<C4TEnvelope> envelopes) {
        for (C4TEnvelope envelope : envelopes) {
            if (envelope.getNodes() == null) continue;
            for (C4TSectionComponent section : envelope.getNodes()) {
                JTreeC4TComponentUtils.findCriterionThroughSections(resultList, section, masterId);
            }
        }
    }

    protected static void findCriterionThroughSections(List<C4TCriterion> resultList, C4TSectionComponent section, BigInteger masterId) {
        switch (section.getJType()) {
            case C4TCriterion: {
                C4TCriterion crit = (C4TCriterion)section;
                if (crit.getMasterId() == null || !crit.getMasterId().equals(masterId)) break;
                resultList.add(crit);
                break;
            }
            case C4TSection: {
                for (C4TSectionComponent sectionOrCriterion : ((C4TSection)section).getNodes()) {
                    JTreeC4TComponentUtils.findCriterionThroughSections(resultList, sectionOrCriterion, masterId);
                }
                break;
            }
        }
    }
}

