/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.utils;

import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TJasperViewer;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class JasperUtil {
    private static String template = "jasper/Tender_Report.jasper";

    public static void getJasperTemplate() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("SUBREPORT_DIR", "jasper");
        params.put("REPORT_LOCALE", new Locale(C4TApplicationResources.language));
        try {
            ClassLoader clsLoader = Class.forName("com.eurodyn.eprocurement.tools.c4t.preparation.utils.JasperUtil").getClassLoader();
            JRXmlDataSource ds = new JRXmlDataSource(JasperUtil.getSortedXml(FileUtils.getCurrentFile()), "/c4t");
            InputStream templateReport = clsLoader.getResourceAsStream(template);
            JasperPrint aPrint = JasperFillManager.fillReport((InputStream)templateReport, params, (JRDataSource)ds);
            C4TJasperViewer.viewReport(aPrint);
        }
        catch (Exception e) {
            System.out.println("Error in jasper report");
            e.printStackTrace();
        }
    }

    public static File getSortedXml(File input) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        XMLOutputter xmlOutput = new XMLOutputter();
        Document document = builder.build(input);
        xmlOutput.setFormat(Format.getPrettyFormat());
        Element rootNode = document.getRootElement();
        ArrayList children = new ArrayList(rootNode.getChildren());
        boolean sorted = false;
        if (!sorted) {
            JasperUtil.sortEnvelopes(rootNode);
            for (Element child : rootNode.getChildren()) {
                if ("financial".equals(child.getAttributeValue("type")) || !"envelope".equals(child.getName())) continue;
                JasperUtil.sortChildren(child);
            }
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(input.getParent() + File.separator + "sorted_" + input.getName()), "UTF-8"));
        xmlOutput.output(document, (Writer)out);
        return new File(input.getParent() + File.separator + "sorted_" + input.getName());
    }

    private static void sortEnvelopes(Element parent) {
        Element tempLabel = null;
        ArrayList children = new ArrayList(parent.getChildren());
        if (((Element)children.get(0)).getAttribute("pos") != null) {
            parent.removeContent();
            for (int i = 0; i < children.size(); ++i) {
                if ("envelope".equals(((Element)children.get(i)).getName())) continue;
                tempLabel = (Element)children.get(i);
                children.remove(i);
            }
            Collections.sort(children, new Comparator<Element>(){

                @Override
                public int compare(Element child1, Element child2) {
                    int pos2;
                    int pos1 = Integer.parseInt(child1.getAttribute("pos").getValue());
                    if (pos1 > (pos2 = Integer.parseInt(child2.getAttribute("pos").getValue()))) {
                        return 1;
                    }
                    if (pos2 > pos1) {
                        return -1;
                    }
                    return 0;
                }
            });
            parent.addContent(children);
        }
    }

    private static void sortChildren(Element parent) {
        ArrayList<Element> children = new ArrayList<Element>(parent.getChildren());
        parent.removeContent();
        boolean levelOne = true;
        Element tempLabel = null;
        if (children.size() > 1 && ((Element)children.get(1)).getAttributeValue("level") != null && Integer.parseInt(((Element)children.get(1)).getAttributeValue("level")) > 1) {
            levelOne = false;
            tempLabel = (Element)children.get(0);
            children.remove(0);
        }
        if (children.size() != 0 && (((Element)children.get(0)).getName().equals("section") || ((Element)children.get(0)).getName().equals("criterion"))) {
            Collections.sort(children, new Comparator<Element>(){

                @Override
                public int compare(Element child1, Element child2) {
                    int pos2;
                    int pos1 = Integer.parseInt(child1.getAttribute("pos").getValue());
                    if (pos1 > (pos2 = Integer.parseInt(child2.getAttribute("pos").getValue()))) {
                        return 1;
                    }
                    if (pos2 > pos1) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        if (children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                if (!child.getName().equals("section")) continue;
                JasperUtil.sortChildren(child);
            }
        }
        if (!levelOne) {
            children.add(0, tempLabel);
        }
        parent.addContent(children);
    }
}

