/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.utils.security;

import com.eurodyn.eprocurement.tools.c4t.preparation.exception.C4TException;
import com.eurodyn.eprocurement.tools.c4t.preparation.exception.C4TExceptionCode;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.security.Base64Utils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.X509EncodedKeySpec;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class SecuritateUtil {
    private static SecuritateUtil instance = null;
    public static String RSA = "RSA/NONE/NoPadding";
    public static String AES = "AES/ECB/WithCTS";
    public static String AES_CBC = "AES/CBC/PKCS7Padding";
    static byte[] AES_CBC_IV;
    int keySize = 128;

    public static SecuritateUtil getInstance() {
        if (instance == null) {
            instance = new SecuritateUtil();
        }
        return instance;
    }

    private SecuritateUtil() {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        try {
            AES_CBC_IV = SecuritateUtil.decodeHex("00000000000000000000000000000000");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static byte[] decodeHex(String str) throws Exception {
        if (str == null) {
            throw new Exception("decodeHex: input was null");
        }
        if (str.length() % 2 != 0) {
            throw new Exception("decodeHex: input must be a multiple of 2");
        }
        Vector<Byte> byteVec = new Vector<Byte>();
        for (int x = 0; x < str.length(); x += 2) {
            byteVec.addElement(new Byte(new Integer(Integer.parseInt(str.substring(x, x + 2), 16)).byteValue()));
        }
        byte[] ctb = new byte[byteVec.size()];
        for (int i = 0; i < byteVec.size(); ++i) {
            ctb[i] = (Byte)byteVec.elementAt(i);
        }
        return ctb;
    }

    public final byte[] encryptWithAES(Key aesKey, byte[] plainFile) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(AES, BouncyCastleProvider.PROVIDER_NAME);
            cipher.init(1, aesKey);
            return cipher.doFinal(plainFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final byte[] encryptWithAES_CBC(Key aesKey, byte[] plainFile) throws C4TException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC, BouncyCastleProvider.PROVIDER_NAME);
            IvParameterSpec ps = new IvParameterSpec(AES_CBC_IV);
            cipher.init(1, aesKey, ps);
            return cipher.doFinal(plainFile);
        }
        catch (Exception e) {
            throw new C4TException(C4TExceptionCode.C4TEncrypting, e);
        }
    }

    public final byte[] encryptWithAES_CBC(Key aesKey, FileInputStream plainFile) throws C4TException {
        try {
            ByteBuffer mBuf = null;
            ByteBuffer mBufOut = null;
            try {
                FileChannel fChan = plainFile.getChannel();
                long fSize = fChan.size();
                mBuf = ByteBuffer.allocate((int)fSize);
                fChan.read(mBuf);
                mBuf.rewind();
                fChan.close();
                plainFile.close();
            }
            catch (IOException exc) {
                System.out.println("greska u baferima");
                System.out.println(exc);
            }
            System.out.println("bad encoding 001");
            Cipher cipher = Cipher.getInstance(AES_CBC, BouncyCastleProvider.PROVIDER_NAME);
            IvParameterSpec ps = new IvParameterSpec(AES_CBC_IV);
            System.out.println("bad encoding 002");
            cipher.init(1, aesKey, ps);
            System.out.println("bad encoding 003 = " + cipher.getOutputSize(mBuf.capacity()));
            mBufOut = ByteBuffer.allocate(cipher.getOutputSize(mBuf.capacity()));
            System.out.println("bad encoding 00end");
            cipher.doFinal(mBuf, mBufOut);
            mBufOut.rewind();
            return mBufOut.array();
        }
        catch (Exception e) {
            System.out.println("blalalala");
            e.printStackTrace();
            throw new C4TException(C4TExceptionCode.C4TEncrypting, e);
        }
    }

    public final byte[] decryptWithAES_CBC(Key aesKey, byte[] plainFile) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC, BouncyCastleProvider.PROVIDER_NAME);
            IvParameterSpec ps = new IvParameterSpec(AES_CBC_IV);
            cipher.init(2, aesKey, ps);
            byte[] result = cipher.doFinal(plainFile);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final byte[] decryptWithAES(Key aesKey, byte[] plainFile) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(AES, BouncyCastleProvider.PROVIDER_NAME);
            cipher.init(2, aesKey);
            byte[] result = cipher.doFinal(plainFile);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final Key generateAESKey() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES", BouncyCastleProvider.PROVIDER_NAME);
        keyGen.init(this.keySize);
        return keyGen.generateKey();
    }

    public final byte[] encryptKeyWithRSA(Key key, String publicKey, PublicKey pKey, String gg) throws Exception {
        try {
            byte[] keyBytes = key.getEncoded();
            Cipher cipher = Cipher.getInstance(RSA, BouncyCastleProvider.PROVIDER_NAME);
            cipher.init(1, pKey);
            return cipher.doFinal(keyBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final String encryptKeyWithRSA(Key key, String publicKey) throws C4TException {
        try {
            PublicKey rsaKey = SecuritateUtil.getPublicKeyFromString(publicKey);
            byte[] keyBytes = key.getEncoded();
            Cipher cipher = Cipher.getInstance(RSA, BouncyCastleProvider.PROVIDER_NAME);
            cipher.init(1, rsaKey);
            return Base64Utils.base64Encode(cipher.doFinal(keyBytes));
        }
        catch (Exception e) {
            throw new C4TException(C4TExceptionCode.C4TEncrypting, e);
        }
    }

    public static PublicKey getPublicKeyFromString(String key) throws C4TException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64Utils.base64Decode(key));
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            return publicKey;
        }
        catch (Exception e) {
            throw new C4TException(C4TExceptionCode.C4TEncrypting, e);
        }
    }

    public static PrivateKey getPrivateKeyFromString(String key) throws C4TException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec privateKeySpec = new X509EncodedKeySpec(Base64Utils.base64Decode(key));
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw new C4TException(C4TExceptionCode.C4TEncrypting, e);
        }
    }

    public final Key decryptKeyWithRSA(byte[] key, PrivateKey pKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(RSA, BouncyCastleProvider.PROVIDER_NAME);
            cipher.init(2, pKey);
            byte[] keys = cipher.doFinal(key);
            SecretKeySpec keyS = new SecretKeySpec(keys, "AES");
            return keyS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final Key decryptKeyWithRSA(String key, PrivateKey pKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(RSA, BouncyCastleProvider.PROVIDER_NAME);
            cipher.init(2, pKey);
            byte[] keys = cipher.doFinal(Base64Utils.base64Decode(key));
            SecretKeySpec keyS = new SecretKeySpec(keys, "AES");
            return keyS;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public KeyPair generatekeyPair() throws Exception {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(1024);
            KeyPair key = keyGen.generateKeyPair();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private PublicKey getPublicKey() throws GeneralSecurityException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        keyGen.initialize(1024, random);
        KeyPair pair = keyGen.generateKeyPair();
        PublicKey pk = pair.getPublic();
        return pk;
    }

    public final void encryptWithAES_CBC(Key aesKey, String fname, String encryptedFname) throws C4TException {
        int DATA_BLOCK_SIZE = 2048;
        try {
            int count;
            Cipher cipher = Cipher.getInstance(AES_CBC, BouncyCastleProvider.PROVIDER_NAME);
            IvParameterSpec ps = new IvParameterSpec(AES_CBC_IV);
            cipher.init(1, aesKey, ps);
            FileOutputStream fout = new FileOutputStream(encryptedFname);
            CipherOutputStream cout = new CipherOutputStream(fout, cipher);
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(fname));
            byte[] buffer = new byte[2048];
            while ((count = bin.read(buffer)) >= 0) {
                cout.write(buffer);
            }
            bin.close();
            cout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new C4TException(C4TExceptionCode.C4TEncrypting, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDigest getDigest(String fname) throws Exception {
        int DATA_BLOCK_SIZE = 2048;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        FileInputStream fin = new FileInputStream(fname);
        DigestInputStream din = new DigestInputStream(fin, digest);
        byte[] buffer = new byte[2048];
        try {
            while (din.read(buffer) >= 0) {
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            din.close();
        }
        return digest;
    }
}

