/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.xstream;

import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TLimit;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TScore;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TLimitConvertor;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.C4TFormulaComponent;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.List;

public class C4TFormula {
    @XStreamAlias(value="type")
    @XStreamAsAttribute
    String type;
    @XStreamAlias(value="lower-limit")
    @XStreamConverter(value=C4TLimitConvertor.class)
    C4TLimit lowerLimit;
    @XStreamAlias(value="upp-limit")
    @XStreamConverter(value=C4TLimitConvertor.class)
    C4TLimit upLimit;
    private List<C4TScore> scoreSS = new ArrayList<C4TScore>();

    public C4TFormula(String type) {
        this.setType(type);
    }

    public void add(C4TScore c4t) {
        this.scoreSS.add(c4t);
    }

    public void remove(C4TScore c4t) {
        this.scoreSS.remove(c4t);
    }

    public void print() {
        System.out.println("Formula type = " + this.getType());
        if (this.getLowerLimit() != null) {
            System.out.println("lowerLimir = " + this.getLowerLimit());
        }
        if (this.getUpLimit() != null) {
            System.out.println("upLimir = " + this.getUpLimit());
        }
        if (this.scoreSS != null) {
            System.out.println("Formula nodes  = ");
            for (C4TFormulaComponent c4TFormulaComponent : this.scoreSS) {
                c4TFormulaComponent.print();
            }
            System.out.println("Formula nodes  end ");
        }
        System.out.println("Formula End");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public C4TLimit getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(C4TLimit lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public C4TLimit getUpLimit() {
        return this.upLimit;
    }

    public void setUpLimit(C4TLimit upLimit) {
        this.upLimit = upLimit;
    }
}

