/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.xstream;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.JTreeC4TCompopnentType;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TPositiveInteger;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamUtil;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.interfaces.C4TSectionComponent;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="section")
public class C4TSection
implements C4TSectionComponent,
Comparable {
    transient String type;
    @XStreamAlias(value="type")
    @XStreamAsAttribute
    String sectionType;
    @XStreamAlias(value="useCertificate")
    @XStreamAsAttribute
    boolean useCertificate;
    @XStreamAlias(value="visited")
    @XStreamAsAttribute
    boolean visited;
    @XStreamAlias(value="id")
    @XStreamAsAttribute
    BigInteger id;
    @XStreamAlias(value="weight")
    @XStreamAsAttribute
    String weight;
    @XStreamAlias(value="level")
    @XStreamAsAttribute
    private Integer level;
    @XStreamAlias(value="pos")
    @XStreamAsAttribute
    private Integer position;
    @XStreamAlias(value="label")
    private String label;
    @XStreamAlias(value="threshold")
    C4TPositiveInteger threshold;
    private List<C4TSectionComponent> nodes = new ArrayList<C4TSectionComponent>();

    @Override
    public JTreeC4TCompopnentType getJType() {
        return JTreeC4TCompopnentType.C4TSection;
    }

    public C4TSection(String type, BigInteger id) {
        this.setType(type);
        this.setId(id);
    }

    public C4TSection(String type, BigInteger id, String weight) {
        this(type, id);
        this.setWeight(weight);
    }

    @Override
    public void print() {
        System.out.println("Begin Section---> sec Type = " + this.type + "sec Id = " + this.id);
        System.out.println("sec nodes = " + this.getNodes());
        if (this.getNodes() != null && this.getNodes().size() > 0) {
            for (C4TSectionComponent c4t : this.getNodes()) {
                c4t.print();
            }
        }
        System.out.println("End Section-------------------------->");
    }

    public void add(C4TSectionComponent c4t) {
        this.getNodes().add(c4t);
    }

    public void remove(C4TSectionComponent c4t) {
        this.getNodes().remove(c4t);
    }

    @Override
    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public List<C4TSectionComponent> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<C4TSectionComponent> nodes) {
        this.nodes = nodes;
    }

    @Override
    public String writeValues() {
        return C4TXStreamUtil.convertStringToISO_8859_1(C4TApplicationResources.getLabel("label.section")) + ": " + this.getLabel();
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean getVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public C4TPositiveInteger getThreshold() {
        return this.threshold;
    }

    public void setThreshold(C4TPositiveInteger threshold) {
        this.threshold = threshold;
    }

    public boolean isUseCertificate() {
        return this.useCertificate;
    }

    public void setUseCertificate(boolean useCertificate) {
        this.useCertificate = useCertificate;
    }

    public String getSectionType() {
        return this.sectionType;
    }

    public void setSectionType(String sectionType) {
        this.sectionType = sectionType;
    }

    public int compareTo(Object o) {
        int result = 0;
        if (o != null) {
            if (o instanceof C4TSection) {
                C4TSection section = (C4TSection)o;
                result = this.getLevel().compareTo(section.getLevel());
                if (result == 0) {
                    result = this.getPosition().compareTo(section.getPosition());
                }
            }
            if (o instanceof C4TCriterion) {
                C4TCriterion criterion = (C4TCriterion)o;
                result = this.getLevel().compareTo(criterion.getLevel());
                if (result == 0) {
                    result = this.getPosition().compareTo(criterion.getPosition());
                }
            }
        }
        return result;
    }
}

