/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter;

import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterionDate;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamConstants;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class C4TCriterionDateConvertor
implements Converter {
    public void marshal(Object marshalObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        SimpleDateFormat formatter = new SimpleDateFormat(C4TXStreamConstants.DATE_FORMAT);
        C4TCriterionDate date = (C4TCriterionDate)marshalObject;
        if (date.getFrom() != null) {
            writer.addAttribute("from", formatter.format(date.getFrom()));
        }
        if (date.getTo() != null) {
            writer.addAttribute("to", formatter.format(date.getTo()));
        }
        if (date.getValue() != null) {
            writer.setValue(formatter.format(date.getValue()));
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        C4TCriterionDate criterionDate = new C4TCriterionDate();
        SimpleDateFormat formatter = new SimpleDateFormat(C4TXStreamConstants.DATE_FORMAT);
        try {
            String fromString = reader.getAttribute("from");
            String toString = reader.getAttribute("to");
            if (fromString != null && fromString.length() > 0) {
                criterionDate.setFrom(formatter.parse(fromString));
            }
            if (toString != null && toString.length() > 0) {
                criterionDate.setTo(formatter.parse(toString));
            }
            String valueString = reader.getValue();
            if (reader.getValue() != null && reader.getValue().length() > 0) {
                criterionDate.setValue(formatter.parse(valueString));
            }
        }
        catch (ParseException numEx) {
            System.out.println("In case of refusing unmarshaling this error: fire exception CDate");
            System.out.println("Parsing error: values are not in excepted format");
            System.err.println("ERROR = " + numEx.getMessage());
            numEx.printStackTrace();
        }
        return criterionDate;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(C4TCriterionDate.class);
    }
}

