/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter;

import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterionValue;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class C4TCriterionValueConvertor
implements Converter {
    public void marshal(Object marshalObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        C4TCriterionValue criterionValue = (C4TCriterionValue)marshalObject;
        if (criterionValue.getYear() != null) {
            writer.addAttribute("year", criterionValue.getYear().toString());
        }
        if (criterionValue.getValue() != null) {
            writer.setValue(criterionValue.getValue());
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        C4TCriterionValue criterionValue = new C4TCriterionValue();
        try {
            String yearString = reader.getAttribute("year");
            if (yearString != null && yearString.length() > 0) {
                criterionValue.setYear(Integer.valueOf(yearString));
            }
            criterionValue.setValue(reader.getValue());
        }
        catch (NumberFormatException numEx) {
            System.out.println("In case of refusing unmarshaling this error: fire exception attribut year is wrong in CriterionValue ");
            System.err.println("ERROR = " + numEx);
            numEx.printStackTrace();
        }
        return criterionValue;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(C4TCriterionValue.class);
    }
}

