/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter;

import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TPrice;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TPositiveDouble;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class C4TPriceConverter
implements Converter {
    public void marshal(Object marshalObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        C4TPrice criterionValue = (C4TPrice)marshalObject;
        if (criterionValue.getYear() != null) {
            writer.addAttribute("year", criterionValue.getYear().toString());
        }
        if (criterionValue.getValue() != null) {
            writer.setValue(criterionValue.getValue().toStringDefault());
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        C4TPrice price = new C4TPrice();
        try {
            String yearString = reader.getAttribute("year");
            if (yearString != null && yearString.length() > 0) {
                price.setYear(Integer.valueOf(yearString));
            }
            price.setValue(new C4TPositiveDouble(reader.getValue()));
        }
        catch (NumberFormatException numEx) {
            System.out.println("In case of refusing unmarshaling this error: fire exception attribut year is wrong in CriterionValue ");
            System.err.println("ERROR = " + numEx);
            numEx.printStackTrace();
        }
        return price;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(C4TPrice.class);
    }
}

