/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter;

import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TScore;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class C4TScoreConverter
implements Converter {
    public void marshal(Object marshalObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        C4TScore score = (C4TScore)marshalObject;
        if (score.getLowerLimit() != null && !score.getLowerLimit().equals("")) {
            writer.addAttribute("lower-limit", score.getLowerLimit());
        }
        if (score.getUpperLimit() != null && !score.getUpperLimit().equals("")) {
            writer.addAttribute("upper-limit", score.getUpperLimit());
        }
        if (score.getOptionValue() != null && !score.getOptionValue().equals("")) {
            writer.addAttribute("option-value", score.getOptionValue());
        }
        if (score.getMin() != null && !score.getMin().equals("")) {
            writer.addAttribute("min", score.getMin());
        }
        if (score.getMax() != null && !score.getMax().equals("")) {
            writer.addAttribute("max", score.getMax());
        }
        if (score.getValue() != null) {
            writer.setValue(score.getValue().toString());
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        C4TScore score = new C4TScore();
        try {
            score.setLowerLimit(reader.getAttribute("lower-limit"));
            score.setUpperLimit(reader.getAttribute("upper-limit"));
            score.setMin(reader.getAttribute("min"));
            score.setMax(reader.getAttribute("max"));
            score.setOptionValue(reader.getAttribute("option-value"));
            if (reader.getValue() != null && reader.getValue().length() > 0) {
                score.setValue(Integer.valueOf(reader.getValue()));
            }
        }
        catch (Exception ex) {
            System.out.println("Error in C4TScoreConverter. Reason:" + ex.getMessage());
            ex.printStackTrace();
        }
        return score;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(C4TScore.class);
    }
}

