/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter;

import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TSetValue;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class C4TSetValueConvertor
implements Converter {
    public void marshal(Object marshalObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        C4TSetValue setValue = (C4TSetValue)marshalObject;
        writer.addAttribute("min", setValue.getMin());
        writer.addAttribute("max", setValue.getMax());
        writer.setValue(setValue.getValue().toString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        C4TSetValue setValue = new C4TSetValue();
        try {
            String minString = reader.getAttribute("min");
            String maxString = reader.getAttribute("max");
            setValue.setMin(minString);
            setValue.setMax(maxString);
            setValue.setValue(Integer.valueOf(reader.getValue()));
        }
        catch (NumberFormatException numEx) {
            System.out.println("In case of refusing unmarshaling this error: fire exception setvalue");
            System.err.println("ERROR = " + numEx);
            numEx.printStackTrace();
        }
        return setValue;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(C4TSetValue.class);
    }
}

