/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper;

import com.eurodyn.eprocurement.tools.c4t.preparation.components.C4TCriterionType;
import com.eurodyn.eprocurement.tools.c4t.preparation.components.factory.CriterionErrors;
import com.eurodyn.eprocurement.tools.c4t.preparation.exception.C4TException;
import com.eurodyn.eprocurement.tools.c4t.preparation.exception.C4TExceptionCode;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TBody;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterion;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterionOption;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TCriterionValue;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TEnvelope;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TFormula;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TLot;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TPrice;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TScore;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TSection;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TSetValue;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TBigDecimalConvertor;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TBooleanTrueFalseConvertor;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TPositiveBigDecimalConvertor;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TPositiveDoubleConvertor;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.converter.C4TPositiveIntegerConvertor;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.helper.C4TXStreamConstants;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.Annotations;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C4TXStreamUtil {
    public static String convertStringToUTF(String label) {
        String newLabel = label;
        try {
            newLabel = new String(label.getBytes("UTF8"), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("ERROR: UnsupportedEncodingException");
            e.printStackTrace();
        }
        return newLabel;
    }

    public static String convertStringToISO_8859_1(String label) {
        String newLabel = label;
        try {
            newLabel = new String(label.getBytes("UTF8"), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("ERROR: UnsupportedEncodingException");
            e.printStackTrace();
        }
        return newLabel;
    }

    public static XStream createXStream() {
        XStream xstream = new XStream(){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public Class<?> realClass(String elementName) {
                        try {
                            return super.realClass(elementName);
                        }
                        catch (CannotResolveClassException e) {
                            System.out.println("Unable to resolve class for element name " + elementName + ". Null being returned.");
                            return null;
                        }
                    }
                };
            }
        };
        xstream.setMode(1001);
        xstream.addImplicitCollection(C4TEnvelope.class, "nodes");
        xstream.addImplicitCollection(C4TSection.class, "nodes");
        xstream.addImplicitCollection(C4TFormula.class, "scoreSS");
        xstream.addImplicitCollection(C4TCriterion.class, "valueNodes");
        xstream.addImplicitCollection(C4TLot.class, "nodes");
        xstream.addImplicitCollection(C4TBody.class, "lots", C4TLot.class);
        xstream.addImplicitCollection(C4TBody.class, "envelopes", C4TEnvelope.class);
        String[] acceptableFormats = new String[2];
        SimpleDateFormat df = new SimpleDateFormat(C4TXStreamConstants.DATE_FORMAT);
        DateConverter dc = new DateConverter(df.toPattern(), acceptableFormats);
        xstream.registerConverter((SingleValueConverter)dc);
        xstream.registerConverter((SingleValueConverter)new C4TPositiveIntegerConvertor());
        xstream.registerConverter((SingleValueConverter)new C4TPositiveDoubleConvertor());
        xstream.registerConverter((SingleValueConverter)new C4TPositiveBigDecimalConvertor());
        xstream.registerConverter((SingleValueConverter)new C4TBigDecimalConvertor());
        xstream.registerConverter((SingleValueConverter)new C4TBooleanTrueFalseConvertor());
        xstream.registerConverter((SingleValueConverter)BooleanConverter.BINARY);
        Annotations.configureAliases((XStream)xstream, (Class[])new Class[]{C4TBody.class, C4TLot.class, C4TEnvelope.class, C4TSection.class, C4TCriterion.class, C4TFormula.class, C4TScore.class, C4TSetValue.class, C4TCriterionOption.class, C4TCriterionValue.class, C4TPrice.class});
        return xstream;
    }

    public static C4TBody readFromFile(String fileName, XStream xstream) throws C4TException {
        C4TBody body = new C4TBody();
        try {
            body = (C4TBody)xstream.fromXML((Reader)new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF8"));
        }
        catch (Exception ex) {
            System.out.println("Error");
            ex.printStackTrace();
            throw new C4TException(C4TExceptionCode.C4TXMLParsing, ex);
        }
        if (body == null) {
            throw new C4TException(C4TExceptionCode.C4TXMLParsing);
        }
        return body;
    }

    public static void writeToFile(File fileName, XStream xstream, C4TBody body) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF8"));
            xstream.toXML((Object)body, (Writer)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error writing file: " + fileName);
        }
    }

    public static ByteArrayInputStream extractEnvelopesBySequence(C4TBody body, int sequenceNum, List<String> envelopesIds) throws C4TException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream is = null;
        boolean envelopesExist = false;
        try {
            List<C4TLot> lots;
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, "UTF8");
            XStream xstream = C4TXStreamUtil.createXStream();
            List<C4TEnvelope> envelopes = body.getEnvelopes();
            C4TBody newSequenceBody = new C4TBody(body);
            if (envelopes != null && envelopes.size() > 0) {
                for (C4TEnvelope en : envelopes) {
                    if (en.getSequence() != sequenceNum) continue;
                    newSequenceBody.getEnvelopes().add(en);
                    envelopesIds.add(en.getId().toString());
                    envelopesExist = true;
                }
            }
            if ((lots = body.getLots()) != null && lots.size() > 0) {
                for (C4TLot lt : lots) {
                    C4TLot lot = new C4TLot(lt);
                    if (lot.getIncluded_in_submission() == null) {
                        lot.setIncluded_in_submission("no");
                    }
                    for (C4TEnvelope en : lt.getNodes()) {
                        if (en.getSequence() != sequenceNum) continue;
                        lot.getNodes().add(en);
                        envelopesIds.add(en.getId().toString());
                        envelopesExist = true;
                    }
                    if (lot.getNodes() == null || lot.getNodes().size() <= 0) continue;
                    newSequenceBody.getLots().add(lot);
                }
            }
            if (!envelopesExist) {
                throw new C4TException(C4TExceptionCode.C4TXMLParsing, new Exception("There are no envelopes for package sequence " + sequenceNum));
            }
            xstream.toXML((Object)newSequenceBody, (Writer)osw);
            is = new ByteArrayInputStream(out.toByteArray());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return is;
    }

    public static ByteArrayInputStream extractProofAndTecnicalXML(C4TBody body) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream is = null;
        try {
            List<C4TLot> lots;
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, "UTF8");
            XStream xstream = C4TXStreamUtil.createXStream();
            List<C4TEnvelope> envelopes = body.getEnvelopes();
            C4TBody proofTehnicalBody = new C4TBody(body);
            if (envelopes != null && envelopes.size() > 0) {
                for (C4TEnvelope en : envelopes) {
                    if (!en.getType().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_SECTION_TYPE_PROOF) && !en.getType().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_SECTION_TYPE_TECHNICAL)) continue;
                    proofTehnicalBody.getEnvelopes().add(en);
                }
            }
            if ((lots = body.getLots()) != null && lots.size() > 0) {
                for (C4TLot lt : lots) {
                    C4TLot tehnicalLot = new C4TLot(lt);
                    if (tehnicalLot.getIncluded_in_submission() == null) {
                        tehnicalLot.setIncluded_in_submission("no");
                    }
                    for (C4TEnvelope en : lt.getNodes()) {
                        if (!en.getType().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_SECTION_TYPE_TECHNICAL)) continue;
                        tehnicalLot.getNodes().add(en);
                        proofTehnicalBody.getLots().add(tehnicalLot);
                    }
                }
            }
            xstream.toXML((Object)proofTehnicalBody, (Writer)osw);
            is = new ByteArrayInputStream(out.toByteArray());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return is;
    }

    public static ByteArrayInputStream extractFinancialXML(C4TBody body) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream is = null;
        try {
            List<C4TLot> lots;
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, "UTF8");
            XStream xstream = C4TXStreamUtil.createXStream();
            List<C4TEnvelope> envelopes = body.getEnvelopes();
            C4TBody financialBody = new C4TBody(body);
            if (envelopes != null && envelopes.size() > 0) {
                for (C4TEnvelope en : envelopes) {
                    if (!en.getType().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_SECTION_TYPE_FINANCIAL)) continue;
                    financialBody.getEnvelopes().add(en);
                }
            }
            if ((lots = body.getLots()) != null && lots.size() > 0) {
                for (C4TLot lt : lots) {
                    C4TLot financialLot = new C4TLot(lt);
                    if (financialLot.getIncluded_in_submission() == null) {
                        financialLot.setIncluded_in_submission("no");
                    }
                    for (C4TEnvelope en : lt.getNodes()) {
                        if (!en.getType().equalsIgnoreCase(C4TXStreamConstants.C4T_XML_SECTION_TYPE_FINANCIAL)) continue;
                        financialLot.getNodes().add(en);
                        financialBody.getLots().add(financialLot);
                    }
                }
            }
            xstream.toXML((Object)financialBody, (Writer)osw);
            is = new ByteArrayInputStream(out.toByteArray());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return is;
    }

    public static C4TCriterionType figureOutCriterionType(C4TCriterion criterion) {
        if (criterion.getType().equalsIgnoreCase("TEXT")) {
            return C4TCriterionType.Text;
        }
        if (criterion.getType().equalsIgnoreCase("AREA")) {
            return C4TCriterionType.Area;
        }
        if (criterion.getType().equalsIgnoreCase("NUMERIC")) {
            return C4TCriterionType.Numeric;
        }
        if (criterion.getType().equalsIgnoreCase("DATE")) {
            return C4TCriterionType.Date;
        }
        if (criterion.getType().equalsIgnoreCase("DATE_RANGE")) {
            return C4TCriterionType.Daterange;
        }
        if (criterion.getType().equalsIgnoreCase("FILE")) {
            return C4TCriterionType.File;
        }
        if (criterion.getType().equalsIgnoreCase("LIST")) {
            return C4TCriterionType.List;
        }
        return C4TCriterionType.Error;
    }

    public static CriterionErrors isFinancialNumericCriterionCompletedWithError(C4TCriterion criterion) {
        if (criterion.getPrices() != null && criterion.getPrices().size() > 0) {
            List<Object> prices = new ArrayList();
            prices = criterion.getPrices();
            boolean priceCompleted = false;
            for (C4TPrice c4TPrice : prices) {
                if (c4TPrice.getValue().toString().equalsIgnoreCase("0.0")) continue;
                priceCompleted = true;
                break;
            }
            if (!priceCompleted) {
                if (criterion.getMandatorytAttachment() != null && criterion.getMandatorytAttachment() == 1 && (criterion.getRelevantDoc() == null || criterion.getRelevantDoc().equals(""))) {
                    return CriterionErrors.MANDATORY_ALL;
                }
                return CriterionErrors.MANDATORY_ERROR;
            }
            if (criterion.getMandatorytAttachment() != null && criterion.getMandatorytAttachment() == 1 && (criterion.getRelevantDoc() == null || criterion.getRelevantDoc().equals(""))) {
                return CriterionErrors.MANDATORY_ATTACH_ERROR;
            }
        }
        return CriterionErrors.NO_ERROR;
    }

    public static CriterionErrors isCriterionCompletedWithError(C4TCriterion criterion) {
        boolean mandatory;
        C4TCriterionType criterionType = C4TXStreamUtil.figureOutCriterionType(criterion);
        boolean bl = mandatory = criterion.getMandatory() != 0;
        if (mandatory) {
            switch (criterionType) {
                case Text: 
                case Area: 
                case Numeric: 
                case Date: 
                case List: 
                case File: {
                    if (criterion.getValue() != null && criterion.getValue().length() != 0) break;
                    return CriterionErrors.MANDATORY_ERROR;
                }
                case Daterange: {
                    if (criterion.getDate1() == null || criterion.getDate1().getValue() == null) {
                        return CriterionErrors.MANDATORY_ERROR;
                    }
                    if (criterion.getDate2() != null && criterion.getDate2().getValue() != null) break;
                    return CriterionErrors.MANDATORY_ERROR;
                }
            }
        }
        switch (criterionType) {
            case Text: 
            case Area: {
                if (criterion.getSize() == null || criterion.getSize().getValue() <= 0 || C4TXStreamUtil.convertStringToUTF(criterion.getValue()).length() <= criterion.getSize().getValue()) break;
                return CriterionErrors.TEXT_SIZE_ERROR;
            }
            case Daterange: {
                if ((criterion.getDate1() == null || criterion.getDate1().getValue() == null) && (criterion.getDate2() == null || criterion.getDate2().getValue() == null)) break;
                if (criterion.getDate1() == null || criterion.getDate1().getValue() == null) {
                    return CriterionErrors.DATE_RANGE_MISSING_FROM;
                }
                if (criterion.getDate2() == null || criterion.getDate2().getValue() == null) {
                    return CriterionErrors.DATE_RANGE_MISSING_TO;
                }
                if (!criterion.getDate1().getValue().after(criterion.getDate2().getValue())) break;
                return CriterionErrors.DATE_RANGE_INVALID;
            }
            case File: {
                long fileSizeMB;
                if (criterion.getSize() == null || criterion.getSize().getValue() <= 0 || (fileSizeMB = criterion.getFileSize() / 0x100000L) <= (long)criterion.getSize().getValue().intValue()) break;
                return CriterionErrors.FILE_SIZE_ERROR;
            }
            case Numeric: {
                break;
            }
        }
        return CriterionErrors.NO_ERROR;
    }

    public static boolean isCriterionCompleted(C4TCriterion criterion) {
        if (criterion.getSupplierReadOnly() != null && criterion.getSupplierReadOnly().booleanValue()) {
            return true;
        }
        C4TCriterionType criterionType = C4TXStreamUtil.figureOutCriterionType(criterion);
        switch (criterionType) {
            case Text: {
                return C4TXStreamUtil.isCriterionTextCompleted(criterion);
            }
            case Area: {
                return C4TXStreamUtil.isCriterionAreaCompleted(criterion);
            }
            case Numeric: {
                return C4TXStreamUtil.isCriterionNumericCompleted(criterion);
            }
            case Date: {
                return C4TXStreamUtil.isCriterionDateCompleted(criterion);
            }
            case Daterange: {
                return C4TXStreamUtil.isCriterionDateRangeCompleted(criterion);
            }
            case File: {
                return C4TXStreamUtil.isCriterionFileCompleted(criterion);
            }
            case List: {
                return C4TXStreamUtil.isCriterionListCompleted(criterion);
            }
        }
        return true;
    }

    private static boolean isCriterionTextCompleted(C4TCriterion criterion) {
        if (criterion.getValue() != null && criterion.getValue().length() != 0) {
            if (criterion.getSize() == null || criterion.getSize().getValue() <= 0) {
                return true;
            }
            return C4TXStreamUtil.convertStringToUTF(criterion.getValue()).length() <= criterion.getSize().getValue();
        }
        return criterion.getMandatory() == 0;
    }

    private static boolean isCriterionAreaCompleted(C4TCriterion criterion) {
        if (criterion.getValue() != null && criterion.getValue().length() != 0) {
            if (criterion.getSize() == null || criterion.getSize().getValue() <= 0) {
                return true;
            }
            return C4TXStreamUtil.convertStringToUTF(criterion.getValue()).length() <= criterion.getSize().getValue();
        }
        return criterion.getMandatory() == 0;
    }

    public static boolean isFinancialNumericCriterionCompleted(C4TCriterion criterion) {
        boolean priceCompleted = false;
        if (criterion.getMandatorytAttachment() != null && criterion.getMandatorytAttachment() == 1 && (criterion.getRelevantDoc() == null || criterion.getRelevantDoc().equals(""))) {
            return priceCompleted;
        }
        if (criterion.getPrices() != null && criterion.getPrices().size() > 0) {
            List<Object> prices = new ArrayList();
            prices = criterion.getPrices();
            for (C4TPrice c4TPrice : prices) {
                if (c4TPrice.getValue().toString().equalsIgnoreCase("0.0")) continue;
                priceCompleted = true;
                return priceCompleted;
            }
        }
        return priceCompleted;
    }

    private static boolean isCriterionNumericCompleted(C4TCriterion criterion) {
        if (criterion.getValue() != null && criterion.getValue().length() != 0) {
            try {
                BigDecimal value = new BigDecimal(criterion.getValue());
                if (criterion.getMax() != null && criterion.getMax().getIsPresent().booleanValue() && value.compareTo(criterion.getMax().getValue()) == 1) {
                    return false;
                }
                if (criterion.getMin() != null && criterion.getMin().getIsPresent().booleanValue()) {
                    if (value.compareTo(criterion.getMin().getValue()) == -1) {
                        return false;
                    }
                    if (criterion.getStep() != null) {
                        try {
                            if (criterion.getStep().getValue().compareTo(new BigDecimal("0")) == 1) {
                                return value.subtract(criterion.getMin().getValue()).remainder(criterion.getStep().getValue()).compareTo(new BigDecimal("0")) == 0;
                            }
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                }
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return criterion.getMandatory() == 0;
    }

    private static boolean isCriterionDateCompleted(C4TCriterion criterion) {
        return criterion.getValue() != null && criterion.getValue().length() != 0 || criterion.getMandatory() == 0;
    }

    private static boolean isCriterionDateRangeCompleted(C4TCriterion criterion) {
        boolean isDate1 = criterion.getDate1() != null && criterion.getDate1().getValue() != null;
        boolean isDate2 = criterion.getDate2() != null && criterion.getDate2().getValue() != null;
        boolean isRangeValid = false;
        if (isDate1 && isDate2 && criterion.getDate1().getValue().before(criterion.getDate2().getValue())) {
            isRangeValid = true;
        }
        if (isRangeValid) {
            return true;
        }
        if (criterion.getMandatory() != 0) {
            return false;
        }
        return !isDate1 && !isDate2;
    }

    private static boolean isCriterionFileCompleted(C4TCriterion criterion) {
        if (criterion.getValue() != null && criterion.getValue().length() != 0) {
            if (criterion.getSize() == null || criterion.getSize().getValue() <= 0) {
                return true;
            }
            long fileSizeMB = criterion.getFileSize() / 0x100000L;
            return fileSizeMB <= (long)criterion.getSize().getValue().intValue();
        }
        return criterion.getMandatory() == 0;
    }

    private static boolean isCriterionListCompleted(C4TCriterion criterion) {
        return criterion.getMandatory() == 0 || criterion.getValue() != null && criterion.getValue().length() != 0;
    }

    public static int getMaxSequenceNum(C4TBody body) {
        int maxSequenceNum = 0;
        ArrayList<C4TEnvelope> totalEnvelopes = new ArrayList<C4TEnvelope>();
        List<C4TEnvelope> envelopes = body.getEnvelopes();
        List<C4TLot> lots = body.getLots();
        if (envelopes != null && envelopes.size() > 0) {
            totalEnvelopes.addAll(envelopes);
        }
        if (lots != null && lots.size() > 0) {
            for (C4TLot lot : lots) {
                List<C4TEnvelope> lotEnvelopes = lot.getNodes();
                if (lotEnvelopes == null || lotEnvelopes.size() <= 0) continue;
                totalEnvelopes.addAll(lotEnvelopes);
            }
        }
        for (C4TEnvelope en : totalEnvelopes) {
            int envSequence = en.getSequence();
            if (envSequence <= maxSequenceNum) continue;
            maxSequenceNum = envSequence;
        }
        return maxSequenceNum;
    }
}

