/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.eprocurement.tools.c4t.preparation.xstream.pack;

import com.eurodyn.eprocurement.tools.c4t.preparation.utils.C4TApplicationResources;
import com.eurodyn.eprocurement.tools.c4t.preparation.utils.FileUtils;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.C4TBody;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.pack.C4TEnvelopePack;
import com.eurodyn.eprocurement.tools.c4t.preparation.xstream.pack.C4TTenderMetadataPack;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.Annotations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C4TTenderMetadataPackUtil {
    public static void createXStreamTenderMetaDataPack(ZipOutputStream cpZipOutputStream, List<C4TEnvelopePack> envelopeLst, C4TBody body) {
        XStream xstream = new XStream();
        Annotations.configureAliases((XStream)xstream, (Class[])new Class[]{C4TTenderMetadataPack.class, C4TEnvelopePack.class});
        C4TTenderMetadataPack tenderMetadataPack = new C4TTenderMetadataPack(envelopeLst);
        tenderMetadataPack.setCftid(body.getCftid());
        tenderMetadataPack.setRound(body.getRound());
        if (C4TApplicationResources.getBooleanProperty("version.control.enabled", false)) {
            tenderMetadataPack.setTptversion(C4TApplicationResources.PACK_PROPS.getProperty("tpt.version"));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        xstream.toXML((Object)tenderMetadataPack, (OutputStream)out);
        String tmpFileName = FileUtils.getCurrentFile().getParent() + File.separator + FileUtils.getCurrentFile().getName().substring(0, FileUtils.getCurrentFile().getName().length() - 4) + ".zip";
        int DATA_BLOCK_SIZE = 2048;
        try {
            int byteCount;
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            ZipEntry cpZipEntry = new ZipEntry("tendermetadata.xml");
            cpZipOutputStream.putNextEntry(cpZipEntry);
            byte[] b = new byte[2048];
            while ((byteCount = in.read(b, 0, 2048)) != -1) {
                cpZipOutputStream.write(b, 0, byteCount);
            }
            cpZipOutputStream.closeEntry();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

